/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud.db;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.PluginLoader;
import edu.umd.cs.findbugs.ProjectPackagePrefixes;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.StartTime;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.cloud.AbstractCloud;
import edu.umd.cs.findbugs.cloud.BugFilingCommentHelper;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.cloud.CloudFactory;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import edu.umd.cs.findbugs.cloud.db.DriverShim;
import edu.umd.cs.findbugs.cloud.db.IPAddressLookup;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCloud
extends AbstractCloud {
    public static final String FINDBUGS_USER_PROPERTY = "findbugsUser";
    static final long FIRST_LIGHT = 1000000000000L;
    static final long ONE_DAY = 86400000L;
    static final String USER_NAME = "user.name";
    private Cloud.SigninState signinState = Cloud.SigninState.SIGNING_IN;
    int updatesSentToDatabase;
    Date lastUpdate = new Date();
    Date resync;
    Date attemptedResync;
    IPAddressLookup ipAddressLookup;
    int resyncCount;
    final Map<String, BugData> instanceMap = new HashMap<String, BugData>();
    final Map<Integer, BugData> idMap = new HashMap<Integer, BugData>();
    final IdentityHashMap<BugDesignation, Integer> bugDesignationId = new IdentityHashMap();
    private BugFilingCommentHelper bugFilingCommentHelper = new BugFilingCommentHelper(this);
    final long now;
    final Pattern FORBIDDEN_PACKAGE_PREFIXES = Pattern.compile(this.properties.getProperty("findbugs.forbiddenPackagePrefixes", " none ").replace(',', '|'));
    final boolean PROMPT_FOR_USER_NAME = this.properties.getBoolean("findbugs.cloud.promptForUserName", false);
    int sessionId = -1;
    final CountDownLatch initialSyncDone = new CountDownLatch(1);
    final CountDownLatch bugsPopulated = new CountDownLatch(1);
    AtomicBoolean communicationInitiated = new AtomicBoolean(false);
    private static final long LAST_SEEN_UPDATE_WINDOW = TimeUnit.MILLISECONDS.convert(604800L, TimeUnit.SECONDS);
    static boolean invocationRecorded;
    boolean scheduled = false;
    int numSkipped = 0;
    final int MAX_DB_RANK = this.properties.getInt("findbugs.db.maxrank", 14);
    final String url;
    final String dbUser;
    final String dbPassword;
    final String dbName;
    String findbugsUser;
    ProjectPackagePrefixes projectMapping = new ProjectPackagePrefixes();
    Map<String, String> prefixBugComponentMapping = new HashMap<String, String>();
    private final String sqlDriver;
    final LinkedBlockingQueue<Update> queue = new LinkedBlockingQueue();
    volatile boolean shutdown = false;
    volatile boolean startShutdown = false;
    final DatabaseSyncTask runner = new DatabaseSyncTask();
    final Thread runnerThread = new Thread((Runnable)this.runner, "Database synchronization thread");
    final Timer resyncTimer = new Timer("Resync scheduler", true);
    private RuntimeException shutdownException = new RuntimeException("DBCloud shutdown");
    private static final String HAS_SKIPPED_BUG = "has_skipped_bugs";
    public static final String PENDING = "-- pending --";
    public static final String NONE = "none";
    static final int MAX_URL_LENGTH = 1999;
    private static final String HAS_FILED_BUGS = "has_filed_bugs";
    private static final String HAS_CLASSIFIED_ISSUES = "has_classified_issues";
    private boolean firstBugRequest = true;
    final String BUG_LINK_FORMAT = this.properties.getProperty("findbugs.filebug.link");
    final String BUG_LOGIN_LINK = this.properties.getProperty("findbugs.filebug.login");
    final String BUG_LOGIN_MSG = this.properties.getProperty("findbugs.filebug.loginMsg");
    final String COMPONENT_FOR_BAD_ANALYSIS = this.properties.getProperty("findbugs.filebug.badAnalysisComponent");
    String errorMsg;
    long errorTime = 0L;

    BugData getBugData(String instanceHash) {
        BugData bd = this.instanceMap.get(instanceHash);
        if (bd == null) {
            bd = new BugData(instanceHash);
            this.instanceMap.put(instanceHash, bd);
        }
        return bd;
    }

    BugData getBugData(BugInstance bug) {
        try {
            this.initialSyncDone.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        BugData bugData = this.getBugData(bug.getInstanceHash());
        bugData.bugs.add(bug);
        return bugData;
    }

    void loadDatabaseInfo(String hash, int id, long firstSeen, long lastSeen) {
        BugData bd = this.instanceMap.get(hash);
        firstSeen = this.sanityCheckFirstSeen(firstSeen);
        lastSeen = this.sanityCheckLastSeen(lastSeen);
        if (bd == null) {
            return;
        }
        if (this.idMap.containsKey(id)) {
            assert (bd == this.idMap.get(id));
            assert (bd.id == id);
            assert (bd.firstSeen == firstSeen);
        } else {
            bd.id = id;
            bd.firstSeen = firstSeen;
            bd.lastSeen = lastSeen;
            bd.inDatabase = true;
            this.idMap.put(id, bd);
        }
        if (bd.firstSeen < 1000000000000L) {
            throw new IllegalStateException("Bug has first seen of " + new Date(bd.firstSeen));
        }
    }

    public DBCloud(CloudPlugin plugin, BugCollection bugs, Properties properties) {
        super(plugin, bugs, properties);
        this.sqlDriver = this.getJDBCProperty("dbDriver");
        this.url = this.getJDBCProperty("dbUrl");
        this.dbName = this.getJDBCProperty("dbName");
        this.dbUser = this.getJDBCProperty("dbUser");
        this.dbPassword = this.getJDBCProperty("dbPassword");
        this.findbugsUser = this.getCloudProperty(FINDBUGS_USER_PROPERTY);
        if (this.PROMPT_FOR_USER_NAME) {
            this.ipAddressLookup = new IPAddressLookup();
        }
        this.now = System.currentTimeMillis();
    }

    long sanityCheckFirstSeen(long time) {
        if (time < 1000000000000L) {
            return this.now;
        }
        return time;
    }

    long sanityCheckLastSeen(long time) {
        if (time > this.now + 86400000L) {
            return this.now;
        }
        return time;
    }

    @Override
    public boolean availableForInitialization() {
        String msg = String.format("%s %s %s %s", this.sqlDriver, this.dbUser, this.url, this.dbPassword);
        if (CloudFactory.DEBUG) {
            System.out.println("DB properties: " + msg);
        }
        if (this.sqlDriver == null || this.dbUser == null || this.url == null || this.dbPassword == null) {
            if (CloudFactory.DEBUG) {
                this.bugCollection.getProject().getGuiCallback().showMessageDialog(msg);
            }
            return false;
        }
        return true;
    }

    @Override
    public void bugsPopulated() {
        this.bugsPopulated.countDown();
    }

    @Override
    public void initiateCommunication() {
        this.bugsPopulated();
        if (this.communicationInitiated.compareAndSet(false, true)) {
            this.queue.add(new PopulateBugs(true));
        }
    }

    long boundDuration(long milliseconds) {
        if (milliseconds < 0L) {
            return 0L;
        }
        if (milliseconds > 1000000L) {
            return 1000000L;
        }
        return milliseconds;
    }

    private static String limitToMaxLength(String s, int maxLength) {
        if (s.length() <= maxLength) {
            return s;
        }
        return s.substring(0, maxLength);
    }

    private String getJDBCProperty(String propertyName) {
        return this.properties.getProperty("findbugs.jdbc." + propertyName);
    }

    Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.dbUser, this.dbPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean initialize() throws IOException {
        boolean bl;
        if (this.tryInitialization()) {
            this.signinState = Cloud.SigninState.SIGNIN_FAILED;
            return false;
        }
        this.signinState = Cloud.SigninState.SIGNED_IN;
        this.loadBugComponents();
        Connection c = null;
        try {
            Class<?> driverClass;
            try {
                driverClass = this.getClass().getClassLoader().loadClass(this.sqlDriver);
            }
            catch (ClassNotFoundException e) {
                try {
                    driverClass = this.plugin.getClassLoader().loadClass(this.sqlDriver);
                }
                catch (ClassNotFoundException e2) {
                    driverClass = Class.forName(this.sqlDriver);
                }
            }
            if (CloudFactory.DEBUG) {
                System.out.println("Loaded " + driverClass.getName());
            }
            DriverManager.registerDriver(new DriverShim((Driver)driverClass.newInstance()));
            c = this.getConnection();
            Statement stmt = c.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) from  findbugs_issue");
            boolean result = false;
            if (rs.next()) {
                result = true;
            }
            rs.close();
            stmt.close();
            c.close();
            if (result) {
                this.runnerThread.setDaemon(true);
                this.runnerThread.start();
                boolean bl2 = true;
                Util.closeSilently(c);
                return bl2;
            }
            bl = false;
            Util.closeSilently(c);
        }
        catch (RuntimeException e) {
            this.displayMessage("Unable to connect to " + this.dbName, e);
            boolean bl3 = false;
            return bl3;
        }
        catch (Exception e2) {
            this.displayMessage("Unable to connect to " + this.dbName, e2);
            boolean bl4 = false;
            return bl4;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Util.closeSilently(c);
        }
        return bl;
    }

    @Override
    public void waitUntilIssueDataDownloaded() {
        this.initiateCommunication();
        try {
            this.initialSyncDone.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean tryInitialization() throws IOException {
        if (!super.initialize()) {
            return true;
        }
        if (!this.availableForInitialization()) {
            return true;
        }
        this.findbugsUser = this.getUsernameLookup().getUsername();
        return this.findbugsUser == null;
    }

    private String getBugComponent(@SlashedClassName String className) {
        int longestMatch = -1;
        String result = null;
        for (Map.Entry<String, String> e : this.prefixBugComponentMapping.entrySet()) {
            String key = e.getKey();
            if (!className.startsWith(key) || longestMatch >= key.length()) continue;
            longestMatch = key.length();
            result = e.getValue();
        }
        return result;
    }

    private void loadBugComponents() {
        try {
            URL u = PluginLoader.getCoreResource("bugComponents.properties");
            if (u != null) {
                String s;
                BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream()));
                while ((s = in.readLine()) != null) {
                    if (s.trim().length() == 0) continue;
                    int x = s.indexOf(32);
                    if (x == -1) {
                        if (this.prefixBugComponentMapping.containsKey("")) continue;
                        this.prefixBugComponentMapping.put("", s);
                        continue;
                    }
                    String prefix = s.substring(x + 1);
                    if (this.prefixBugComponentMapping.containsKey(prefix)) continue;
                    this.prefixBugComponentMapping.put(prefix, s.substring(0, x));
                }
                in.close();
            }
        }
        catch (IOException e) {
            AnalysisContext.logError("Unable to load bug component properties", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        block13: {
            try {
                this.startShutdown = true;
                this.resyncTimer.cancel();
                this.queue.add(new ShutdownTask());
                Connection c = null;
                try {
                    c = this.getConnection();
                    PreparedStatement setEndTime = c.prepareStatement("UPDATE  findbugs_invocation SET endTime = ? WHERE id = ?");
                    Timestamp date = new Timestamp(System.currentTimeMillis());
                    int col = 1;
                    setEndTime.setTimestamp(col++, date);
                    setEndTime.setInt(col++, this.sessionId);
                    setEndTime.execute();
                    setEndTime.close();
                }
                catch (Throwable e) {
                }
                finally {
                    Util.closeSilently(c);
                }
                if (this.queue.isEmpty() || !this.runnerThread.isAlive()) break block13;
                this.setErrorMsg("waiting for synchronization to complete before shutdown");
                for (int i = 0; i < 100 && !this.queue.isEmpty(); ++i) {
                    if (!this.runnerThread.isAlive()) {
                        break;
                    }
                    try {
                        Thread.sleep(30L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            finally {
                this.shutdown = true;
                this.runnerThread.interrupt();
            }
        }
    }

    private void checkForShutdown() {
        if (!this.shutdown) {
            return;
        }
        IllegalStateException e = new IllegalStateException("DBCloud has already been shutdown");
        e.initCause(this.shutdownException);
        throw e;
    }

    public void storeNewBug(BugInstance bug, long analysisTime) {
        this.checkForShutdown();
        this.queue.add(new StoreNewBug(bug, analysisTime));
    }

    public void storeFirstSeen(final BugData bd) {
        this.checkForShutdown();
        this.queue.add(new Update(){

            public void execute(DatabaseSyncTask t) throws SQLException {
                t.storeFirstSeen(bd);
            }
        });
    }

    public void storeLastSeen(final BugData bd, final long timestamp) {
        this.checkForShutdown();
        this.queue.add(new Update(){

            public void execute(DatabaseSyncTask t) throws SQLException {
                t.storeLastSeen(bd, timestamp);
            }
        });
    }

    @Override
    public BugDesignation getPrimaryDesignation(BugInstance b) {
        return this.getBugData(b).getPrimaryDesignation();
    }

    public void storeUserAnnotation(BugData data, BugDesignation bd) {
        this.checkForShutdown();
        this.queue.add(new StoreUserAnnotation(data, bd));
        this.updatedStatus();
        if (DBCloud.firstTimeDoing(HAS_CLASSIFIED_ISSUES)) {
            String msg = "Classification and comments have been sent to database.\nYou'll only see this message the first time your classifcations/comments are sent\nto the database.";
            if (this.getMode() == Cloud.Mode.VOTING) {
                msg = msg + "\nOnce you've classified an issue, you can see how others have classified it.";
            }
            msg = msg + "\nYour classification and comments are independent from filing a bug using an external\nbug reporting system.";
            this.bugCollection.getProject().getGuiCallback().showMessageDialog(msg);
        }
    }

    private boolean skipBug(BugInstance bug) {
        boolean result;
        boolean bl = result = bug.getBugPattern().getCategory().equals("NOISE") || bug.isDead() || BugRanker.findRank(bug) > this.MAX_DB_RANK;
        if (result && DBCloud.firstTimeDoing(HAS_SKIPPED_BUG)) {
            this.bugCollection.getProject().getGuiCallback().showMessageDialog("To limit database load, some issues are not persisted to database.\nFor example, issues with rank greater than " + this.MAX_DB_RANK + " are not stored in the db.\n" + "One of more of the issues you are reviewing will not be persisted,\n" + "and you will not be able to record an evalution of those issues.\n" + "As we scale up the database, we hope to relax these restrictions");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertPendingRecord(Connection c, BugData bug, long when, String who) throws SQLException {
        int pendingId = -1;
        PreparedStatement query = null;
        ResultSet rs = null;
        boolean needsUpdate = false;
        try {
            query = c.prepareStatement("SELECT  id, bugReportId, whoFiled, whenFiled FROM findbugs_bugreport where hash=?");
            query.setString(1, bug.instanceHash);
            rs = query.executeQuery();
            while (rs.next()) {
                int col = 1;
                int id = rs.getInt(col++);
                String bugReportId = rs.getString(col++);
                String whoFiled = rs.getString(col++);
                Timestamp whenFiled = rs.getTimestamp(col++);
                if (!bugReportId.equals(PENDING) || !who.equals(whoFiled) && !this.pendingStatusHasExpired(whenFiled.getTime())) {
                    rs.close();
                    query.close();
                    throw new IllegalArgumentException(whoFiled + " already filed bug report " + bugReportId + " for " + bug.instanceHash);
                }
                pendingId = id;
                needsUpdate = !who.equals(whoFiled);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Problem inserting pending record for " + bug.instanceHash;
                AnalysisContext.logError(msg, e);
            }
            catch (Throwable throwable) {
                Util.closeSilently(rs);
                Util.closeSilently(query);
                throw throwable;
            }
            Util.closeSilently(rs);
            Util.closeSilently(query);
            return;
        }
        Util.closeSilently(rs);
        Util.closeSilently(query);
        if (pendingId == -1) {
            PreparedStatement insert = c.prepareStatement("INSERT INTO findbugs_bugreport (hash, bugReportId, whoFiled, whenFiled) VALUES (?, ?, ?, ?)");
            Timestamp date = new Timestamp(when);
            int col = 1;
            insert.setString(col++, bug.instanceHash);
            insert.setString(col++, PENDING);
            insert.setString(col++, who);
            insert.setTimestamp(col++, date);
            insert.executeUpdate();
            insert.close();
        } else if (needsUpdate) {
            PreparedStatement updateBug = c.prepareStatement("UPDATE  findbugs_bugreport SET whoFiled = ?,  whenFiled = ? WHERE id = ?");
            try {
                int col = 1;
                updateBug.setString(col++, bug.filedBy);
                updateBug.setTimestamp(col++, new Timestamp(bug.bugFiled));
                updateBug.setInt(col++, pendingId);
                updateBug.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "Problem inserting pending record for id " + pendingId + ", bug hash " + bug.instanceHash;
                AnalysisContext.logError(msg, e);
            }
            finally {
                updateBug.close();
            }
        }
    }

    boolean bugAlreadyFiled(BugInstance b) {
        BugData bd = this.getBugData(b.getInstanceHash());
        if (bd == null || !bd.inDatabase) {
            throw new IllegalArgumentException();
        }
        return bd.bugLink != null && !bd.bugLink.equals(NONE) && !bd.bugLink.equals(PENDING);
    }

    private void displayMessage(String msg, Exception e) {
        AnalysisContext.logError(msg, e);
        if (this.bugCollection != null && this.bugCollection.getProject().isGuiAvaliable()) {
            StringWriter stackTraceWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stackTraceWriter);
            e.printStackTrace(printWriter);
            this.bugCollection.getProject().getGuiCallback().showMessageDialog(String.format("%s - %s%n%s", msg, e.getMessage(), stackTraceWriter.toString()));
        } else {
            System.err.println(msg);
            e.printStackTrace(System.err);
        }
    }

    @Override
    public Cloud.SigninState getSigninState() {
        return this.signinState;
    }

    @Override
    public void setSaveSignInInformation(boolean save) {
    }

    @Override
    public boolean isSavingSignInInformationEnabled() {
        return false;
    }

    @Override
    public void signIn() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void signOut() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUser() {
        return this.findbugsUser;
    }

    @Override
    public long getFirstSeen(BugInstance b) {
        return this.getBugData((BugInstance)b).firstSeen;
    }

    static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            return "No utf-8 encoding";
        }
    }

    @Override
    public double getClassificationScore(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return 0.0;
        }
        Collection<BugDesignation> uniqueDesignations = bd.getUniqueDesignations();
        double total = 0.0;
        int count = 0;
        for (BugDesignation d : uniqueDesignations) {
            Cloud.UserDesignation designation = Cloud.UserDesignation.valueOf(d.getDesignationKey());
            if (designation.nonVoting()) continue;
            total += (double)designation.score();
            ++count;
        }
        return total / (double)count;
    }

    @Override
    public double getPortionObsoleteClassifications(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return 0.0;
        }
        int count = 0;
        Collection<BugDesignation> uniqueDesignations = bd.getUniqueDesignations();
        for (BugDesignation d : uniqueDesignations) {
            if (Cloud.UserDesignation.valueOf(d.getDesignationKey()) != Cloud.UserDesignation.OBSOLETE_CODE) continue;
            ++count;
        }
        return (double)count / (double)uniqueDesignations.size();
    }

    @Override
    public double getClassificationVariance(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return 0.0;
        }
        Collection<BugDesignation> uniqueDesignations = bd.getUniqueDesignations();
        double total = 0.0;
        double totalSquares = 0.0;
        int count = 0;
        for (BugDesignation d : uniqueDesignations) {
            Cloud.UserDesignation designation = Cloud.UserDesignation.valueOf(d.getDesignationKey());
            if (designation.nonVoting()) continue;
            int score = designation.score();
            total += (double)score;
            totalSquares += (double)(score * score);
            ++count;
        }
        double average = total / (double)count;
        return totalSquares / (double)count - average * average;
    }

    @Override
    public double getClassificationDisagreement(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return 0.0;
        }
        Collection<BugDesignation> uniqueDesignations = bd.getUniqueDesignations();
        int shouldFix = 0;
        int dontFix = 0;
        for (BugDesignation d : uniqueDesignations) {
            Cloud.UserDesignation designation = Cloud.UserDesignation.valueOf(d.getDesignationKey());
            if (designation.nonVoting()) continue;
            int score = designation.score();
            if (score > 0) {
                ++shouldFix;
                continue;
            }
            ++dontFix;
        }
        return (double)Math.min(shouldFix, dontFix) / (double)(shouldFix + dontFix);
    }

    @Override
    public Set<String> getReviewers(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return Collections.emptySet();
        }
        return bd.getReviewers();
    }

    public boolean isClaimed(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return false;
        }
        return bd.isClaimed();
    }

    private static boolean firstTimeDoing(String activity) {
        Preferences prefs = Preferences.userNodeForPackage(DBCloud.class);
        if (!prefs.getBoolean(activity, false)) {
            prefs.putBoolean(activity, true);
            return true;
        }
        return false;
    }

    private static void alreadyDone(String activity) {
        Preferences prefs = Preferences.userNodeForPackage(DBCloud.class);
        prefs.putBoolean(activity, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public URL getBugLink(BugInstance b) {
        BugData bd = this.getBugData(b);
        String bugNumber = bd.bugLink;
        Cloud.BugFilingStatus status = this.getBugLinkStatus(b);
        if (status == Cloud.BugFilingStatus.VIEW_BUG) {
            return this.getBugViewLink(bugNumber);
        }
        Connection c = null;
        try {
            URL uRL;
            c = this.getConnection();
            PreparedStatement ps = c.prepareStatement("SELECT bugReportId, whoFiled, whenFiled, status, assignedTo, componentName FROM findbugs_bugreport WHERE hash=?");
            ps.setString(1, b.getInstanceHash());
            ResultSet rs = ps.executeQuery();
            Timestamp pendingFiledAt = null;
            while (rs.next()) {
                int col = 1;
                String bugReportId = rs.getString(col++);
                String whoFiled = rs.getString(col++);
                Timestamp whenFiled = rs.getTimestamp(col++);
                String statusString = rs.getString(col++);
                String assignedTo = rs.getString(col++);
                String componentName = rs.getString(col++);
                if (bugReportId.equals(PENDING)) {
                    if (this.findbugsUser.equals(whoFiled) || this.pendingStatusHasExpired(whenFiled.getTime())) continue;
                    pendingFiledAt = whenFiled;
                    continue;
                }
                if (bugReportId.equals(NONE)) continue;
                rs.close();
                ps.close();
                bd.bugLink = bugReportId;
                bd.filedBy = whoFiled;
                bd.bugFiled = whenFiled.getTime();
                bd.bugAssignedTo = assignedTo;
                bd.bugStatus = statusString;
                bd.bugComponentName = componentName;
                int answer = this.getBugCollection().getProject().getGuiCallback().showConfirmDialog("Sorry, but since the time we last received updates from the database,\nsomeone else already filed a bug report. Would you like to view the bug report?", "Someone else already filed a bug report", "Yes", "No");
                if (answer == 0) {
                    URL uRL2 = null;
                    return uRL2;
                }
                URL uRL3 = this.getBugViewLink(bugReportId);
                return uRL3;
            }
            rs.close();
            ps.close();
            if (pendingFiledAt != null) {
                bd.bugLink = PENDING;
                bd.bugFiled = pendingFiledAt.getTime();
                this.getBugCollection().getProject().getGuiCallback().showMessageDialog("Sorry, but since the time we last received updates from the database,\nsomeone else already has started a bug report for this issue. ");
                URL col = null;
                return col;
            }
            if (status == Cloud.BugFilingStatus.FILE_BUG) {
                URL u = this.getBugFilingLink(b);
                if (u != null && DBCloud.firstTimeDoing(HAS_FILED_BUGS)) {
                    String bugFilingNote = String.format(this.properties.getProperty("findbugs.filebug.note", ""), new Object[0]);
                    int response = this.bugCollection.getProject().getGuiCallback().showConfirmDialog("This looks like the first time you've filed a bug from this machine. Please:\n * Please check the component the issue is assigned to; we sometimes get it wrong.\n * Try to figure out the right person to assign it to.\n * Provide the information needed to understand the issue.\n" + bugFilingNote + "Note that classifying an issue is distinct from (and lighter weight than) filing a bug.", "Do you want to file a bug report", "Yes", "No");
                    if (response != 0) {
                        URL uRL4 = null;
                        return uRL4;
                    }
                }
                if (u != null) {
                    this.insertPendingRecord(c, bd, System.currentTimeMillis(), this.findbugsUser);
                }
                uRL = u;
                return uRL;
            }
            assert (status == Cloud.BugFilingStatus.FILE_AGAIN);
            DBCloud.alreadyDone(HAS_FILED_BUGS);
            URL u = this.getBugFilingLink(b);
            if (u != null) {
                this.insertPendingRecord(c, bd, System.currentTimeMillis(), this.findbugsUser);
            }
            uRL = u;
            return uRL;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            Util.closeSilently(c);
        }
        return null;
    }

    @CheckForNull
    private URL getBugViewLink(String bugNumber) {
        String viewLinkPattern = this.properties.getProperty("findbugs.viewbug.link");
        if (viewLinkPattern == null) {
            return null;
        }
        this.firstBugRequest = false;
        String u = String.format(viewLinkPattern, bugNumber);
        try {
            return new URL(u);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void displaySupplementalBugReport(String supplemental) {
        supplemental = "[Can't squeeze this information into the URL used to prepopulate the bug entry\n please cut and paste into the bug report as appropriate]\n\n" + supplemental;
        this.bugCollection.getProject().getGuiCallback().displayNonmodelMessage("Cut and paste as needed into bug entry", supplemental);
    }

    private URL getBugFilingLink(BugInstance b) throws MalformedURLException {
        if (this.BUG_LINK_FORMAT == null) {
            return null;
        }
        int maxURLLength = 1999;
        if (this.firstBugRequest) {
            if (this.BUG_LOGIN_LINK != null && this.BUG_LOGIN_MSG != null) {
                URL u = new URL(String.format(this.BUG_LOGIN_LINK, new Object[0]));
                if (!this.bugCollection.getProject().getGuiCallback().showDocument(u)) {
                    return null;
                }
                int r = this.bugCollection.getProject().getGuiCallback().showConfirmDialog(this.BUG_LOGIN_MSG, "Logging into bug tracker...", "OK", "Cancel");
                if (r != 0) {
                    return null;
                }
            } else {
                maxURLLength = maxURLLength * 2 / 3;
            }
        }
        this.firstBugRequest = false;
        String component = this.getUserDesignation(b) == Cloud.UserDesignation.BAD_ANALYSIS && this.COMPONENT_FOR_BAD_ANALYSIS != null ? this.COMPONENT_FOR_BAD_ANALYSIS : this.getBugComponent(b.getPrimaryClass().getClassName().replace('.', '/'));
        String summary = this.bugFilingCommentHelper.getBugReportSummary(b);
        String report = this.bugFilingCommentHelper.getBugReportText(b);
        String u = String.format(this.BUG_LINK_FORMAT, component, DBCloud.urlEncode(summary), DBCloud.urlEncode(report));
        if (u.length() > maxURLLength) {
            String head = this.bugFilingCommentHelper.getBugReportHead(b);
            String sourceCode = this.bugFilingCommentHelper.getBugReportSourceCode(b);
            String tail = this.bugFilingCommentHelper.getBugReportTail(b);
            report = head + sourceCode + tail;
            String lineTerminatedUserEvaluation = this.bugFilingCommentHelper.getLineTerminatedUserEvaluation(b);
            String explanation = this.bugFilingCommentHelper.getBugPatternExplanation(b);
            String supplemental = lineTerminatedUserEvaluation + explanation;
            u = String.format(this.BUG_LINK_FORMAT, component, DBCloud.urlEncode(summary), DBCloud.urlEncode(report));
            if (u.length() > maxURLLength) {
                report = head + tail;
                supplemental = sourceCode + lineTerminatedUserEvaluation + explanation;
                u = String.format(this.BUG_LINK_FORMAT, component, DBCloud.urlEncode(summary), DBCloud.urlEncode(report));
                if (u.length() > maxURLLength) {
                    supplemental = head + sourceCode + lineTerminatedUserEvaluation + explanation;
                    report = tail;
                    String urlEncodedSummary = DBCloud.urlEncode(summary);
                    String urlEncodedReport = DBCloud.urlEncode(report);
                    String urlEncodedComponent = DBCloud.urlEncode(component);
                    int maxSummaryLength = maxURLLength - this.BUG_LINK_FORMAT.length() + 6 - urlEncodedReport.length() - urlEncodedComponent.length();
                    if (urlEncodedSummary.length() > maxSummaryLength) {
                        if ("%".equals((urlEncodedSummary = urlEncodedSummary.substring(0, maxSummaryLength - 1)).substring(urlEncodedSummary.length() - 1))) {
                            urlEncodedSummary = urlEncodedSummary.substring(0, urlEncodedSummary.length() - 2);
                        } else if ("%".equals(urlEncodedSummary.substring(urlEncodedSummary.length() - 2, urlEncodedSummary.length() - 1))) {
                            urlEncodedSummary = urlEncodedSummary.substring(0, urlEncodedSummary.length() - 3);
                        }
                    }
                    u = String.format(this.BUG_LINK_FORMAT, urlEncodedComponent, urlEncodedSummary, urlEncodedReport);
                }
            }
            this.displaySupplementalBugReport(supplemental);
        }
        return new URL(u);
    }

    @Override
    public boolean supportsCloudReports() {
        return true;
    }

    @Override
    public boolean supportsBugLinks() {
        return this.BUG_LINK_FORMAT != null;
    }

    @Override
    public void storeUserAnnotation(BugInstance bugInstance) {
        this.storeUserAnnotation(this.getBugData(bugInstance), bugInstance.getNonnullUserDesignation());
        this.updatedIssue(bugInstance);
    }

    @Override
    public Cloud.BugFilingStatus getBugLinkStatus(BugInstance b) {
        BugData bd = this.getBugData(b);
        String link = bd.bugLink;
        if (link == null || link.length() == 0 || link.equals(NONE)) {
            return Cloud.BugFilingStatus.FILE_BUG;
        }
        if (link.equals(PENDING)) {
            if (this.findbugsUser.equals(bd.filedBy)) {
                return Cloud.BugFilingStatus.FILE_AGAIN;
            }
            long whenFiled = bd.bugFiled;
            if (this.pendingStatusHasExpired(whenFiled)) {
                return Cloud.BugFilingStatus.FILE_BUG;
            }
            return Cloud.BugFilingStatus.BUG_PENDING;
        }
        try {
            Integer.parseInt(link);
            return Cloud.BugFilingStatus.VIEW_BUG;
        }
        catch (RuntimeException e) {
            return Cloud.BugFilingStatus.NA;
        }
    }

    @Override
    protected String getBugStatus(BugInstance b) {
        String status = this.getBugData((BugInstance)b).bugStatus;
        if (status != null) {
            return status;
        }
        return "Unknown";
    }

    private boolean pendingStatusHasExpired(long whenFiled) {
        return System.currentTimeMillis() - whenFiled > 3600000L;
    }

    @Override
    public void bugFiled(BugInstance b, Object bugLink) {
        this.checkForShutdown();
        if (this.bugAlreadyFiled(b)) {
            return;
        }
        this.queue.add(new FileBug(b));
        this.updatedStatus();
    }

    void setErrorMsg(String msg) {
        this.errorMsg = msg;
        this.errorTime = System.currentTimeMillis();
        this.updatedStatus();
    }

    void clearErrorMsg() {
        this.errorMsg = null;
        this.updatedStatus();
    }

    @Override
    public String getStatusMsg() {
        if (this.errorMsg != null) {
            if (this.errorTime + 120000L > System.currentTimeMillis()) {
                this.errorMsg = null;
            } else {
                return this.errorMsg + "; " + this.getStatusMsg0();
            }
        }
        return this.getStatusMsg0();
    }

    public String getStatusMsg0() {
        SimpleDateFormat format = new SimpleDateFormat("h:mm a");
        int numToSync = this.queue.size();
        if (numToSync > 0) {
            return String.format("%d remain to be synchronized", numToSync);
        }
        if (this.resync != null && this.resync.after(this.lastUpdate)) {
            return String.format("%d updates received from db at %s", this.resyncCount, format.format(this.resync));
        }
        if (this.updatesSentToDatabase == 0) {
            return String.format("%d issues synchronized with database", this.idMap.size());
        }
        return String.format("%d classifications/bug filings sent to db, last updated at %s", this.updatesSentToDatabase, format.format(this.lastUpdate));
    }

    @Override
    public boolean getIWillFix(BugInstance b) {
        if (super.getIWillFix(b)) {
            return true;
        }
        BugData bd = this.getBugData(b);
        return bd != null && this.findbugsUser.equals(bd.bugAssignedTo);
    }

    @Override
    public boolean getBugIsUnassigned(BugInstance b) {
        BugData bd = this.getBugData(b);
        return bd != null && bd.inDatabase && this.getBugLinkStatus(b) == Cloud.BugFilingStatus.VIEW_BUG && ("NEW".equals(bd.bugStatus) || bd.bugAssignedTo == null || bd.bugAssignedTo.length() == 0);
    }

    @Override
    public boolean getWillNotBeFixed(BugInstance b) {
        BugData bd = this.getBugData(b);
        return bd != null && bd.inDatabase && this.getBugLinkStatus(b) == Cloud.BugFilingStatus.VIEW_BUG && "WILL_NOT_FIX".equals(bd.bugStatus);
    }

    @Override
    public boolean supportsCloudSummaries() {
        return true;
    }

    @Override
    public boolean canStoreUserAnnotation(BugInstance bugInstance) {
        return !this.skipBug(bugInstance);
    }

    @Override
    @CheckForNull
    public String claimedBy(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return null;
        }
        for (BugDesignation designation : bd.getUniqueDesignations()) {
            if (!"I_WILL_FIX".equals(designation.getDesignationKey())) continue;
            return designation.getUser();
        }
        return null;
    }

    @Override
    protected Iterable<BugDesignation> getLatestDesignationFromEachUser(BugInstance bd) {
        BugData bugData = this.instanceMap.get(bd.getInstanceHash());
        if (bugData == null) {
            return Collections.emptyList();
        }
        return bugData.getUniqueDesignations();
    }

    @Override
    public BugInstance getBugByHash(String hash) {
        Collection<BugInstance> bugs = this.instanceMap.get((Object)hash).bugs;
        return bugs.isEmpty() ? null : bugs.iterator().next();
    }

    @Override
    public Collection<String> getProjects(String className) {
        return this.projectMapping.getProjects(className);
    }

    @Override
    public String getCloudName() {
        return "FindBugs SQL Cloud";
    }

    @Override
    public URL fileBug(BugInstance bug) {
        return null;
    }

    static class StoreUserAnnotation
    implements Update {
        final BugData data;
        final BugDesignation designation;

        public StoreUserAnnotation(BugData data, BugDesignation designation) {
            this.data = data;
            this.designation = designation;
        }

        public void execute(DatabaseSyncTask t) throws SQLException {
            t.newEvaluation(this.data, new BugDesignation(this.designation));
        }
    }

    class StoreNewBug
    implements Update {
        final BugInstance bug;
        final long analysisTime;

        public StoreNewBug(BugInstance bug, long analysisTime) {
            this.bug = bug;
            this.analysisTime = analysisTime;
        }

        public void execute(DatabaseSyncTask t) throws SQLException {
            long timestamp;
            BugData data = DBCloud.this.getBugData(this.bug.getInstanceHash());
            if (data.lastSeen < this.analysisTime && FindBugs.validTimestamp(this.analysisTime)) {
                data.lastSeen = this.analysisTime;
            }
            if ((timestamp = DBCloud.this.bugCollection.getAppVersionFromSequenceNumber(this.bug.getFirstVersion()).getTimestamp()) < 1000000000000L) {
                timestamp = this.analysisTime;
            }
            data.firstSeen = timestamp = DBCloud.this.sanityCheckFirstSeen(DBCloud.this.sanityCheckLastSeen(timestamp));
            if (data.inDatabase) {
                return;
            }
            t.newBug(this.bug);
            data.inDatabase = true;
        }
    }

    class FileBug
    implements Update {
        final BugData bd;

        public FileBug(BugInstance bug) {
            this.bd = DBCloud.this.getBugData(bug.getInstanceHash());
            if (this.bd == null || !this.bd.inDatabase) {
                throw new IllegalArgumentException();
            }
            this.bd.bugFiled = System.currentTimeMillis();
            this.bd.bugLink = DBCloud.PENDING;
            this.bd.filedBy = DBCloud.this.findbugsUser;
        }

        public void execute(DatabaseSyncTask t) throws SQLException {
            t.fileBug(this.bd);
        }
    }

    static class DatabaseSyncShutdownException
    extends RuntimeException {
        DatabaseSyncShutdownException() {
        }
    }

    static class ShutdownTask
    implements Update {
        ShutdownTask() {
        }

        public void execute(DatabaseSyncTask t) {
            throw new DatabaseSyncShutdownException();
        }
    }

    static interface Update {
        public void execute(DatabaseSyncTask var1) throws SQLException;
    }

    class DatabaseSyncTask
    implements Runnable {
        int handled;
        Connection c;

        DatabaseSyncTask() {
        }

        public void establishConnection() throws SQLException {
            if (this.c != null) {
                return;
            }
            this.c = DBCloud.this.getConnection();
        }

        public void closeConnection() throws SQLException {
            if (this.c == null) {
                return;
            }
            this.c.close();
            this.c = null;
        }

        public void run() {
            try {
                while (!DBCloud.this.shutdown) {
                    Update u = DBCloud.this.queue.poll(10L, TimeUnit.SECONDS);
                    if (u == null) {
                        this.closeConnection();
                        continue;
                    }
                    this.establishConnection();
                    u.execute(this);
                    if (this.handled++ % 100 != 0 && !DBCloud.this.queue.isEmpty()) continue;
                    DBCloud.this.updatedStatus();
                }
            }
            catch (DatabaseSyncShutdownException e) {
            }
            catch (RuntimeException e) {
                DBCloud.this.displayMessage("Runtime exception; database connection shutdown", e);
            }
            catch (SQLException e) {
                DBCloud.this.displayMessage("SQL exception; database connection shutdown", e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.closeConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public void newEvaluation(BugData data, BugDesignation bd) {
            if (!data.inDatabase) {
                return;
            }
            try {
                data.designations.add(bd);
                if (bd.getUser() == null) {
                    bd.setUser(DBCloud.this.findbugsUser);
                }
                if (bd.getAnnotationText() == null) {
                    bd.setAnnotationText("");
                }
                PreparedStatement insertEvaluation = this.c.prepareStatement("INSERT INTO findbugs_evaluation (issueId, who, invocationId, designation, comment, time) VALUES (?,?,?,?,?,?)", 1);
                Timestamp date = new Timestamp(bd.getTimestamp());
                int col = 1;
                insertEvaluation.setInt(col++, data.id);
                insertEvaluation.setString(col++, bd.getUser());
                insertEvaluation.setInt(col++, DBCloud.this.sessionId);
                insertEvaluation.setString(col++, bd.getDesignationKey());
                insertEvaluation.setString(col++, bd.getAnnotationText());
                insertEvaluation.setTimestamp(col++, date);
                insertEvaluation.executeUpdate();
                ResultSet rs = insertEvaluation.getGeneratedKeys();
                if (rs.next()) {
                    int id = rs.getInt(1);
                    DBCloud.this.bugDesignationId.put(bd, id);
                }
                rs.close();
                insertEvaluation.close();
            }
            catch (Exception e) {
                DBCloud.this.displayMessage("Problems looking up user annotations", e);
            }
            DBCloud.this.lastUpdate = new Date();
            ++DBCloud.this.updatesSentToDatabase;
        }

        public void newBug(BugInstance b) {
            try {
                BugData bug = DBCloud.this.getBugData(b.getInstanceHash());
                if (bug.inDatabase) {
                    return;
                }
                PreparedStatement insertBugData = this.c.prepareStatement("INSERT INTO findbugs_issue (firstSeen, lastSeen, hash, bugPattern, priority, primaryClass) VALUES (?,?,?,?,?,?)", 1);
                int col = 1;
                insertBugData.setTimestamp(col++, new Timestamp(bug.firstSeen));
                insertBugData.setTimestamp(col++, new Timestamp(bug.lastSeen));
                insertBugData.setString(col++, bug.instanceHash);
                insertBugData.setString(col++, b.getBugPattern().getType());
                insertBugData.setInt(col++, b.getPriority());
                insertBugData.setString(col++, b.getPrimaryClass().getClassName());
                insertBugData.executeUpdate();
                ResultSet rs = insertBugData.getGeneratedKeys();
                if (rs.next()) {
                    bug.id = rs.getInt(1);
                    bug.inDatabase = true;
                }
                rs.close();
                insertBugData.close();
            }
            catch (Exception e) {
                DBCloud.this.displayMessage("Problems looking up user annotations", e);
            }
        }

        public void storeFirstSeen(BugData bug) {
            if (bug.firstSeen <= 1000000000000L) {
                return;
            }
            try {
                PreparedStatement insertBugData = this.c.prepareStatement("UPDATE  findbugs_issue SET firstSeen = ? WHERE id = ?");
                Timestamp date = new Timestamp(bug.firstSeen);
                int col = 1;
                insertBugData.setTimestamp(col++, date);
                insertBugData.setInt(col++, bug.id);
                insertBugData.executeUpdate();
                insertBugData.close();
            }
            catch (Exception e) {
                DBCloud.this.displayMessage("Problems looking up user annotations", e);
            }
        }

        public void storeLastSeen(BugData bug, long timestamp) {
            if (bug.lastSeen >= DBCloud.this.now + 86400000L) {
                return;
            }
            try {
                PreparedStatement insertBugData = this.c.prepareStatement("UPDATE  findbugs_issue SET lastSeen = ? WHERE id = ?");
                Timestamp date = new Timestamp(timestamp);
                int col = 1;
                insertBugData.setTimestamp(col++, date);
                insertBugData.setInt(col++, bug.id);
                insertBugData.executeUpdate();
                insertBugData.close();
            }
            catch (Exception e) {
                DBCloud.this.displayMessage("Problems looking up user annotations", e);
            }
        }

        public void fileBug(BugData bug) {
            try {
                DBCloud.this.insertPendingRecord(this.c, bug, bug.bugFiled, bug.filedBy);
            }
            catch (Exception e) {
                DBCloud.this.displayMessage("Problem filing bug", e);
            }
            DBCloud.this.lastUpdate = new Date();
            ++DBCloud.this.updatesSentToDatabase;
        }
    }

    class PopulateBugs
    implements Update {
        final boolean performFullLoad;

        PopulateBugs(boolean performFullLoad) {
            this.performFullLoad = performFullLoad;
        }

        public void execute(DatabaseSyncTask t) throws SQLException {
            Object designation;
            if (DBCloud.this.startShutdown) {
                return;
            }
            String commonPrefix = null;
            int updates = 0;
            if (this.performFullLoad) {
                for (BugInstance b : DBCloud.this.bugCollection.getCollection()) {
                    if (DBCloud.this.skipBug(b)) continue;
                    commonPrefix = Util.commonPrefix(commonPrefix, b.getPrimaryClass().getClassName());
                    DBCloud.this.getBugData((String)b.getInstanceHash()).bugs.add(b);
                }
                if (commonPrefix == null) {
                    commonPrefix = "<no bugs>";
                } else if (commonPrefix.length() > 128) {
                    commonPrefix = commonPrefix.substring(0, 128);
                }
            }
            try {
                int id;
                int col;
                ResultSet rs;
                PreparedStatement ps;
                long startTime = System.currentTimeMillis();
                Connection c = DBCloud.this.getConnection();
                if (this.performFullLoad) {
                    ps = c.prepareStatement("SELECT id, hash, firstSeen, lastSeen FROM findbugs_issue");
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        col = 1;
                        id = rs.getInt(col++);
                        String hash = rs.getString(col++);
                        Timestamp firstSeen = rs.getTimestamp(col++);
                        Timestamp lastSeen = rs.getTimestamp(col++);
                        DBCloud.this.loadDatabaseInfo(hash, id, firstSeen.getTime(), lastSeen.getTime());
                    }
                    rs.close();
                    ps.close();
                }
                if (DBCloud.this.startShutdown) {
                    return;
                }
                ps = c.prepareStatement("SELECT id, issueId, who, designation, comment, time FROM findbugs_evaluation");
                rs = ps.executeQuery();
                while (rs.next()) {
                    BugDesignation bd;
                    col = 1;
                    id = rs.getInt(col++);
                    int issueId = rs.getInt(col++);
                    String who = rs.getString(col++);
                    designation = rs.getString(col++);
                    String comment = rs.getString(col++);
                    Timestamp when = rs.getTimestamp(col++);
                    BugData data = DBCloud.this.idMap.get(issueId);
                    if (data == null || !data.designations.add(bd = new BugDesignation((String)designation, when.getTime(), comment, who))) continue;
                    DBCloud.this.bugDesignationId.put(bd, id);
                    ++updates;
                    for (BugInstance bug : data.bugs) {
                        DBCloud.this.updatedIssue(bug);
                    }
                }
                rs.close();
                ps.close();
                if (DBCloud.this.startShutdown) {
                    return;
                }
                ps = c.prepareStatement("SELECT hash, bugReportId, whoFiled, whenFiled, status, assignedTo, componentName FROM findbugs_bugreport");
                rs = ps.executeQuery();
                while (rs.next()) {
                    col = 1;
                    String hash = rs.getString(col++);
                    String bugReportId = rs.getString(col++);
                    String whoFiled = rs.getString(col++);
                    Timestamp whenFiled = rs.getTimestamp(col++);
                    String status = rs.getString(col++);
                    String assignedTo = rs.getString(col++);
                    String componentName = rs.getString(col++);
                    BugData data = DBCloud.this.instanceMap.get(hash);
                    if (data == null || Util.nullSafeEquals(data.bugLink, bugReportId) && Util.nullSafeEquals(data.filedBy, whoFiled) && data.bugFiled == whenFiled.getTime() && Util.nullSafeEquals(data.bugAssignedTo, assignedTo) && Util.nullSafeEquals(data.bugStatus, status) && Util.nullSafeEquals(data.bugComponentName, componentName)) continue;
                    data.bugLink = bugReportId;
                    data.filedBy = whoFiled;
                    data.bugFiled = whenFiled.getTime();
                    data.bugAssignedTo = assignedTo;
                    data.bugStatus = status;
                    data.bugComponentName = componentName;
                    ++updates;
                    for (BugInstance bug : data.bugs) {
                        DBCloud.this.updatedIssue(bug);
                    }
                }
                rs.close();
                ps.close();
                if (DBCloud.this.startShutdown) {
                    return;
                }
                if (!invocationRecorded) {
                    long jvmStartTime = StartTime.START_TIME - StartTime.VM_START_TIME;
                    SortedBugCollection sbc = (SortedBugCollection)DBCloud.this.bugCollection;
                    long findbugsStartTime = sbc.getTimeStartedLoading() - StartTime.START_TIME;
                    URL findbugsURL = PluginLoader.getCoreResource("findbugs.xml");
                    String loadURL = findbugsURL == null ? "" : findbugsURL.toString();
                    long initialLoadTime = sbc.getTimeFinishedLoading() - sbc.getTimeStartedLoading();
                    long initialSyncTime = System.currentTimeMillis() - sbc.getTimeFinishedLoading();
                    String os = SystemProperties.getProperty("os.name", "");
                    String osVersion = SystemProperties.getProperty("os.version");
                    String jvmVersion = SystemProperties.getProperty("java.runtime.version");
                    if (osVersion != null) {
                        os = os + " " + osVersion;
                    }
                    PreparedStatement insertSession = c.prepareStatement("INSERT INTO findbugs_invocation (who, ipAddress, entryPoint, dataSource, fbVersion, os, jvmVersion, jvmLoadTime, findbugsLoadTime, analysisLoadTime, initialSyncTime, numIssues, startTime, commonPrefix) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
                    Timestamp now = new Timestamp(startTime);
                    int col2 = 1;
                    insertSession.setString(col2++, DBCloud.this.findbugsUser);
                    String ipAddress = DBCloud.this.PROMPT_FOR_USER_NAME ? DBCloud.this.ipAddressLookup.get() : "self-authenticated";
                    insertSession.setString(col2++, ipAddress);
                    insertSession.setString(col2++, DBCloud.limitToMaxLength(loadURL, 128));
                    insertSession.setString(col2++, DBCloud.limitToMaxLength(sbc.getDataSource(), 128));
                    insertSession.setString(col2++, Version.RELEASE);
                    insertSession.setString(col2++, DBCloud.limitToMaxLength(os, 128));
                    insertSession.setString(col2++, DBCloud.limitToMaxLength(jvmVersion, 64));
                    insertSession.setLong(col2++, DBCloud.this.boundDuration(jvmStartTime));
                    insertSession.setLong(col2++, DBCloud.this.boundDuration(findbugsStartTime));
                    insertSession.setLong(col2++, DBCloud.this.boundDuration(initialLoadTime));
                    insertSession.setLong(col2++, DBCloud.this.boundDuration(initialSyncTime));
                    insertSession.setInt(col2++, DBCloud.this.bugCollection.getCollection().size());
                    insertSession.setTimestamp(col2++, now);
                    insertSession.setString(col2++, commonPrefix);
                    insertSession.executeUpdate();
                    rs = insertSession.getGeneratedKeys();
                    if (rs.next()) {
                        DBCloud.this.sessionId = rs.getInt(1);
                    }
                    insertSession.close();
                    rs.close();
                    invocationRecorded = true;
                }
                c.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCloud.this.displayMessage("problem bulk loading database", e);
            }
            if (DBCloud.this.startShutdown) {
                return;
            }
            if (!this.performFullLoad) {
                DBCloud.this.attemptedResync = new Date();
                if (updates > 0) {
                    DBCloud.this.resync = DBCloud.this.attemptedResync;
                    DBCloud.this.resyncCount = updates;
                }
            } else {
                long stillPresentAt = DBCloud.this.bugCollection.getTimestamp();
                for (BugInstance b : DBCloud.this.bugCollection.getCollection()) {
                    if (DBCloud.this.skipBug(b)) continue;
                    BugData bd = DBCloud.this.getBugData(b.getInstanceHash());
                    if (!bd.inDatabase) {
                        DBCloud.this.storeNewBug(b, stillPresentAt);
                        continue;
                    }
                    long firstVersion = b.getFirstVersion();
                    long firstSeen = DBCloud.this.bugCollection.getAppVersionFromSequenceNumber(firstVersion).getTimestamp();
                    if (FindBugs.validTimestamp(firstSeen) && (firstSeen < bd.firstSeen || !FindBugs.validTimestamp(bd.firstSeen))) {
                        bd.firstSeen = firstSeen;
                        DBCloud.this.storeFirstSeen(bd);
                    } else if (FindBugs.validTimestamp(stillPresentAt) && stillPresentAt > bd.lastSeen + LAST_SEEN_UPDATE_WINDOW) {
                        DBCloud.this.storeLastSeen(bd, stillPresentAt);
                    }
                    if ((designation = bd.getPrimaryDesignation()) == null) continue;
                    b.setUserDesignation(new BugDesignation((BugDesignation)designation));
                }
                DBCloud.this.initialSyncDone.countDown();
                assert (!DBCloud.this.scheduled);
                if (DBCloud.this.startShutdown) {
                    return;
                }
                long delay = 600000L;
                if (!DBCloud.this.scheduled) {
                    try {
                        DBCloud.this.resyncTimer.schedule(new TimerTask(){

                            public void run() {
                                if (DBCloud.this.attemptedResync == null || DBCloud.this.lastUpdate.after(DBCloud.this.attemptedResync) || DBCloud.this.numSkipped++ > 6) {
                                    DBCloud.this.numSkipped = 0;
                                    DBCloud.this.queue.add(new PopulateBugs(false));
                                }
                            }
                        }, delay, delay);
                    }
                    catch (Exception e) {
                        AnalysisContext.logError("Error scheduling resync", e);
                    }
                }
                DBCloud.this.scheduled = true;
            }
            DBCloud.this.updatedStatus();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BugData {
        final String instanceHash;
        int id;
        boolean inDatabase;
        long firstSeen;
        String bugLink = "none";
        String filedBy;
        String bugStatus;
        String bugAssignedTo;
        String bugComponentName;
        long bugFiled = Long.MAX_VALUE;
        SortedSet<BugDesignation> designations = new TreeSet<BugDesignation>();
        Collection<BugInstance> bugs = new LinkedHashSet<BugInstance>();
        long lastSeen;

        public BugData(String instanceHash) {
            this.instanceHash = instanceHash;
        }

        @CheckForNull
        BugDesignation getPrimaryDesignation() {
            for (BugDesignation bd : this.designations) {
                if (!DBCloud.this.findbugsUser.equals(bd.getUser())) continue;
                return bd;
            }
            return null;
        }

        @CheckForNull
        BugDesignation getUserDesignation() {
            for (BugDesignation d : this.designations) {
                if (!DBCloud.this.findbugsUser.equals(d.getUser())) continue;
                return new BugDesignation(d);
            }
            return null;
        }

        Collection<BugDesignation> getUniqueDesignations() {
            if (this.designations.isEmpty()) {
                return Collections.emptyList();
            }
            HashSet<String> reviewers = new HashSet<String>();
            ArrayList<BugDesignation> result = new ArrayList<BugDesignation>(this.designations.size());
            for (BugDesignation d : this.designations) {
                if (!reviewers.add(d.getUser())) continue;
                result.add(d);
            }
            return result;
        }

        Set<String> getReviewers() {
            HashSet<String> reviewers = new HashSet<String>();
            for (BugDesignation bd : this.designations) {
                reviewers.add(bd.getUser());
            }
            reviewers.remove("");
            reviewers.remove(null);
            return reviewers;
        }

        boolean isClaimed() {
            for (BugDesignation bd : this.getUniqueDesignations()) {
                if (!bd.getDesignationKey().equals(Cloud.UserDesignation.I_WILL_FIX.name())) continue;
                return true;
            }
            return false;
        }

        BugDesignation getNonnullUserDesignation() {
            BugDesignation d = this.getUserDesignation();
            if (d != null) {
                return d;
            }
            d = new BugDesignation(Cloud.UserDesignation.UNCLASSIFIED.name(), System.currentTimeMillis(), "", DBCloud.this.findbugsUser);
            return d;
        }

        public boolean canSeeCommentsByOthers() {
            switch (DBCloud.this.getMode()) {
                case SECRET: {
                    return false;
                }
                case COMMUNAL: {
                    return true;
                }
                case VOTING: {
                    return this.hasVoted();
                }
            }
            throw new IllegalStateException();
        }

        public boolean hasVoted() {
            for (BugDesignation bd : this.designations) {
                if (!DBCloud.this.findbugsUser.equals(bd.getUser())) continue;
                return true;
            }
            return false;
        }
    }
}

