/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud.username;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.PropertyBundle;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import edu.umd.cs.findbugs.cloud.username.NameLookup;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class AppEngineNameLookup
implements NameLookup {
    public static final String LOCAL_APPENGINE = "appengine.local";
    public static final String APPENGINE_LOCALHOST_PROPERTY_NAME = "appengine.host.local";
    public static final String APPENGINE_LOCALHOST_DEFAULT = "http://localhost:8080";
    public static final String APPENGINE_HOST_PROPERTY_NAME = "appengine.host";
    private static final Logger LOGGER = Logger.getLogger(AppEngineNameLookup.class.getName());
    private static final String SYSPROP_NEVER_SAVE_SESSION = "appengine.never_save_session";
    private static final String SYSPROP_APPENGINE_LOCAL = "appengine.local";
    private static final int USER_SIGNIN_TIMEOUT_SECS = 60;
    private static final String KEY_SAVE_SESSION_INFO = "save_session_info";
    private static final String KEY_APPENGINECLOUD_SESSION_ID = "appenginecloud_session_id";
    private Long sessionId;
    private String username;
    private String host;

    public boolean signIn(CloudPlugin plugin, BugCollection bugCollection) throws IOException {
        this.loadProperties(plugin);
        if (this.softSignin()) {
            return true;
        }
        if (this.sessionId == null) {
            this.sessionId = this.loadOrCreateSessionId();
        }
        LOGGER.info("Opening browser for session " + this.sessionId);
        URL u = new URL(this.host + "/browser-auth/" + this.sessionId);
        LaunchBrowser.showDocument(u);
        for (int i = 0; i < 60; ++i) {
            if (this.checkAuthorized(this.getAuthCheckUrl(this.sessionId))) {
                return true;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        LOGGER.info("Sign-in timed out for " + this.sessionId);
        throw new IOException("Sign-in timed out");
    }

    public void loadProperties(CloudPlugin plugin) {
        PropertyBundle pluginProps = plugin.getProperties();
        this.host = pluginProps.getBoolean("appengine.local") ? pluginProps.getProperty(APPENGINE_LOCALHOST_PROPERTY_NAME, APPENGINE_LOCALHOST_DEFAULT) : pluginProps.getProperty(APPENGINE_HOST_PROPERTY_NAME);
        if (this.host == null) {
            throw new IllegalStateException("Host not specified for " + plugin.getId());
        }
    }

    public boolean softSignin() throws IOException {
        long id;
        if (this.sessionId != null) {
            if (this.checkAuthorized(this.getAuthCheckUrl(this.sessionId))) {
                LOGGER.fine("Skipping soft init; session ID already exists - " + this.sessionId);
                return true;
            }
            this.sessionId = null;
        }
        if ((id = this.loadSessionId()) == 0L) {
            return false;
        }
        boolean authorized = this.checkAuthorized(this.getAuthCheckUrl(id));
        if (authorized) {
            LOGGER.info("Authorized with session ID: " + id);
            this.sessionId = id;
        }
        return authorized;
    }

    private URL getAuthCheckUrl(long sessionId) throws MalformedURLException {
        return new URL(this.host + "/check-auth/" + sessionId);
    }

    public static void setSaveSessionInformation(boolean save) {
        Preferences prefs = Preferences.userNodeForPackage(AppEngineNameLookup.class);
        prefs.putBoolean(KEY_SAVE_SESSION_INFO, save);
        if (!save) {
            AppEngineNameLookup.clearSavedSessionInformation();
        }
    }

    public static boolean isSavingSessionInfoEnabled() {
        return !Boolean.getBoolean(SYSPROP_NEVER_SAVE_SESSION) && Preferences.userNodeForPackage(AppEngineNameLookup.class).getBoolean(KEY_SAVE_SESSION_INFO, true);
    }

    public static void clearSavedSessionInformation() {
        Preferences prefs = Preferences.userNodeForPackage(AppEngineNameLookup.class);
        prefs.remove(KEY_APPENGINECLOUD_SESSION_ID);
    }

    public static void saveSessionInformation(long sessionId) {
        assert (sessionId != 0L);
        Preferences.userNodeForPackage(AppEngineNameLookup.class).putLong(KEY_APPENGINECLOUD_SESSION_ID, sessionId);
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getHost() {
        return this.host;
    }

    private long loadOrCreateSessionId() {
        long id = this.loadSessionId();
        if (id != 0L) {
            LOGGER.info("Using saved session ID: " + id);
            return id;
        }
        SecureRandom r = new SecureRandom();
        while (id == 0L) {
            id = r.nextLong();
        }
        if (id == 0L) {
            id = 42L;
        }
        if (AppEngineNameLookup.isSavingSessionInfoEnabled()) {
            AppEngineNameLookup.saveSessionInformation(id);
        }
        return id;
    }

    private long loadSessionId() {
        Preferences prefs = Preferences.userNodeForPackage(AppEngineNameLookup.class);
        long id = prefs.getLong(KEY_APPENGINECLOUD_SESSION_ID, 0L);
        return id;
    }

    private boolean checkAuthorized(URL response) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)response.openConnection();
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String status = in.readLine();
            this.sessionId = Long.parseLong(in.readLine());
            this.username = in.readLine();
            Util.closeSilently(in);
            if ("OK".equals(status)) {
                LOGGER.info("Authorized session " + this.sessionId);
                return true;
            }
        }
        connection.disconnect();
        return false;
    }
}

