/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnnotationDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnValueAnnotation;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.ElementValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCheckReturnAnnotationDatabase
extends AnnotationVisitor {
    private static final String DEFAULT_ANNOTATION_ANNOTATION_CLASS = "DefaultAnnotation";
    private static final Map<String, AnnotationDatabase.Target> defaultKind = new HashMap<String, AnnotationDatabase.Target>();

    static String simpleClassName(@DottedClassName String className) {
        int i = className.lastIndexOf(".");
        if (i < 0) {
            return className;
        }
        return className.substring(i + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitAnnotation(@DottedClassName String annotationClassName, Map<String, ElementValue> map, boolean runtimeVisible) {
        CheckReturnValueAnnotation n;
        String annotationClassSimpleName = BuildCheckReturnAnnotationDatabase.simpleClassName(annotationClassName);
        if (annotationClassSimpleName.startsWith(DEFAULT_ANNOTATION_ANNOTATION_CLASS)) {
            ElementValue v = map.get("value");
            if (v == null || !(v instanceof Object[])) {
                return;
            }
            AnnotationDatabase.Target annotationTarget = defaultKind.get(annotationClassSimpleName = annotationClassSimpleName.substring(DEFAULT_ANNOTATION_ANNOTATION_CLASS.length()));
            if (annotationTarget != AnnotationDatabase.Target.METHOD) {
                return;
            }
            if (annotationTarget != null) {
                for (Object aClass : (Object[])v) {
                    CheckReturnValueAnnotation n2;
                    if (!(aClass instanceof String) || !BuildCheckReturnAnnotationDatabase.simpleClassName((String)aClass).equals("CheckReturnValue") || (n2 = CheckReturnValueAnnotation.parse(BuildCheckReturnAnnotationDatabase.getAnnotationParameterAsString(map, "priority"))) == null) continue;
                    AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addDefaultAnnotation(annotationTarget, this.getDottedClassName(), n2);
                }
            }
        }
        if (annotationClassName.equals(javax.annotation.CheckReturnValue.class.getName())) {
            ElementValue when = map.get("when");
            if (when instanceof String) {
                String w = BuildCheckReturnAnnotationDatabase.simpleClassName((String)when);
                if (w.equals("NEVER") || w.equals("UNKNOWN")) {
                    n = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE;
                } else if (w.equals("MAYBE")) {
                    n = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE;
                } else {
                    if (!w.equals("ALWAYS")) return;
                    n = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH;
                }
            } else {
                n = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM;
            }
        } else if (annotationClassName.equals(CheckReturnValue.class.getName())) {
            n = CheckReturnValueAnnotation.parse(BuildCheckReturnAnnotationDatabase.getAnnotationParameterAsString(map, "priority"));
        } else {
            if (!annotationClassSimpleName.equals("CheckReturnValue")) return;
            n = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM;
        }
        if (n == null) {
            return;
        }
        if (this.visitingMethod()) {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addDirectAnnotation(XFactory.createXMethod(this), n);
            return;
        } else {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addDefaultAnnotation(AnnotationDatabase.Target.METHOD, this.getDottedClassName(), n);
        }
    }

    static {
        defaultKind.put("", AnnotationDatabase.Target.ANY);
        defaultKind.put("ForParameters", AnnotationDatabase.Target.PARAMETER);
        defaultKind.put("ForMethods", AnnotationDatabase.Target.METHOD);
        defaultKind.put("ForFields", AnnotationDatabase.Target.FIELD);
    }
}

