/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowCFGPrinter;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.Analysis;
import edu.umd.cs.findbugs.ba.jsr305.BackwardTypeQualifierDataflow;
import edu.umd.cs.findbugs.ba.jsr305.BackwardTypeQualifierDataflowAnalysis;
import edu.umd.cs.findbugs.ba.jsr305.BackwardTypeQualifierDataflowFactory;
import edu.umd.cs.findbugs.ba.jsr305.FlowValue;
import edu.umd.cs.findbugs.ba.jsr305.ForwardTypeQualifierDataflow;
import edu.umd.cs.findbugs.ba.jsr305.ForwardTypeQualifierDataflowAnalysis;
import edu.umd.cs.findbugs.ba.jsr305.ForwardTypeQualifierDataflowFactory;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkInfo;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkType;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValueSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import edu.umd.cs.findbugs.bcel.CFGDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.util.Util;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.meta.When;
import org.apache.bcel.classfile.Method;

public class CheckTypeQualifiers
extends CFGDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("ctq.debug");
    private static final boolean DEBUG_DATAFLOW = SystemProperties.getBoolean("ctq.dataflow.debug");
    private static final String DEBUG_DATAFLOW_MODE = SystemProperties.getProperty("ctq.dataflow.debug.mode", "both");
    private static final String NONNULL_ANNOTATION = "javax/annotation/Nonnull";
    private static final String METHOD = SystemProperties.getProperty("ctq.method");
    private final BugReporter bugReporter;
    boolean checked;
    boolean shouldRunAnalysis;
    private String checkLocation;

    public CheckTypeQualifiers(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        if (!this.checked) {
            this.checked = true;
            Collection<TypeQualifierValue> allKnownTypeQualifiers = TypeQualifierValue.getAllKnownTypeQualifiers();
            int size = allKnownTypeQualifiers.size();
            if (size == 1) {
                TypeQualifierValue value = Util.first(allKnownTypeQualifiers);
                if (!value.typeQualifier.getClassName().equals(NONNULL_ANNOTATION)) {
                    this.shouldRunAnalysis = true;
                }
            } else if (size > 1) {
                this.shouldRunAnalysis = true;
            }
        }
        if (this.shouldRunAnalysis) {
            super.visitClass(classDescriptor);
        }
    }

    protected void visitMethodCFG(MethodDescriptor methodDescriptor, CFG cfg) throws CheckedAnalysisException {
        if (METHOD != null && !methodDescriptor.getName().equals(METHOD)) {
            return;
        }
        if (DEBUG) {
            System.out.println("CheckTypeQualifiers: checking " + methodDescriptor.toString());
        }
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        ForwardTypeQualifierDataflowFactory forwardDataflowFactory = analysisCache.getMethodAnalysis(ForwardTypeQualifierDataflowFactory.class, methodDescriptor);
        BackwardTypeQualifierDataflowFactory backwardDataflowFactory = analysisCache.getMethodAnalysis(BackwardTypeQualifierDataflowFactory.class, methodDescriptor);
        ValueNumberDataflow vnaDataflow = analysisCache.getMethodAnalysis(ValueNumberDataflow.class, methodDescriptor);
        Collection<TypeQualifierValue> relevantQualifiers = Analysis.getRelevantTypeQualifiers(methodDescriptor, cfg);
        if (DEBUG) {
            System.out.println("  Relevant type qualifiers are " + relevantQualifiers);
        }
        for (TypeQualifierValue typeQualifierValue : relevantQualifiers) {
            if (typeQualifierValue.getTypeQualifierClassDescriptor().getClassName().equals(NONNULL_ANNOTATION)) continue;
            try {
                this.checkQualifier(methodDescriptor, cfg, typeQualifierValue, forwardDataflowFactory, backwardDataflowFactory, vnaDataflow);
            }
            catch (MissingClassException e) {
                AnalysisContext.reportMissingClass(e);
            }
            catch (CheckedAnalysisException e) {
                this.bugReporter.logError("Exception checking type qualifier " + typeQualifierValue.toString() + " on method " + methodDescriptor.toString(), e);
            }
        }
    }

    private void checkQualifier(MethodDescriptor methodDescriptor, CFG cfg, TypeQualifierValue typeQualifierValue, ForwardTypeQualifierDataflowFactory forwardDataflowFactory, BackwardTypeQualifierDataflowFactory backwardDataflowFactory, ValueNumberDataflow vnaDataflow) throws CheckedAnalysisException {
        if (DEBUG) {
            System.out.println("----------------------------------------------------------------------");
            System.out.println("Checking type qualifier " + typeQualifierValue.toString() + " on method " + methodDescriptor.toString());
            if (typeQualifierValue.isStrictQualifier()) {
                System.out.println("  Strict type qualifier");
            }
            System.out.println("----------------------------------------------------------------------");
        }
        ForwardTypeQualifierDataflow forwardDataflow = (ForwardTypeQualifierDataflow)forwardDataflowFactory.getDataflow(typeQualifierValue);
        if (DEBUG_DATAFLOW && (DEBUG_DATAFLOW_MODE.startsWith("forward") || DEBUG_DATAFLOW_MODE.equals("both"))) {
            System.out.println("********* Forwards analysis *********");
            DataflowCFGPrinter<TypeQualifierValueSet, ForwardTypeQualifierDataflowAnalysis> p = new DataflowCFGPrinter<TypeQualifierValueSet, ForwardTypeQualifierDataflowAnalysis>(forwardDataflow);
            p.print(System.out);
        }
        BackwardTypeQualifierDataflow backwardDataflow = (BackwardTypeQualifierDataflow)backwardDataflowFactory.getDataflow(typeQualifierValue);
        if (DEBUG_DATAFLOW && (DEBUG_DATAFLOW_MODE.startsWith("backward") || DEBUG_DATAFLOW_MODE.equals("both"))) {
            System.out.println("********* Backwards analysis *********");
            DataflowCFGPrinter<TypeQualifierValueSet, BackwardTypeQualifierDataflowAnalysis> p = new DataflowCFGPrinter<TypeQualifierValueSet, BackwardTypeQualifierDataflowAnalysis>(backwardDataflow);
            p.print(System.out);
        }
        this.checkDataflow(methodDescriptor, cfg, typeQualifierValue, vnaDataflow, forwardDataflow, backwardDataflow);
        this.checkValueSources(methodDescriptor, cfg, typeQualifierValue, vnaDataflow, forwardDataflow, backwardDataflow);
    }

    private void checkDataflow(MethodDescriptor methodDescriptor, CFG cfg, TypeQualifierValue typeQualifierValue, ValueNumberDataflow vnaDataflow, ForwardTypeQualifierDataflow forwardDataflow, BackwardTypeQualifierDataflow backwardDataflow) throws DataflowAnalysisException, CheckedAnalysisException {
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location loc = i.next();
            TypeQualifierValueSet forwardsFact = (TypeQualifierValueSet)forwardDataflow.getFactAtLocation(loc);
            TypeQualifierValueSet backwardsFact = (TypeQualifierValueSet)backwardDataflow.getFactAfterLocation(loc);
            if (!forwardsFact.isValid() || !backwardsFact.isValid()) continue;
            if (DEBUG) {
                this.checkLocation = "location " + loc.toCompactString();
            }
            this.checkForConflictingValues(methodDescriptor, typeQualifierValue, forwardsFact, backwardsFact, loc, loc, (ValueNumberFrame)vnaDataflow.getFactAtLocation(loc));
        }
        i = cfg.edgeIterator();
        while (i.hasNext()) {
            Edge edge = (Edge)((Object)i.next());
            if (DEBUG) {
                this.checkLocation = "edge " + edge.getLabel();
                System.out.println("BEGIN CHECK EDGE " + edge.getLabel());
            }
            TypeQualifierValueSet forwardFact = (TypeQualifierValueSet)forwardDataflow.getFactOnEdge(edge);
            TypeQualifierValueSet backwardFact = (TypeQualifierValueSet)backwardDataflow.getResultFact((BasicBlock)edge.getTarget());
            Location edgeTargetLocation = this.getEdgeTargetLocation(cfg, edge);
            ValueNumberFrame vnaFrame = edgeTargetLocation != null ? (ValueNumberFrame)vnaDataflow.getFactAtLocation(edgeTargetLocation) : null;
            Location locationToReport = ((BasicBlock)edge.getSource()).getLastInstruction() != null ? this.getEdgeSourceLocation(cfg, edge) : edgeTargetLocation;
            this.checkForConflictingValues(methodDescriptor, typeQualifierValue, forwardFact, backwardFact, locationToReport, edgeTargetLocation, vnaFrame);
            if (!DEBUG) continue;
            System.out.println("END CHECK EDGE");
        }
    }

    private void checkValueSources(MethodDescriptor methodDescriptor, CFG cfg, TypeQualifierValue typeQualifierValue, ValueNumberDataflow vnaDataflow, ForwardTypeQualifierDataflow forwardDataflow, BackwardTypeQualifierDataflow backwardDataflow) throws DataflowAnalysisException {
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            Set<SourceSinkInfo> sourceSet = ((ForwardTypeQualifierDataflowAnalysis)forwardDataflow.getAnalysis()).getSourceSinkInfoSet(location);
            for (SourceSinkInfo source : sourceSet) {
                int p;
                XMethod xmethod;
                TypeQualifierAnnotation directTypeQualifierAnnotation;
                TypeQualifierValueSet forwardsFact;
                FlowValue forwardsFlowValue;
                ValueNumber vn = source.getValueNumber();
                TypeQualifierValueSet backwardsFact = (TypeQualifierValueSet)backwardDataflow.getFactAtLocation(location);
                FlowValue backwardsFlowValue = backwardsFact.getValue(vn);
                if (DEBUG) {
                    System.out.println("Checking value source at " + location.toCompactString());
                    System.out.println("  back=" + backwardsFact);
                    System.out.println("  source=" + source);
                }
                if (backwardsFlowValue != FlowValue.ALWAYS && backwardsFlowValue != FlowValue.NEVER || FlowValue.valuesConflict(forwardsFlowValue = (forwardsFact = (TypeQualifierValueSet)forwardDataflow.getFactAfterLocation(location)).getValue(vn), backwardsFlowValue)) continue;
                if (FlowValue.backwardsValueConflictsWithSource(backwardsFlowValue, source, typeQualifierValue)) {
                    String bugType = backwardsFlowValue == FlowValue.NEVER ? "TQ_MAYBE_SOURCE_VALUE_REACHES_NEVER_SINK" : "TQ_MAYBE_SOURCE_VALUE_REACHES_ALWAYS_SINK";
                    this.emitSourceWarning(bugType, methodDescriptor, typeQualifierValue, backwardsFlowValue, backwardsFact, source, vn, location);
                    continue;
                }
                if (source.getWhen() != When.UNKNOWN || source.getType() != SourceSinkType.PARAMETER || (directTypeQualifierAnnotation = TypeQualifierApplications.getDirectTypeQualifierAnnotation(xmethod = XFactory.createXMethod(methodDescriptor), p = source.getParameter(), typeQualifierValue)) == null || directTypeQualifierAnnotation.when != When.UNKNOWN) continue;
                String bugType = backwardsFlowValue == FlowValue.NEVER ? "TQ_EXPLICIT_UNKNOWN_SOURCE_VALUE_REACHES_NEVER_SINK" : "TQ_EXPLICIT_UNKNOWN_SOURCE_VALUE_REACHES_ALWAYS_SINK";
                this.emitSourceWarning(bugType, methodDescriptor, typeQualifierValue, backwardsFlowValue, backwardsFact, source, vn, location);
            }
        }
    }

    private Location getEdgeTargetLocation(CFG cfg, Edge edge) {
        BasicBlock targetBlock = (BasicBlock)edge.getTarget();
        if (targetBlock.getFirstInstruction() != null) {
            return new Location(targetBlock.getFirstInstruction(), targetBlock);
        }
        if (targetBlock.isExceptionThrower()) {
            BasicBlock fallThroughSuccessor = cfg.getSuccessorWithEdgeType(targetBlock, 0);
            if (fallThroughSuccessor == null) {
                Iterator<Edge> i = cfg.removedEdgeIterator();
                while (i.hasNext()) {
                    Edge removedEdge = i.next();
                    if (removedEdge.getSource() != targetBlock || removedEdge.getType() != 0) continue;
                    fallThroughSuccessor = (BasicBlock)removedEdge.getTarget();
                    break;
                }
            }
            if (fallThroughSuccessor != null && fallThroughSuccessor.getFirstInstruction() != null) {
                return new Location(fallThroughSuccessor.getFirstInstruction(), fallThroughSuccessor);
            }
        }
        return null;
    }

    private Location getEdgeSourceLocation(CFG cfg, Edge edge) {
        BasicBlock sourceBlock = (BasicBlock)edge.getSource();
        return sourceBlock.getLastInstruction() != null ? new Location(sourceBlock.getLastInstruction(), sourceBlock) : null;
    }

    private void checkForConflictingValues(MethodDescriptor methodDescriptor, TypeQualifierValue typeQualifierValue, TypeQualifierValueSet forwardsFact, TypeQualifierValueSet backwardsFact, Location locationToReport, Location locationWhereDoomedValueIsObserved, ValueNumberFrame vnaFrame) throws CheckedAnalysisException {
        HashSet<ValueNumber> valueNumberSet = new HashSet<ValueNumber>();
        valueNumberSet.addAll(forwardsFact.getValueNumbers());
        valueNumberSet.addAll(backwardsFact.getValueNumbers());
        for (ValueNumber vn : valueNumberSet) {
            FlowValue forward = forwardsFact.getValue(vn);
            FlowValue backward = backwardsFact.getValue(vn);
            if (DEBUG) {
                System.out.println("Check " + vn + ": forward=" + (Object)((Object)forward) + ", backward=" + (Object)((Object)backward) + " at " + this.checkLocation);
            }
            if (!FlowValue.valuesConflict(forward, backward)) continue;
            if (DEBUG) {
                System.out.println("Emitting warning at " + this.checkLocation);
            }
            this.emitDataflowWarning(methodDescriptor, typeQualifierValue, forwardsFact, backwardsFact, vn, forward, backward, locationToReport, locationWhereDoomedValueIsObserved, vnaFrame);
        }
    }

    private void emitDataflowWarning(MethodDescriptor methodDescriptor, TypeQualifierValue typeQualifierValue, TypeQualifierValueSet forwardsFact, TypeQualifierValueSet backwardsFact, ValueNumber vn, FlowValue forward, FlowValue backward, Location locationToReport, Location locationWhereDoomedValueIsObserved, ValueNumberFrame vnaFrame) throws CheckedAnalysisException {
        String bugType = backward == FlowValue.NEVER ? "TQ_ALWAYS_VALUE_USED_WHERE_NEVER_REQUIRED" : "TQ_NEVER_VALUE_USED_WHERE_ALWAYS_REQUIRED";
        BugInstance warning = new BugInstance(this, bugType, 2).addClassAndMethod(methodDescriptor);
        this.annotateWarningWithTypeQualifier(warning, typeQualifierValue);
        if (locationWhereDoomedValueIsObserved != null) {
            Method method = Global.getAnalysisCache().getMethodAnalysis(Method.class, methodDescriptor);
            LocalVariableAnnotation localVariable = ValueNumberSourceInfo.findLocalAnnotationFromValueNumber(method, locationWhereDoomedValueIsObserved, vn, vnaFrame);
            if (localVariable != null) {
                localVariable.setDescription(localVariable.isSignificant() ? "LOCAL_VARIABLE_VALUE_DOOMED_NAMED" : "LOCAL_VARIABLE_VALUE_DOOMED");
                warning.add(localVariable);
            }
            SourceLineAnnotation observedLocation = SourceLineAnnotation.fromVisitedInstruction(methodDescriptor, locationToReport);
            observedLocation.setDescription("SOURCE_LINE_VALUE_DOOMED");
            warning.add(observedLocation);
        }
        Set<SourceSinkInfo> sinkSet = backward == FlowValue.ALWAYS ? backwardsFact.getWhereAlways(vn) : backwardsFact.getWhereNever(vn);
        for (SourceSinkInfo sink : sinkSet) {
            this.annotateWarningWithSourceSinkInfo(warning, methodDescriptor, vn, sink);
        }
        this.bugReporter.reportBug(warning);
    }

    private void emitSourceWarning(String bugType, MethodDescriptor methodDescriptor, TypeQualifierValue typeQualifierValue, FlowValue backwardsFlowValue, TypeQualifierValueSet backwardsFact, SourceSinkInfo source, ValueNumber vn, Location location) {
        BugInstance warning = new BugInstance(this, bugType, 2).addClassAndMethod(methodDescriptor);
        this.annotateWarningWithTypeQualifier(warning, typeQualifierValue);
        this.annotateWarningWithSourceSinkInfo(warning, methodDescriptor, vn, source);
        Set<SourceSinkInfo> sinkSet = backwardsFlowValue == FlowValue.NEVER ? backwardsFact.getWhereNever(vn) : backwardsFact.getWhereAlways(vn);
        for (SourceSinkInfo sink : sinkSet) {
            this.annotateWarningWithSourceSinkInfo(warning, methodDescriptor, vn, sink);
        }
        this.bugReporter.reportBug(warning);
    }

    private void annotateWarningWithTypeQualifier(BugInstance warning, TypeQualifierValue typeQualifierValue) {
        StringBuilder buf = new StringBuilder();
        buf.append("@");
        buf.append(typeQualifierValue.typeQualifier.getDottedClassName());
        if (TypeQualifierValue.hasMultipleVariants(typeQualifierValue)) {
            buf.append("(");
            buf.append(typeQualifierValue.value);
            buf.append(")");
        }
        warning.addString(buf.toString()).describe("STRING_TYPE_QUALIFIER");
    }

    private void annotateWarningWithSourceSinkInfo(BugInstance warning, MethodDescriptor methodDescriptor, ValueNumber vn, SourceSinkInfo sourceSinkInfo) {
        switch (sourceSinkInfo.getType()) {
            case PARAMETER: {
                try {
                    Method method = Global.getAnalysisCache().getMethodAnalysis(Method.class, methodDescriptor);
                    LocalVariableAnnotation lva = LocalVariableAnnotation.getParameterLocalVariableAnnotation(method, sourceSinkInfo.getLocal());
                    lva.setDescription(lva.isSignificant() ? "LOCAL_VARIABLE_PARAMETER_VALUE_SOURCE_NAMED" : "LOCAL_VARIABLE_PARAMETER_VALUE_SOURCE");
                    warning.add(lva);
                }
                catch (CheckedAnalysisException e) {
                    warning.addSourceLine(methodDescriptor, sourceSinkInfo.getLocation()).describe("SOURCE_LINE_VALUE_SOURCE");
                }
                break;
            }
            case RETURN_VALUE_OF_CALLED_METHOD: 
            case FIELD_LOAD: {
                warning.addSourceLine(methodDescriptor, sourceSinkInfo.getLocation()).describe("SOURCE_LINE_VALUE_SOURCE");
                break;
            }
            case ARGUMENT_TO_CALLED_METHOD: 
            case RETURN_VALUE: 
            case FIELD_STORE: {
                warning.addSourceLine(methodDescriptor, sourceSinkInfo.getLocation()).describe("SOURCE_LINE_VALUE_SINK");
                return;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

