/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import org.apache.bcel.classfile.Method;

public class EqStringTest
extends BytecodeScanningDetector
implements StatelessDetector {
    boolean constantOnTOS = false;
    boolean callToInternSeen = false;
    boolean callToEqualsSeen = false;
    private BugAccumulator bugAccumulator;
    boolean stringOnTop;

    public EqStringTest(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visit(Method obj) {
        super.visit(obj);
        if (this.callToEqualsSeen) {
            this.bugAccumulator.clearBugs();
        } else {
            this.bugAccumulator.reportAccumulatedBugs();
        }
        this.constantOnTOS = false;
        this.callToInternSeen = false;
        this.callToEqualsSeen = false;
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 18: 
            case 19: {
                this.constantOnTOS = true;
                return;
            }
            case 182: {
                if (!this.getClassConstantOperand().equals("java/lang/String")) break;
                if (this.getNameConstantOperand().equals("intern")) {
                    this.callToInternSeen = true;
                }
                if (!this.getNameConstantOperand().equals("equals") && !this.getNameConstantOperand().equals("compareTo")) break;
                this.callToEqualsSeen = true;
                break;
            }
            case 165: 
            case 166: {
                if (!this.stringOnTop || !this.constantOnTOS || this.callToInternSeen) break;
                this.bugAccumulator.accumulateBug(new BugInstance(this, "ES_COMPARING_STRINGS_WITH_EQ", 2).addClassAndMethod(this).addType("Ljava/lang/String;").describe("TYPE_FOUND"), this);
                break;
            }
        }
        this.constantOnTOS = false;
    }

    public void sawString(String seen) {
        this.stringOnTop = true;
    }
}

