/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ProgramPoint;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class FieldItemSummary
extends OpcodeStackDetector
implements NonReportingDetector {
    FieldSummary fieldSummary = new FieldSummary();
    Set<XField> touched = new HashSet<XField>();
    boolean sawInitializeSuper;

    public FieldItemSummary(BugReporter bugReporter) {
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        context.setFieldSummary(this.fieldSummary);
    }

    public boolean shouldVisit(JavaClass obj) {
        return !this.getXClass().hasStubs();
    }

    public void sawOpcode(int seen) {
        int args;
        OpcodeStack.Item item;
        XMethod m;
        if (this.getMethodName().equals("<init>") && seen == 182 && (m = this.getXMethodOperand()) != null && !m.isPrivate() && !m.isFinal() && (item = this.stack.getStackItem(args = PreorderVisitor.getNumberArguments(m.getSignature()))).getRegisterNumber() == 0) {
            try {
                Set<XMethod> targets = Hierarchy2.resolveVirtualMethodCallTargets(m, false, false);
                Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                for (XMethod called : targets) {
                    if (called.isAbstract() || called.equals(m) || !subtypes2.isSubtype(called.getClassDescriptor(), this.getClassDescriptor())) continue;
                    this.fieldSummary.setCalledFromSuperConstructor(new ProgramPoint(this), called);
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
            }
        }
        if (seen == 183 && this.getMethodName().equals("<init>") && this.getNameConstantOperand().equals("<init>")) {
            String classOperand = this.getClassConstantOperand();
            OpcodeStack.Item invokedOn = this.stack.getItemMethodInvokedOn(this);
            if (invokedOn.getRegisterNumber() == 0 && !classOperand.equals(this.getClassName())) {
                this.sawInitializeSuper = true;
                XMethod invoked = this.getXMethodOperand();
                if (invoked != null) {
                    this.fieldSummary.sawSuperCall(this.getXMethod(), invoked);
                }
            }
        }
        if (seen == 181 || seen == 179) {
            XField fieldOperand = this.getXFieldOperand();
            if (fieldOperand == null) {
                return;
            }
            this.touched.add(fieldOperand);
            if (!fieldOperand.getClassDescriptor().getClassName().equals(this.getClassName())) {
                this.fieldSummary.addWrittenOutsideOfConstructor(fieldOperand);
            } else if (seen == 181) {
                OpcodeStack.Item addr = this.stack.getStackItem(1);
                if (addr.getRegisterNumber() != 0 || !this.getMethodName().equals("<init>")) {
                    this.fieldSummary.addWrittenOutsideOfConstructor(fieldOperand);
                }
            } else if (seen == 179 && !this.getMethodName().equals("<clinit>")) {
                this.fieldSummary.addWrittenOutsideOfConstructor(fieldOperand);
            }
            OpcodeStack.Item top = this.stack.getStackItem(0);
            this.fieldSummary.mergeSummary(fieldOperand, top);
        }
    }

    public void visit(Code obj) {
        this.sawInitializeSuper = false;
        super.visit(obj);
        this.fieldSummary.setFieldsWritten(this.getXMethod(), this.touched);
        if (this.getMethodName().equals("<init>") && this.sawInitializeSuper) {
            XClass thisClass = this.getXClass();
            for (XField xField : thisClass.getXFields()) {
                if (this.touched.contains(xField)) continue;
                char firstChar = xField.getSignature().charAt(0);
                OpcodeStack.Item item = firstChar == 'L' || firstChar == '[' ? OpcodeStack.Item.nullItem(xField.getSignature()) : (firstChar == 'I' ? new OpcodeStack.Item("I", (Object)0) : (firstChar == 'J' ? new OpcodeStack.Item("J", 0L) : new OpcodeStack.Item(xField.getSignature())));
                this.fieldSummary.mergeSummary(xField, item);
            }
        }
        this.touched.clear();
    }

    public void report() {
        this.fieldSummary.setComplete(true);
    }
}

