/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;

public class FindLocalSelfAssignment2
extends BytecodeScanningDetector
implements StatelessDetector {
    private BugReporter bugReporter;
    private int previousLoadOf = -1;
    private int previousGotoTarget;
    private int gotoCount;
    private BitSet previousStores = new BitSet();

    public FindLocalSelfAssignment2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.previousLoadOf = -1;
        this.previousGotoTarget = -1;
        this.gotoCount = 0;
        this.previousStores.clear();
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (seen == 167) {
            this.previousGotoTarget = this.getBranchTarget();
            ++this.gotoCount;
            if (this.previousGotoTarget < this.getPC()) {
                this.previousLoadOf = -1;
            }
        } else if (this.isRegisterLoad()) {
            this.previousLoadOf = this.getRegisterOperand();
        } else {
            if (this.isRegisterStore()) {
                if (this.previousLoadOf == this.getRegisterOperand() && this.gotoCount < 2 && this.getPC() != this.previousGotoTarget) {
                    int priority = 2;
                    String methodName = this.getMethodName();
                    if (methodName.equals("<init>") || methodName.startsWith("set") && this.getCode().getCode().length <= 5 || !this.previousStores.get(this.getRegisterOperand())) {
                        priority = 1;
                    }
                    this.bugReporter.reportBug(new BugInstance(this, "SA_LOCAL_SELF_ASSIGNMENT", priority).addClassAndMethod(this).add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), this.getRegisterOperand(), this.getPC(), this.getPC())).addSourceLine(this));
                }
                this.previousStores.set(this.getRegisterOperand());
            }
            this.previousLoadOf = -1;
            this.gotoCount = 0;
        }
    }
}

