/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.UseAnnotationDatabase;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CheckReturnAnnotationDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnValueAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class MethodReturnCheck
extends OpcodeStackDetector
implements UseAnnotationDatabase {
    private static final boolean DEBUG = SystemProperties.getBoolean("mrc.debug");
    private static final int SCAN = 0;
    private static final int SAW_INVOKE = 1;
    private static final BitSet INVOKE_OPCODE_SET = new BitSet();
    boolean previousOpcodeWasNEW;
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private CheckReturnAnnotationDatabase checkReturnAnnotationDatabase;
    private Method method;
    private XMethod callSeen;
    private int state;
    private int callPC;

    public MethodReturnCheck(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visitClassContext(ClassContext classContext) {
        this.checkReturnAnnotationDatabase = AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase();
        super.visitClassContext(classContext);
    }

    public void visit(Method method) {
        this.method = method;
    }

    public void visitCode(Code code) {
        if (DEBUG) {
            System.out.println("Visiting " + this.method);
        }
        super.visitCode(code);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    public void sawOpcode(int seen) {
        int arguments;
        if (DEBUG) {
            System.out.println(this.state + " " + OPCODE_NAMES[seen]);
        }
        if (seen == 183 && this.getNameConstantOperand().equals("<init>") && (arguments = PreorderVisitor.getNumberArguments(this.getSigConstantOperand())) + 1 == this.stack.getStackDepth()) {
            OpcodeStack.Item invokedOn = this.stack.getStackItem(arguments);
            if (!this.getMethodName().equals("<init>") || invokedOn.getRegisterNumber() != 0) {
                this.callSeen = XFactory.createReferencedXMethod(this);
                this.callPC = this.getPC();
                this.sawMethodCallWithIgnoredReturnValue();
            }
        }
        if (this.state == 1 && this.isPop(seen)) {
            this.sawMethodCallWithIgnoredReturnValue();
        } else if (INVOKE_OPCODE_SET.get(seen)) {
            this.callPC = this.getPC();
            this.callSeen = XFactory.createReferencedXMethod(this);
            this.state = 1;
            if (DEBUG) {
                System.out.println("  invoking " + this.callSeen);
            }
        } else {
            this.state = 0;
        }
        if (seen == 187) {
            this.previousOpcodeWasNEW = true;
        } else {
            CheckReturnValueAnnotation annotation;
            if (seen == 183 && this.previousOpcodeWasNEW && (annotation = this.checkReturnAnnotationDatabase.getResolvedAnnotation(this.callSeen, false)) != null && annotation != CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE) {
                int priority = annotation.getPriority();
                if (!this.checkReturnAnnotationDatabase.annotationIsDirect(this.callSeen) && !this.callSeen.getSignature().endsWith(this.callSeen.getClassName().replace('.', '/') + ";")) {
                    ++priority;
                }
                this.bugAccumulator.accumulateBug(new BugInstance(this, annotation.getPattern(), priority).addClassAndMethod(this).addCalledMethod(this), this);
            }
            this.previousOpcodeWasNEW = false;
        }
    }

    private void sawMethodCallWithIgnoredReturnValue() {
        CheckReturnValueAnnotation annotation = this.checkReturnAnnotationDatabase.getResolvedAnnotation(this.callSeen, false);
        if (annotation != null && annotation != CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE) {
            int popPC = this.getPC();
            if (DEBUG) {
                System.out.println("Saw POP @" + popPC);
            }
            int catchSize = this.getSizeOfSurroundingTryBlock(popPC);
            int priority = annotation.getPriority();
            if (catchSize <= 1) {
                priority += 2;
            } else if (catchSize <= 2) {
                ++priority;
            }
            if (!this.checkReturnAnnotationDatabase.annotationIsDirect(this.callSeen) && !this.callSeen.getSignature().endsWith(this.callSeen.getClassName().replace('.', '/') + ";")) {
                ++priority;
            }
            if (this.callSeen.isPrivate()) {
                ++priority;
            }
            String pattern = annotation.getPattern();
            if (this.callSeen.getName().equals("<init>") && (this.callSeen.getClassName().endsWith("Exception") || this.callSeen.getClassName().endsWith("Error"))) {
                pattern = "RV_EXCEPTION_NOT_THROWN";
            }
            BugInstance warning = new BugInstance(this, pattern, priority).addClassAndMethod(this).addMethod(this.callSeen).describe("METHOD_CALLED");
            this.bugAccumulator.accumulateBug(warning, SourceLineAnnotation.fromVisitedInstruction(this, this.callPC));
        }
        this.state = 0;
    }

    private boolean isPop(int seen) {
        return seen == 87 || seen == 88;
    }

    static {
        INVOKE_OPCODE_SET.set(185);
        INVOKE_OPCODE_SET.set(183);
        INVOKE_OPCODE_SET.set(184);
        INVOKE_OPCODE_SET.set(182);
    }
}

