/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import java.util.Map;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteJCIPAnnotation
extends AnnotationVisitor
implements Detector,
NonReportingDetector {
    private static final String NET_JCIP_ANNOTATIONS = "net.jcip.annotations.";

    public NoteJCIPAnnotation(BugReporter bugReporter) {
    }

    @Override
    public void visitAnnotation(String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        AnnotatedObject member;
        if (!annotationClass.startsWith(NET_JCIP_ANNOTATIONS)) {
            return;
        }
        annotationClass = annotationClass.substring(NET_JCIP_ANNOTATIONS.length());
        ElementValue value = map.get("value");
        if (this.visitingField()) {
            member = XFactory.createXField(this);
        } else if (this.visitingMethod()) {
            member = XFactory.createXMethod(this);
        } else {
            Map<String, ElementValue> annotationsOfThisClass = AnalysisContext.currentAnalysisContext().getJCIPAnnotationDatabase().getEntryForClass(this.getDottedClassName());
            annotationsOfThisClass.put(annotationClass, value);
            return;
        }
        Map<String, ElementValue> annotationsOfThisMember = AnalysisContext.currentAnalysisContext().getJCIPAnnotationDatabase().getEntryForClassMember((ClassMember)((Object)member));
        annotationsOfThisMember.put(annotationClass, value);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        if (!BCELUtil.preTiger(javaClass)) {
            javaClass.accept((Visitor)this);
        }
    }

    @Override
    public void report() {
    }
}

