/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.EqualsKindSummary;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.bcel.classfile.Code;

public class OverridingEqualsNotSymmetrical
extends OpcodeStackDetector
implements NonReportingDetector {
    private static final String EQUALS_NAME = "equals";
    private static final String EQUALS_SIGNATURE = "(Ljava/lang/Object;)Z";
    private static final String STATIC_EQUALS_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;)Z";
    Map<ClassDescriptor, Set<ClassDescriptor>> classesWithGetClassBasedEquals = new HashMap<ClassDescriptor, Set<ClassDescriptor>>();
    Map<ClassDescriptor, Set<ClassDescriptor>> classesWithInstanceOfBasedEquals = new HashMap<ClassDescriptor, Set<ClassDescriptor>>();
    Map<ClassAnnotation, ClassAnnotation> parentMap = new TreeMap<ClassAnnotation, ClassAnnotation>();
    Map<ClassAnnotation, MethodAnnotation> equalsMethod = new TreeMap<ClassAnnotation, MethodAnnotation>();
    final BugReporter bugReporter;
    final BugAccumulator bugAccumulator;
    final EqualsKindSummary equalsKindSummary;
    boolean sawInstanceOf;
    boolean sawInstanceOfSupertype;
    boolean sawCheckedCast;
    boolean sawGetClass;
    boolean sawReturnSuper;
    boolean sawSuperEquals;
    boolean sawReturnNonSuper;
    boolean prevWasSuperEquals;
    boolean sawInitialIdentityCheck;
    boolean alwaysTrue;
    boolean alwaysFalse;
    int equalsCalls;
    boolean sawGoodEqualsClass;
    boolean sawBadEqualsClass;
    boolean sawCompare;
    boolean dangerDanger = false;
    boolean sawStaticDelegate;
    boolean sawEqualsBuilder;
    private EnumMap<EqualsKindSummary.KindOfEquals, Integer> count = new EnumMap(EqualsKindSummary.KindOfEquals.class);

    public OverridingEqualsNotSymmetrical(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.equalsKindSummary = AnalysisContext.currentAnalysisContext().getEqualsKindSummary();
    }

    public void visit(Code obj) {
        if (this.getMethodName().equals(EQUALS_NAME) && !this.getMethod().isStatic() && this.getMethod().isPublic() && this.getMethodSig().equals(EQUALS_SIGNATURE)) {
            String superClassName;
            Set<ClassDescriptor> subtypes;
            ClassDescriptor classDescriptor;
            this.sawEqualsBuilder = false;
            this.sawStaticDelegate = false;
            this.alwaysFalse = false;
            this.alwaysTrue = false;
            this.sawInstanceOfSupertype = false;
            this.dangerDanger = false;
            this.sawBadEqualsClass = false;
            this.sawGoodEqualsClass = false;
            this.prevWasSuperEquals = false;
            this.sawReturnNonSuper = false;
            this.sawCompare = false;
            this.sawReturnSuper = false;
            this.sawGetClass = false;
            this.sawInstanceOf = false;
            this.sawSuperEquals = false;
            this.sawCheckedCast = false;
            this.sawInitialIdentityCheck = obj.getCode().length == 11 || obj.getCode().length == 9;
            this.equalsCalls = 0;
            super.visit(obj);
            EqualsKindSummary.KindOfEquals kind = EqualsKindSummary.KindOfEquals.UNKNOWN;
            if (this.alwaysTrue) {
                kind = EqualsKindSummary.KindOfEquals.ALWAYS_TRUE;
            } else if (this.alwaysFalse) {
                kind = EqualsKindSummary.KindOfEquals.ALWAYS_FALSE;
            } else if (this.sawReturnSuper && !this.sawReturnNonSuper) {
                kind = EqualsKindSummary.KindOfEquals.RETURNS_SUPER;
            } else if (this.sawSuperEquals) {
                kind = EqualsKindSummary.KindOfEquals.INVOKES_SUPER;
            } else if (this.sawInstanceOf || this.sawInstanceOfSupertype) {
                kind = this.getThisClass().isAbstract() ? EqualsKindSummary.KindOfEquals.ABSTRACT_INSTANCE_OF : EqualsKindSummary.KindOfEquals.INSTANCE_OF_EQUALS;
            } else if (this.sawGetClass && this.sawGoodEqualsClass) {
                kind = this.getThisClass().isAbstract() ? EqualsKindSummary.KindOfEquals.ABSTRACT_GETCLASS_GOOD_EQUALS : EqualsKindSummary.KindOfEquals.GETCLASS_GOOD_EQUALS;
            } else if (this.sawGetClass && this.sawBadEqualsClass) {
                kind = EqualsKindSummary.KindOfEquals.GETCLASS_BAD_EQUALS;
            } else if (this.equalsCalls == 1 || this.sawStaticDelegate || this.sawEqualsBuilder) {
                kind = EqualsKindSummary.KindOfEquals.DELEGATE_EQUALS;
            } else if (this.sawInitialIdentityCheck) {
                kind = EqualsKindSummary.KindOfEquals.TRIVIAL_EQUALS;
            } else if (this.sawCheckedCast) {
                kind = EqualsKindSummary.KindOfEquals.CHECKED_CAST_EQUALS;
            } else if (this.sawCompare) {
                kind = EqualsKindSummary.KindOfEquals.COMPARE_EQUALS;
            } else if (AnalysisContext.currentAnalysisContext().isApplicationClass(this.getThisClass())) {
                this.bugReporter.reportBug(new BugInstance(this, "EQ_UNUSUAL", 2).addClassAndMethod(this));
            }
            ClassAnnotation classAnnotation = new ClassAnnotation(this.getDottedClassName());
            this.equalsKindSummary.put(classAnnotation, kind);
            this.count(kind);
            if (kind == EqualsKindSummary.KindOfEquals.GETCLASS_GOOD_EQUALS || kind == EqualsKindSummary.KindOfEquals.ABSTRACT_GETCLASS_GOOD_EQUALS || kind == EqualsKindSummary.KindOfEquals.GETCLASS_BAD_EQUALS) {
                classDescriptor = this.getClassDescriptor();
                try {
                    subtypes = AnalysisContext.currentAnalysisContext().getSubtypes2().getSubtypes(classDescriptor);
                    if (subtypes.size() > 1) {
                        this.classesWithGetClassBasedEquals.put(classDescriptor, subtypes);
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (kind == EqualsKindSummary.KindOfEquals.INSTANCE_OF_EQUALS || kind == EqualsKindSummary.KindOfEquals.ABSTRACT_INSTANCE_OF) {
                classDescriptor = this.getClassDescriptor();
                try {
                    subtypes = AnalysisContext.currentAnalysisContext().getSubtypes2().getSubtypes(classDescriptor);
                    if (subtypes.size() > 1) {
                        this.classesWithInstanceOfBasedEquals.put(classDescriptor, subtypes);
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (!(superClassName = this.getSuperclassName().replace('/', '.')).equals("java.lang.Object")) {
                this.parentMap.put(classAnnotation, new ClassAnnotation(superClassName));
            }
            this.equalsMethod.put(classAnnotation, MethodAnnotation.fromVisitedMethod(this));
        }
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private void count(EqualsKindSummary.KindOfEquals k) {
        Integer v = this.count.get((Object)k);
        if (v == null) {
            this.count.put(k, 1);
        } else {
            this.count.put(k, v + 1);
        }
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item left;
        if (this.getPC() == 2 && seen != 165 && seen != 166) {
            this.sawInitialIdentityCheck = false;
        }
        if (this.getPC() == 2 && seen == 184 && this.getCode().getCode().length == 6 && (this.getPrevOpcode(1) == 42 && this.getPrevOpcode(2) == 43 || this.getPrevOpcode(1) == 43 && this.getPrevOpcode(2) == 42)) {
            this.sawStaticDelegate = true;
        }
        if ((seen == 184 || seen == 183 || seen == 182) && this.getClassConstantOperand().equals("org/apache/commons/lang/builder/EqualsBuilder")) {
            this.sawEqualsBuilder = true;
        }
        if (seen == 172 && this.getPC() == 1 && this.getPrevOpcode(1) == 3) {
            this.alwaysFalse = true;
            if (AnalysisContext.currentAnalysisContext().isApplicationClass(this.getThisClass())) {
                this.bugReporter.reportBug(new BugInstance(this, "EQ_ALWAYS_FALSE", 1).addClassAndMethod(this).addSourceLine(this));
            }
        }
        if (seen == 172 && this.getPC() == 1 && this.getPrevOpcode(1) == 4) {
            this.alwaysTrue = true;
            if (AnalysisContext.currentAnalysisContext().isApplicationClass(this.getThisClass())) {
                this.bugReporter.reportBug(new BugInstance(this, "EQ_ALWAYS_TRUE", 1).addClassAndMethod(this).addSourceLine(this));
            }
        }
        if (seen == 165 || seen == 166) {
            this.checkForComparingClasses();
        }
        if (this.callToInvoke(seen)) {
            ++this.equalsCalls;
            this.checkForComparingClasses();
            if (AnalysisContext.currentAnalysisContext().isApplicationClass(this.getThisClass()) && this.dangerDanger) {
                this.bugReporter.reportBug(new BugInstance(this, "EQ_COMPARING_CLASS_NAMES", 2).addClassAndMethod(this).addSourceLine(this));
            }
        }
        if ((seen == 185 || seen == 182) && this.getNameConstantOperand().equals("compare") && this.stack.getStackDepth() >= 2) {
            left = this.stack.getStackItem(1);
            OpcodeStack.Item right = this.stack.getStackItem(0);
            if (left.getRegisterNumber() + right.getRegisterNumber() == 1) {
                this.sawCompare = true;
            }
        }
        this.dangerDanger = false;
        if (seen == 182 && this.getClassConstantOperand().equals("java/lang/Class") && this.getNameConstantOperand().equals("getName") && this.getSigConstantOperand().equals("()Ljava/lang/String;") && this.stack.getStackDepth() >= 2) {
            left = this.stack.getStackItem(1);
            XMethod leftM = left.getReturnValueOf();
            OpcodeStack.Item right = this.stack.getStackItem(0);
            XMethod rightM = right.getReturnValueOf();
            if (leftM != null && rightM != null && leftM.getName().equals("getName") && rightM.getName().equals("getClass")) {
                this.dangerDanger = true;
            }
        }
        if (seen == 183 && this.getNameConstantOperand().equals(EQUALS_NAME) && this.getSigConstantOperand().equals(EQUALS_SIGNATURE)) {
            this.prevWasSuperEquals = true;
            this.sawSuperEquals = true;
        } else {
            if (seen == 172) {
                if (this.prevWasSuperEquals) {
                    this.sawReturnSuper = true;
                } else {
                    this.sawReturnNonSuper = true;
                }
            }
            this.prevWasSuperEquals = false;
        }
        if (seen == 193 && this.stack.getStackDepth() > 0 && this.stack.getStackItem(0).getRegisterNumber() == 1) {
            ClassDescriptor instanceOfCheck = this.getClassDescriptorOperand();
            if (instanceOfCheck.equals(this.getClassDescriptor())) {
                this.sawInstanceOf = true;
            } else {
                try {
                    if (AnalysisContext.currentAnalysisContext().getSubtypes2().isSubtype(this.getClassDescriptor(), instanceOfCheck)) {
                        this.sawInstanceOfSupertype = true;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.sawInstanceOfSupertype = true;
                }
            }
        }
        if (seen == 192 && this.stack.getStackDepth() > 0 && this.stack.getStackItem(0).getRegisterNumber() == 1) {
            ClassDescriptor castTo = this.getClassDescriptorOperand();
            if (castTo.equals(this.getClassDescriptor())) {
                this.sawCheckedCast = true;
            }
            try {
                if (AnalysisContext.currentAnalysisContext().getSubtypes2().isSubtype(this.getClassDescriptor(), castTo)) {
                    this.sawCheckedCast = true;
                }
            }
            catch (ClassNotFoundException e) {
                this.sawCheckedCast = true;
            }
        }
        if (seen == 182 && this.getNameConstantOperand().equals("getClass") && this.getSigConstantOperand().equals("()Ljava/lang/Class;")) {
            this.sawGetClass = true;
        }
    }

    private boolean callToInvoke(int seen) {
        if (seen == 182 || seen == 185 || seen == 183) {
            return this.getNameConstantOperand().startsWith(EQUALS_NAME) && this.getSigConstantOperand().equals(EQUALS_SIGNATURE);
        }
        if (seen == 184) {
            String sig = this.getSigConstantOperand();
            return this.getNameConstantOperand().startsWith(EQUALS_NAME) && sig.endsWith("Ljava/lang/Object;)Z");
        }
        return false;
    }

    private void checkForComparingClasses() {
        if (this.stack.getStackDepth() >= 2) {
            OpcodeStack.Item left = this.stack.getStackItem(1);
            XMethod leftM = left.getReturnValueOf();
            OpcodeStack.Item right = this.stack.getStackItem(0);
            XMethod rightM = right.getReturnValueOf();
            if (left.getSignature().equals("Ljava/lang/Class;") && right.getSignature().equals("Ljava/lang/Class;")) {
                boolean rightMatch;
                boolean leftMatch = leftM != null && leftM.getName().equals("getClass");
                boolean bl = rightMatch = rightM != null && rightM.getName().equals("getClass");
                if (leftMatch && rightMatch) {
                    this.sawGoodEqualsClass = true;
                } else if (this.getClassName().equals(left.getConstant()) && rightMatch || leftMatch && this.getClassName().equals(right.getConstant())) {
                    if (this.getThisClass().isFinal()) {
                        this.sawGoodEqualsClass = true;
                    } else {
                        this.sawBadEqualsClass = true;
                        if (AnalysisContext.currentAnalysisContext().isApplicationClass(this.getThisClass())) {
                            int priority = 2;
                            BugInstance bug = new BugInstance(this, "EQ_GETCLASS_AND_CLASS_CONSTANT", priority).addClassAndMethod(this);
                            try {
                                Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                                Set<ClassDescriptor> subtypes = subtypes2.getDirectSubtypes(this.getClassDescriptor());
                                for (ClassDescriptor c : subtypes) {
                                    try {
                                        Global.getAnalysisCache().getClassAnalysis(XClass.class, c);
                                    }
                                    catch (CheckedAnalysisException e) {
                                        continue;
                                    }
                                    XMethod m = Hierarchy2.findMethod(c, EQUALS_NAME, EQUALS_SIGNATURE, false);
                                    if (m != null) continue;
                                    bug.addClass(c).describe("CLASS_SUBCLASS");
                                    bug.setPriority(--priority);
                                }
                            }
                            catch (ClassNotFoundException e) {
                                this.bugReporter.reportMissingClass(e);
                            }
                            this.bugAccumulator.accumulateBug(bug, this);
                        }
                    }
                }
            }
        }
    }

    public void report() {
        for (Map.Entry<ClassAnnotation, ClassAnnotation> e : this.parentMap.entrySet()) {
            ClassAnnotation childClass = e.getKey();
            EqualsKindSummary.KindOfEquals childKind = this.equalsKindSummary.get(childClass);
            ClassAnnotation parentClass = e.getValue();
            EqualsKindSummary.KindOfEquals parentKind = this.equalsKindSummary.get(parentClass);
            if (parentKind == null || childKind != EqualsKindSummary.KindOfEquals.INSTANCE_OF_EQUALS || parentKind != EqualsKindSummary.KindOfEquals.INSTANCE_OF_EQUALS) continue;
            this.bugReporter.reportBug(new BugInstance(this, "EQ_OVERRIDING_EQUALS_NOT_SYMMETRIC", 2).add(childClass).add(this.equalsMethod.get(childClass)).add(this.equalsMethod.get(parentClass)).describe("METHOD_OVERRIDDEN"));
        }
    }
}

