/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class StaticCalendarDetector
extends OpcodeStackDetector {
    private static final boolean DEBUG = Boolean.getBoolean("debug.staticcal");
    private static final String PROP_SKIP_SYNCHRONIZED_CHECK = "staticcal.skipsynccheck";
    private final BugReporter reporter;
    private final BugAccumulator bugAccumulator;
    private String currentClass;
    private final ClassDescriptor calendarType = DescriptorFactory.createClassDescriptor(Calendar.class);
    private final ClassDescriptor dateFormatType = DescriptorFactory.createClassDescriptor(DateFormat.class);
    private Method currentMethod = null;
    private CFG currentCFG;
    private LockDataflow currentLockDataFlow;
    private Map<XField, BugInstance> pendingBugs = new HashMap<XField, BugInstance>();
    Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
    private boolean sawDateClass;

    public StaticCalendarDetector(BugReporter aReporter) {
        this.reporter = aReporter;
        this.bugAccumulator = new BugAccumulator(this.reporter);
    }

    public void visit(JavaClass someObj) {
        this.currentClass = someObj.getClassName();
        this.currentMethod = null;
        this.currentCFG = null;
        this.currentLockDataFlow = null;
        this.sawDateClass = false;
    }

    public void visit(ConstantPool pool) {
        for (Constant constant : pool.getConstantPool()) {
            ConstantClass cc;
            String className;
            if (!(constant instanceof ConstantClass) || !(className = (cc = (ConstantClass)constant).getBytes(pool)).equals("java/util/Calendar") && !className.equals("java/text/DateFormat")) continue;
            this.sawDateClass = true;
        }
    }

    public void visit(Field aField) {
        int priority;
        if (aField.isPrivate()) {
            return;
        }
        String superclassName = this.getSuperclassName();
        if (!aField.isStatic() && !superclassName.equals("java/lang/Enum")) {
            return;
        }
        if (!aField.isPublic() && !aField.isProtected()) {
            return;
        }
        ClassDescriptor classOfField = DescriptorFactory.createClassDescriptorFromFieldSignature(aField.getSignature());
        String tBugType = null;
        int n = priority = aField.isPublic() && aField.isFinal() && aField.getName().equals(aField.getName().toUpperCase()) && this.getThisClass().isPublic() ? 1 : 2;
        if (classOfField != null) {
            try {
                if (this.subtypes2.isSubtype(classOfField, this.calendarType)) {
                    tBugType = "STCAL_STATIC_CALENDAR_INSTANCE";
                    ++priority;
                } else if (this.subtypes2.isSubtype(classOfField, this.dateFormatType)) {
                    tBugType = "STCAL_STATIC_SIMPLE_DATE_FORMAT_INSTANCE";
                }
                if (this.getClassContext().getXClass().usesConcurrency()) {
                    --priority;
                }
                if (tBugType != null) {
                    this.pendingBugs.put(this.getXField(), new BugInstance(this, tBugType, priority).addClass(this.currentClass).addField(this));
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
            }
        }
    }

    public void visitMethod(Method obj) {
        if (this.sawDateClass) {
            try {
                super.visitMethod(obj);
                this.currentMethod = obj;
                this.currentLockDataFlow = this.getClassContext().getLockDataflow(this.currentMethod);
                this.currentCFG = this.getClassContext().getCFG(this.currentMethod);
            }
            catch (CFGBuilderException e) {
                this.reporter.logError("Synchronization check in Static Calendar Detector caught an error.", e);
            }
            catch (DataflowAnalysisException e) {
                this.reporter.logError("Synchronization check in Static Calendar Detector caught an error.", e);
            }
        }
    }

    public void visit(Code obj) {
        if (this.sawDateClass) {
            super.visit(obj);
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    public void sawOpcode(int seen) {
        XField f;
        if (seen == 178 && this.pendingBugs.containsKey(f = this.getXFieldOperand()) && !this.isLocked()) {
            this.reporter.reportBug(this.pendingBugs.remove(f));
        }
        if (seen != 182) {
            return;
        }
        try {
            int priority;
            String tBugType;
            OpcodeStack.Item passedAsArgument;
            String className = this.getClassConstantOperand();
            if (className.startsWith("[")) {
                return;
            }
            ClassDescriptor cDesc = DescriptorFactory.createClassDescriptor(className);
            boolean isCalendar = this.subtypes2.isSubtype(cDesc, this.calendarType);
            boolean isDateFormat = this.subtypes2.isSubtype(cDesc, this.dateFormatType);
            if (!isCalendar && !isDateFormat) {
                return;
            }
            int numArguments = StaticCalendarDetector.getNumberArguments(this.getSigConstantOperand());
            OpcodeStack.Item invokedOn = this.stack.getStackItem(numArguments);
            XField field = invokedOn.getXField();
            if (field == null || !field.isStatic()) {
                return;
            }
            if (this.getMethodName().equals("<clinit>") && field.getClassName().equals(this.getDottedClassName())) {
                return;
            }
            String invokedName = this.getNameConstantOperand();
            if (invokedName.startsWith("get")) {
                return;
            }
            if (invokedName.equals("equals") && numArguments == 1 && ((field = (passedAsArgument = this.stack.getStackItem(0)).getXField()) == null || !field.isStatic())) {
                return;
            }
            if (!SystemProperties.getBoolean(PROP_SKIP_SYNCHRONIZED_CHECK) && this.isLocked()) {
                return;
            }
            if (isCalendar) {
                tBugType = "STCAL_INVOKE_ON_STATIC_CALENDAR_INSTANCE";
            } else if (isDateFormat) {
                tBugType = "STCAL_INVOKE_ON_STATIC_DATE_FORMAT_INSTANCE";
            } else {
                throw new IllegalStateException("Not possible");
            }
            if (this.amVisitingMainMethod()) {
                priority = 3;
            } else {
                priority = this.getClassContext().getXClass().usesConcurrency() ? 2 : 3;
                if (invokedName.startsWith("set") || invokedName.equals("format") || invokedName.equals("add") || invokedName.equals("clear") || invokedName.equals("parse") || invokedName.equals("applyPattern")) {
                    --priority;
                }
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, tBugType, priority).addClassAndMethod(this).addCalledMethod(this).addOptionalField(field), this);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
    }

    private boolean isLocked() {
        try {
            if (this.currentMethod != null && this.currentLockDataFlow != null && this.currentCFG != null) {
                Collection<Location> tLocations = this.currentCFG.getLocationsContainingInstructionWithOffset(this.getPC());
                for (Location tLoc : tLocations) {
                    LockSet lockSet = (LockSet)this.currentLockDataFlow.getFactAtLocation(tLoc);
                    if (lockSet.getNumLockedObjects() <= 0) continue;
                    return true;
                }
            }
        }
        catch (DataflowAnalysisException e) {
            this.reporter.logError("Synchronization check in Static Calendar Detector caught an error.", e);
        }
        return false;
    }
}

