/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;

public class SynchronizationOnSharedBuiltinConstant
extends OpcodeStackDetector {
    final Set<String> badSignatures;
    final BugAccumulator bugAccumulator;
    private static final Pattern identified = Pattern.compile("\\p{Alnum}+");
    BugInstance pendingBug;
    int monitorEnterPC;
    String syncSignature;
    boolean isSyncOnBoolean;

    public SynchronizationOnSharedBuiltinConstant(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.badSignatures = new HashSet<String>();
        this.badSignatures.addAll(Arrays.asList("Ljava/lang/Boolean;", "Ljava/lang/Double;", "Ljava/lang/Float;", "Ljava/lang/Byte;", "Ljava/lang/Character;", "Ljava/lang/Short;", "Ljava/lang/Integer;", "Ljava/lang/Long;"));
    }

    private static boolean newlyConstructedObject(OpcodeStack.Item item) {
        XMethod method = item.getReturnValueOf();
        if (method == null) {
            return false;
        }
        return method.getName().equals("<init>");
    }

    public void visit(Code obj) {
        super.visit(obj);
        this.accumulateBug();
        this.bugAccumulator.reportAccumulatedBugs();
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 194: {
                OpcodeStack.Item top = this.stack.getStackItem(0);
                if (this.pendingBug != null) {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "TESTING", this.isSyncOnBoolean ? 1 : 2).addClassAndMethod(this).addString("Getting lock while holding lock on shared object").addSourceLine(this, this.monitorEnterPC).describe("SOURCE_LINE_LOCK_OBTAINED_AT").addType(this.syncSignature).addValueSource(top, this), this);
                    this.accumulateBug();
                }
                this.monitorEnterPC = this.getPC();
                this.syncSignature = top.getSignature();
                this.isSyncOnBoolean = false;
                Object constant = top.getConstant();
                if (this.syncSignature.equals("Ljava/lang/String;") && constant instanceof String) {
                    this.pendingBug = new BugInstance(this, "DL_SYNCHRONIZATION_ON_SHARED_CONSTANT", 2).addClassAndMethod(this);
                    String value = (String)constant;
                    if (!identified.matcher(value).matches()) break;
                    this.pendingBug.addString(value).describe("STRING_CONSTANT");
                    break;
                }
                if (!this.badSignatures.contains(this.syncSignature)) break;
                this.isSyncOnBoolean = this.syncSignature.equals("Ljava/lang/Boolean;");
                XField field = top.getXField();
                FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
                OpcodeStack.Item summary = fieldSummary.getSummary(field);
                int priority = 2;
                if (this.isSyncOnBoolean) {
                    --priority;
                }
                if (SynchronizationOnSharedBuiltinConstant.newlyConstructedObject(summary)) {
                    this.pendingBug = new BugInstance(this, "DL_SYNCHRONIZATION_ON_UNSHARED_BOXED_PRIMITIVE", 2).addClassAndMethod(this).addType(this.syncSignature).addOptionalField(field).addOptionalLocalVariable(this, top);
                    break;
                }
                if (this.isSyncOnBoolean) {
                    this.pendingBug = new BugInstance(this, "DL_SYNCHRONIZATION_ON_BOOLEAN", priority).addClassAndMethod(this).addOptionalField(field).addOptionalLocalVariable(this, top);
                    break;
                }
                this.pendingBug = new BugInstance(this, "DL_SYNCHRONIZATION_ON_BOXED_PRIMITIVE", priority).addClassAndMethod(this).addType(this.syncSignature).addOptionalField(field).addOptionalLocalVariable(this, top);
                break;
            }
            case 195: {
                this.accumulateBug();
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int priority;
                if (this.pendingBug == null || this.getClassConstantOperand().equals(ClassName.fromFieldSignature(this.syncSignature)) || this.getClassConstantOperand().startsWith("java/lang/String") || this.getClassConstantOperand().startsWith("java/util/logging")) break;
                int n = priority = this.isSyncOnBoolean ? 1 : 2;
                if (this.getClassConstantOperand().startsWith("java")) {
                    ++priority;
                }
                this.bugAccumulator.accumulateBug(new BugInstance(this, "TESTING", priority).addClassAndMethod(this).addString("Holding lock on shared object while calling method that might obtain other locks").addSourceLine(this, this.monitorEnterPC).describe("SOURCE_LINE_LOCK_OBTAINED_AT").addType(this.syncSignature).addCalledMethod(this), this);
            }
        }
    }

    private void accumulateBug() {
        if (this.pendingBug == null) {
            return;
        }
        this.bugAccumulator.accumulateBug(this.pendingBug, SourceLineAnnotation.fromVisitedInstruction(this, this.monitorEnterPC));
        this.pendingBug = null;
    }
}

