/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.TrainingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.type.FieldStoreType;
import edu.umd.cs.findbugs.ba.type.FieldStoreTypeDatabase;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class TrainFieldStoreTypes
implements Detector,
TrainingDetector {
    private BugReporter bugReporter;
    private FieldStoreTypeDatabase database;

    public TrainFieldStoreTypes(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.database = new FieldStoreTypeDatabase();
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        for (Method method : methodList = classContext.getJavaClass().getMethods()) {
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error compting field store types", e);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error compting field store types", e);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException, ClassNotFoundException {
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Type storeType;
            TypeFrame frame;
            XField xfield;
            FieldInstruction fins;
            Type fieldType;
            Location location = i.next();
            Instruction ins = location.getHandle().getInstruction();
            short opcode = ins.getOpcode();
            if (opcode != 181 && opcode != 179 || !((fieldType = (fins = (FieldInstruction)ins).getType(cpg)) instanceof ReferenceType) || (xfield = Hierarchy.findXField(fins, cpg)) == null || xfield.isPublic() || xfield.isProtected() || !(frame = (TypeFrame)typeDataflow.getFactAtLocation(location)).isValid() || !((storeType = (Type)frame.getTopValue()) instanceof ReferenceType)) continue;
            FieldStoreType property = (FieldStoreType)this.database.getProperty(xfield.getFieldDescriptor());
            if (property == null) {
                property = new FieldStoreType();
                this.database.setProperty(xfield.getFieldDescriptor(), property);
            }
            property.addTypeSignature(storeType.getSignature());
        }
    }

    public void report() {
        this.database.purgeBoringEntries();
        AnalysisContext.currentAnalysisContext().storePropertyDatabase(this.database, "fieldStoreTypes.db", "store type database");
    }
}

