/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class RankMatcher
implements Matcher {
    private int rank;

    public String toString() {
        return "Rank(rank=" + this.rank + ")";
    }

    public RankMatcher(String rankAsString) {
        this.rank = Integer.parseInt(rankAsString);
    }

    public int hashCode() {
        return this.rank;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RankMatcher)) {
            return false;
        }
        RankMatcher other = (RankMatcher)o;
        return this.rank == other.rank;
    }

    public boolean match(BugInstance bugInstance) {
        return BugRanker.findRank(bugInstance) >= this.rank;
    }

    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("value", Integer.toString(this.rank));
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("Rank", attributes);
    }
}

