/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.cloud.BugCollectionStorageCloud;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;

public class CommentsArea {
    private static final Logger LOGGER = Logger.getLogger(CommentsArea.class.getName());
    private JTextArea userCommentsText = new JTextArea();
    private JTextArea reportText = new JTextArea();
    private Color userCommentsTextUnenabledColor;
    private JComboBox designationComboBox;
    private ArrayList<String> designationKeys;
    private JButton fileBug;
    LinkedList<String> prevCommentsList = new LinkedList();
    private static final int prevCommentsMaxSize = 10;
    private JComboBox prevCommentsComboBox;
    private boolean dontShowAnnotationConfirmation = false;
    private boolean changed;
    final MainFrame frame;
    private Executor backgroundExecutor = Executors.newSingleThreadExecutor();
    private Cloud.BugFilingStatus currentBugStatus;
    int nonleafUpdateDepth = 0;

    CommentsArea(MainFrame frame) {
        this.frame = frame;
    }

    JPanel createCommentsInputPanel() {
        BugCollection bc = this.getMainFrame().bugCollection;
        Cloud cloud = bc == null ? null : bc.getCloud();
        JPanel centerPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        centerPanel.setLayout(layout);
        this.userCommentsText.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CommentsArea.this.setCommentsChanged(true);
                CommentsArea.this.changed = true;
            }

            public void removeUpdate(DocumentEvent e) {
                CommentsArea.this.setCommentsChanged(true);
                CommentsArea.this.changed = true;
            }

            public void changedUpdate(DocumentEvent e) {
                CommentsArea.this.changed = true;
            }
        });
        this.userCommentsTextUnenabledColor = centerPanel.getBackground();
        this.userCommentsText.setLineWrap(true);
        this.userCommentsText.setToolTipText(L10N.getLocalString("tooltip.enter_comments", "Enter your comments about this bug here"));
        this.userCommentsText.setWrapStyleWord(true);
        this.userCommentsText.setEnabled(false);
        this.userCommentsText.setBackground(this.userCommentsTextUnenabledColor);
        JScrollPane commentsScrollP = new JScrollPane(this.userCommentsText);
        this.reportText.setLineWrap(true);
        this.reportText.setToolTipText(L10N.getLocalString("tooltip.report", "Information about the bug here"));
        this.reportText.setWrapStyleWord(true);
        this.reportText.setEditable(false);
        JScrollPane reportScrollP = new JScrollPane(this.reportText);
        this.fileBug = new JButton(Cloud.BugFilingStatus.FILE_BUG.toString());
        this.fileBug.setEnabled(false);
        this.fileBug.setToolTipText("Click to file bug for this issue");
        this.fileBug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CommentsArea.this.frame.currentSelectedBugLeaf == null) {
                    return;
                }
                CommentsArea.this.saveComments();
                BugInstance bug = CommentsArea.this.frame.currentSelectedBugLeaf.getBug();
                Cloud cloud1 = ((CommentsArea)CommentsArea.this).getMainFrame().bugCollection.getCloud();
                if (!cloud1.supportsBugLinks()) {
                    return;
                }
                try {
                    URL u = cloud1.getBugLink(bug);
                    if (u != null && LaunchBrowser.showDocument(u)) {
                        cloud1.bugFiled(bug, null);
                        CommentsArea.this.getMainFrame().syncBugInformation();
                    }
                }
                catch (Exception e1) {
                    LOGGER.log(Level.SEVERE, "Could not view/file bug", e1);
                    JOptionPane.showMessageDialog(CommentsArea.this.getMainFrame(), "Could not view/file bug:\n" + e1.getClass().getSimpleName() + "\n" + e1.getMessage());
                }
            }
        });
        this.prevCommentsComboBox = new JComboBox();
        this.prevCommentsComboBox.setEnabled(false);
        this.prevCommentsComboBox.setToolTipText(L10N.getLocalString("tooltip.reuse_comments", "Use this to reuse a previous textual comment for this bug"));
        this.prevCommentsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && CommentsArea.this.prevCommentsComboBox.getSelectedIndex() != 0) {
                    CommentsArea.this.setCurrentUserCommentsText(CommentsArea.this.getCurrentPrevCommentsSelection());
                    CommentsArea.this.prevCommentsComboBox.setSelectedIndex(0);
                }
            }
        });
        this.designationComboBox = new JComboBox();
        this.designationKeys = new ArrayList();
        this.designationComboBox.setEnabled(false);
        this.designationComboBox.setToolTipText(L10N.getLocalString("tooltip.select_designation", "Select a user designation for this bug"));
        this.designationComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (CommentsArea.this.frame.userInputEnabled && e.getStateChange() == 1) {
                    if (CommentsArea.this.frame.currentSelectedBugLeaf == null) {
                        CommentsArea.this.setDesignationNonLeaf(CommentsArea.this.designationComboBox.getSelectedItem().toString());
                    } else if (!this.alreadySelected()) {
                        CommentsArea.this.setDesignation(CommentsArea.this.designationComboBox.getSelectedItem().toString());
                    }
                }
            }

            private boolean alreadySelected() {
                return ((String)CommentsArea.this.designationKeys.get(CommentsArea.this.designationComboBox.getSelectedIndex())).equals(CommentsArea.this.frame.currentSelectedBugLeaf.getBug().getUserDesignationKey());
            }
        });
        this.designationKeys.add("");
        this.designationComboBox.addItem("");
        for (String s : I18N.instance().getUserDesignationKeys(true)) {
            this.designationKeys.add(s);
            this.designationComboBox.addItem(Sortables.DESIGNATION.formatValue(s));
        }
        this.setUnknownDesignation();
        JPanel myStuffPanel = new JPanel(new GridBagLayout());
        myStuffPanel.setBorder(new TitledBorder("My Evaluation"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        myStuffPanel.add((Component)this.designationComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 2.0;
        c.gridwidth = 2;
        c.fill = 1;
        myStuffPanel.add((Component)commentsScrollP, c);
        centerPanel.add((Component)myStuffPanel, c);
        if (cloud != null && cloud.supportsCloudReports()) {
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            centerPanel.add((Component)reportScrollP, c);
        }
        if (cloud != null && cloud.supportsBugLinks()) {
            ++c.gridy;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.anchor = 13;
            centerPanel.add((Component)this.fileBug, c);
        }
        return centerPanel;
    }

    void setUnknownDesignation() {
        assert (this.designationComboBox.getItemCount() == this.designationKeys.size());
        this.designationComboBox.setSelectedIndex(0);
    }

    void setUserCommentInputEnable(final boolean isEnabled) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CommentsArea.this.setUserCommentInputEnableFromSwingThread(isEnabled);
            }
        });
    }

    void setUserCommentInputEnableFromSwingThread(boolean isEnabled) {
        this.frame.userInputEnabled = isEnabled;
        if (!isEnabled) {
            boolean b = this.frame.getProjectChanged();
            this.userCommentsText.setText("");
            this.setUnknownDesignation();
            this.userCommentsText.setBackground(this.userCommentsTextUnenabledColor);
            this.setCommentsChanged(b);
        } else {
            this.userCommentsText.setBackground(Color.WHITE);
        }
        this.userCommentsText.setEnabled(isEnabled);
        this.prevCommentsComboBox.setEnabled(isEnabled);
        this.designationComboBox.setEnabled(isEnabled);
    }

    void updateCommentsFromLeafInformation(final BugLeafNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean b = CommentsArea.this.frame.getProjectChanged();
                BugInstance bug = node.getBug();
                Cloud plugin = CommentsArea.this.getCloud();
                if (plugin.supportsBugLinks()) {
                    CommentsArea.this.currentBugStatus = plugin.getBugLinkStatus(bug);
                    CommentsArea.this.fileBug.setText(CommentsArea.this.currentBugStatus.toString());
                    CommentsArea.this.fileBug.setToolTipText(CommentsArea.this.currentBugStatus == Cloud.BugFilingStatus.FILE_BUG ? "Click to file bug for this issue" : "");
                    CommentsArea.this.fileBug.setEnabled(CommentsArea.this.currentBugStatus.linkEnabled());
                    CommentsArea.this.fileBug.setVisible(true);
                } else {
                    CommentsArea.this.fileBug.setVisible(false);
                }
                if (!plugin.canStoreUserAnnotation(bug)) {
                    CommentsArea.this.designationComboBox.setSelectedIndex(0);
                    CommentsArea.this.setCurrentUserCommentsText("");
                    CommentsArea.this.reportText.setText("Issue not persisted to database");
                    CommentsArea.this.setUserCommentInputEnableFromSwingThread(false);
                } else {
                    CommentsArea.this.setCurrentUserCommentsText(bug.getAnnotationText());
                    if (plugin.supportsCloudReports()) {
                        String report = plugin.getCloudReport(bug);
                        CommentsArea.this.reportText.setText(report);
                    }
                    CommentsArea.this.designationComboBox.setSelectedIndex(CommentsArea.this.designationKeys.indexOf(bug.getUserDesignationKey()));
                    CommentsArea.this.setUserCommentInputEnableFromSwingThread(plugin.canStoreUserAnnotation(bug));
                }
                CommentsArea.this.changed = false;
                CommentsArea.this.setCommentsChanged(b);
            }
        });
    }

    void updateCommentsFromNonLeafInformation(final BugAspects theAspects) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean b = CommentsArea.this.frame.getProjectChanged();
                CommentsArea.this.updateCommentsFromNonLeafInformationFromSwingThread(theAspects);
                CommentsArea.this.setUserCommentInputEnableFromSwingThread(true);
                CommentsArea.this.changed = false;
                CommentsArea.this.setCommentsChanged(b);
            }
        });
    }

    private void saveCommentsToBug(BugLeafNode node) {
        if (node == null) {
            return;
        }
        final String comments = this.getCurrentUserCommentsText();
        final BugInstance bug = node.getBug();
        if (bug.getAnnotationText().equals(comments)) {
            return;
        }
        this.backgroundExecutor.execute(new Runnable(){

            public void run() {
                bug.setAnnotationText(comments, MainFrame.getInstance().bugCollection);
                CommentsArea.this.setCommentsChanged(true);
                CommentsArea.this.changed = false;
                CommentsArea.this.addToPrevComments(comments);
            }
        });
    }

    private boolean confirmAnnotation() {
        Object[] options = new String[]{L10N.getLocalString("dlg.yes_btn", "Yes"), L10N.getLocalString("dlg.no_btn", "No"), L10N.getLocalString("dlg.yes_dont_ask_btn", "Yes, and don't ask me this again")};
        if (this.dontShowAnnotationConfirmation) {
            return true;
        }
        int choice = JOptionPane.showOptionDialog(this.frame, L10N.getLocalString("dlg.changing_text_lbl", "Changing this text box will overwrite the annotations associated with all bugs in this folder and subfolders. Are you sure?"), L10N.getLocalString("dlg.annotation_change_ttl", "Annotation Change"), -1, 3, null, options, options[0]);
        switch (choice) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                this.dontShowAnnotationConfirmation = true;
                return true;
            }
        }
        return true;
    }

    private void saveCommentsToNonLeaf(BugAspects aspects) {
        if (aspects == null) {
            return;
        }
        if (!this.changed) {
            return;
        }
        String newComment = this.getCurrentUserCommentsText();
        if (newComment.equals(this.getNonLeafCommentsText(aspects))) {
            return;
        }
        if (this.confirmAnnotation()) {
            BugSet filteredSet = aspects.getMatchingBugs(BugSet.getMainBugSet());
            for (BugLeafNode nextNode : filteredSet) {
                this.saveCommentsToBug(nextNode);
            }
        }
        this.changed = false;
    }

    public void saveComments() {
        this.saveComments(this.frame.currentSelectedBugLeaf, this.frame.currentSelectedBugAspects);
    }

    public void saveComments(BugLeafNode theNode, BugAspects theAspects) {
        if (theNode != null) {
            this.saveCommentsToBug(theNode);
        } else {
            this.saveCommentsToNonLeaf(theAspects);
        }
    }

    void loadPrevCommentsList(String[] list) {
        String[] temp;
        int count = 0;
        for (String str : list) {
            if (!str.equals("")) continue;
            ++count;
        }
        String[] ary = new String[list.length - count];
        int j = 0;
        for (String str : list) {
            if (str.equals("")) continue;
            ary[j] = str;
            ++j;
        }
        this.prevCommentsList = new LinkedList();
        if (ary.length > 10) {
            temp = new String[10];
            for (int i = 0; i < temp.length && i < ary.length; ++i) {
                temp[i] = ary[i];
            }
        } else {
            temp = new String[ary.length];
            System.arraycopy(ary, 0, temp, 0, ary.length);
        }
        this.prevCommentsList.addAll(Arrays.asList(temp));
        this.resetPrevCommentsComboBox();
    }

    private void addToPrevComments(String comment) {
        if (comment.equals("")) {
            return;
        }
        if (this.prevCommentsList.contains(comment)) {
            int index = this.prevCommentsList.indexOf(comment);
            if (index == 0) {
                return;
            }
            this.prevCommentsList.remove(index);
        }
        this.prevCommentsList.addFirst(comment);
        while (this.prevCommentsList.size() > 10) {
            this.prevCommentsList.removeLast();
        }
        this.resetPrevCommentsComboBox();
    }

    private void resetPrevCommentsComboBox() {
        this.prevCommentsComboBox.removeAllItems();
        this.prevCommentsComboBox.addItem("");
        for (String str : this.prevCommentsList) {
            if (str.length() < 20) {
                this.prevCommentsComboBox.addItem(str);
                continue;
            }
            this.prevCommentsComboBox.addItem(str.substring(0, 17) + "...");
        }
    }

    private String getCurrentUserCommentsText() {
        return this.userCommentsText.getText();
    }

    private void setCurrentUserCommentsText(String comment) {
        this.changed = true;
        this.userCommentsText.setText(comment);
    }

    private String getCurrentPrevCommentsSelection() {
        return this.prevCommentsList.get(this.prevCommentsComboBox.getSelectedIndex() - 1);
    }

    void addDesignationItem(JMenu menu, final String menuName, int keyEvent) {
        JMenuItem toggleItem = new JMenuItem(menuName);
        toggleItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (CommentsArea.this.frame.currentSelectedBugLeaf == null) {
                    CommentsArea.this.setDesignationNonLeaf(menuName);
                } else {
                    CommentsArea.this.setDesignation(menuName);
                }
            }
        });
        MainFrame.attachAcceleratorKey(toggleItem, keyEvent);
        menu.add(toggleItem);
    }

    void setDesignation(String designationName) {
        String claimedBy;
        Cloud plugin;
        if (this.frame.currentSelectedBugLeaf == null) {
            return;
        }
        String designationKey = this.convertDesignationNameToDesignationKey(designationName);
        if (designationKey == null) {
            return;
        }
        BugCollection bugCollection = MainFrame.getInstance().bugCollection;
        BugInstance bug = this.frame.currentSelectedBugLeaf.getBug();
        String oldValue = bug.getUserDesignationKey();
        if (designationKey.equals(oldValue)) {
            return;
        }
        Cloud cloud = plugin = bugCollection != null ? bugCollection.getCloud() : null;
        if (plugin != null && designationKey.equals("I_WILL_FIX") && plugin.supportsClaims() && (claimedBy = plugin.claimedBy(bug)) != null && !plugin.getUser().equals(claimedBy)) {
            int result = JOptionPane.showConfirmDialog(null, claimedBy + " has already said they will fix this issue\n" + "Do you want to also be listed as fixing this issue?\n" + "If so, please coordinate with " + claimedBy, "Issue already claimed", 1);
            if (result == 2) {
                return;
            }
            if (result != 0) {
                designationKey = "MUST_FIX";
            }
        }
        if (this.changeDesignationOfBug(this.frame.currentSelectedBugLeaf, designationKey)) {
            if (plugin != null && plugin.supportsCloudReports()) {
                String report = plugin.getCloudReport(bug);
                this.reportText.setText(report);
            }
            this.changed = true;
            this.setCommentsChanged(true);
        }
        this.setDesignationComboBox(designationKey);
    }

    protected void setDesignationNonLeaf(String designationName) {
        if (this.nonleafUpdateDepth > 0) {
            return;
        }
        String designationKey = this.convertDesignationNameToDesignationKey(designationName);
        if (designationKey == null || this.frame.currentSelectedBugAspects == null) {
            return;
        }
        Cloud cloud = this.getMainFrame().bugCollection.getCloud();
        if (cloud.getMode() == Cloud.Mode.VOTING) {
            JOptionPane.showMessageDialog(this.frame, "FindBugs is configured in voting mode; no mass updates allowed");
            return;
        }
        BugSet filteredSet = this.frame.currentSelectedBugAspects.getMatchingBugs(BugSet.getMainBugSet());
        for (BugLeafNode nextNode : filteredSet) {
            if (!this.changeDesignationOfBug(nextNode, designationKey)) continue;
            this.changed = true;
            this.setCommentsChanged(true);
        }
        this.setDesignationComboBox(designationKey);
    }

    protected boolean changeDesignationOfBug(BugLeafNode theNode, final String selection) {
        this.saveComments();
        final BugInstance bug = theNode.getBug();
        String oldValue = bug.getUserDesignationKey();
        if (selection.equals(oldValue)) {
            return false;
        }
        this.backgroundExecutor.execute(new Runnable(){

            public void run() {
                bug.setUserDesignationKey(selection, MainFrame.getInstance().bugCollection);
            }
        });
        return true;
    }

    protected void updateDesignationComboBox() {
        if (this.frame.currentSelectedBugLeaf == null) {
            this.updateCommentsFromNonLeafInformationFromSwingThread(this.frame.currentSelectedBugAspects);
        } else {
            BugInstance bug;
            Cloud cloud = this.getMainFrame().bugCollection.getCloud();
            if (!cloud.canStoreUserAnnotation(bug = this.frame.currentSelectedBugLeaf.getBug())) {
                this.designationComboBox.setEnabled(false);
                this.designationComboBox.setSelectedIndex(0);
                return;
            }
            this.designationComboBox.setEnabled(true);
            int selectedIndex = this.designationComboBox.getSelectedIndex();
            if (selectedIndex >= 0) {
                this.setDesignationComboBox(this.designationKeys.get(selectedIndex));
            } else {
                Debug.println("Couldn't find selected index in designationComboBox: " + this.designationComboBox.getSelectedItem());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCommentsFromNonLeafInformationFromSwingThread(BugAspects theAspects) {
        if (theAspects == null) {
            return;
        }
        BugSet filteredSet = theAspects.getMatchingBugs(BugSet.getMainBugSet());
        boolean allSame = true;
        int first = -1;
        for (BugLeafNode nextNode : filteredSet) {
            int designationIndex = this.designationKeys.indexOf(nextNode.getBug().getUserDesignationKey());
            if (first == -1) {
                first = designationIndex;
                continue;
            }
            if (designationIndex == first) continue;
            allSame = false;
        }
        ++this.nonleafUpdateDepth;
        try {
            if (allSame) {
                this.designationComboBox.setSelectedIndex(first);
            } else {
                this.designationComboBox.setSelectedIndex(0);
            }
            this.userCommentsText.setText(this.getNonLeafCommentsText(theAspects));
            Cloud cloud = this.getCloud();
            if (cloud != null && cloud.getMode() == Cloud.Mode.VOTING) {
                this.userCommentsText.setEnabled(false);
            }
            this.fileBug.setEnabled(false);
            this.changed = false;
        }
        finally {
            --this.nonleafUpdateDepth;
        }
    }

    protected String getNonLeafCommentsText(BugAspects theAspects) {
        if (theAspects == null) {
            return "";
        }
        BugSet filteredSet = theAspects.getMatchingBugs(BugSet.getMainBugSet());
        boolean allSame = true;
        String comments = null;
        for (BugLeafNode nextNode : filteredSet) {
            String commentsOnThisBug = nextNode.getBug().getAnnotationText();
            if (comments == null) {
                comments = commentsOnThisBug;
                continue;
            }
            if (commentsOnThisBug.equals(comments)) continue;
            allSame = false;
        }
        if (comments == null || !allSame) {
            return "";
        }
        return comments;
    }

    protected void setDesignationComboBox(String designationKey) {
        assert (this.designationComboBox.getItemCount() == this.designationKeys.size());
        int numItems = this.designationComboBox.getItemCount();
        for (int i = 0; i < numItems; ++i) {
            String value = this.designationKeys.get(i);
            if (!designationKey.equals(value)) continue;
            this.designationComboBox.setSelectedIndex(i);
            return;
        }
        if (MainFrame.DEBUG) {
            System.out.println("Couldn't find combo box for " + designationKey);
        }
    }

    public void moveNodeAccordingToDesignation(BugLeafNode theNode, String selection) {
        if (!this.getSorter().getOrder().contains(Sortables.DESIGNATION)) {
            theNode.getBug().setUserDesignationKey(selection, MainFrame.getInstance().bugCollection);
        } else if (this.getSorter().getOrderBeforeDivider().contains(Sortables.DESIGNATION)) {
            BugTreeModel model = this.getModel();
            TreePath path = model.getPathToBug(theNode.getBug());
            if (path == null) {
                theNode.getBug().setUserDesignationKey(selection, MainFrame.getInstance().bugCollection);
                return;
            }
            Object[] objPath = path.getParentPath().getPath();
            ArrayList<Object> reconstruct = new ArrayList<Object>();
            ArrayList<TreePath> listOfNodesToReconstruct = new ArrayList<TreePath>();
            for (Object o : objPath) {
                reconstruct.add(o);
                if (o instanceof BugAspects && ((BugAspects)o).getCount() == 1) break;
                TreePath pathToNode = new TreePath(reconstruct.toArray());
                listOfNodesToReconstruct.add(pathToNode);
            }
            theNode.getBug().setUserDesignationKey(selection, MainFrame.getInstance().bugCollection);
            model.bugTreeFilterListener.suppressBug(path);
            TreePath unsuppressPath = model.getPathToBug(theNode.getBug());
            if (unsuppressPath != null) {
                model.bugTreeFilterListener.unsuppressBug(unsuppressPath);
            }
            for (TreePath pathToNode : listOfNodesToReconstruct) {
                model.treeNodeChanged(pathToNode);
            }
            this.setCommentsChanged(true);
        } else if (this.getSorter().getOrderAfterDivider().contains(Sortables.DESIGNATION)) {
            theNode.getBug().setUserDesignationKey(selection, MainFrame.getInstance().bugCollection);
            BugTreeModel model = this.getModel();
            TreePath path = model.getPathToBug(theNode.getBug());
            if (path != null) {
                model.sortBranch(path.getParentPath());
            }
        }
    }

    @CheckForNull
    protected String convertDesignationNameToDesignationKey(String name) {
        assert (this.designationComboBox.getItemCount() == this.designationKeys.size());
        int itemCount = this.designationComboBox.getItemCount();
        for (int i = 1; i < itemCount; ++i) {
            if (!name.equals(this.designationComboBox.getItemAt(i))) continue;
            return this.designationKeys.get(i);
        }
        return null;
    }

    private void setCommentsChanged(boolean b) {
        Cloud cloud = this.getCloud();
        if (cloud == null || cloud instanceof BugCollectionStorageCloud) {
            this.frame.setProjectChanged(b);
        }
    }

    SorterTableColumnModel getSorter() {
        return this.frame.getSorter();
    }

    public void resized() {
        this.resetPrevCommentsComboBox();
        this.userCommentsText.validate();
    }

    BugTreeModel getModel() {
        return (BugTreeModel)this.frame.tree.getModel();
    }

    public boolean hasFocus() {
        return this.userCommentsText.hasFocus();
    }

    @CheckForNull
    private Cloud getCloud() {
        MainFrame instance = MainFrame.getInstance();
        BugCollection bugCollection = instance.bugCollection;
        if (bugCollection == null) {
            return null;
        }
        return bugCollection.getCloud();
    }

    private MainFrame getMainFrame() {
        return MainFrame.getInstance();
    }

    public void configureForCurrentCloud() {
        Cloud cloud = this.getCloud();
        if (this.fileBug != null) {
            this.fileBug.setEnabled(cloud.supportsBugLinks());
        }
        MainFrame.getInstance().resetCommentsInputPane();
    }
}

