/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.StartTime;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.FindBugsLayoutManagerFactory;
import edu.umd.cs.findbugs.gui2.GUI2CommandLine;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.SaveType;
import edu.umd.cs.findbugs.gui2.SplashFrame;
import edu.umd.cs.findbugs.gui2.SplitLayout;
import java.io.File;
import java.util.Locale;

public class Driver {
    private static long START_TIME = StartTime.START_TIME;
    private static final String USAGE = Driver.class.getName() + " [options] [project or analysis results file]";
    private static GUI2CommandLine commandLine = new GUI2CommandLine();
    private static SplashFrame splash;

    public static void main(String[] args) throws Exception {
        if (SystemProperties.getProperty("os.name").startsWith("Mac")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "FindBugs");
            Debug.println("Mac OS detected");
        }
        splash = new SplashFrame();
        splash.setVisible(true);
        int numParsed = commandLine.parse(args, 0, 1, USAGE);
        if (numParsed < args.length) {
            String arg = args[numParsed];
            String argLowerCase = arg.toLowerCase(Locale.ENGLISH);
            if (argLowerCase.endsWith(".fbp") || argLowerCase.endsWith(".fb")) {
                commandLine.loadProject(arg);
            } else if (argLowerCase.endsWith(".xml") || argLowerCase.endsWith(".xml.gz") || argLowerCase.endsWith(".fba")) {
                commandLine.setSaveFile(new File(arg));
            } else {
                System.out.println("Unknown argument: " + arg);
                commandLine.printUsage(System.out);
                System.exit(1);
            }
        }
        if (commandLine.getDocking()) {
            try {
                Class.forName("net.infonode.docking.DockingWindow");
                Class.forName("edu.umd.cs.findbugs.gui2.DockLayout");
            }
            catch (Exception e) {
                commandLine.setDocking(false);
            }
        }
        try {
            GUISaveState.loadInstance();
        }
        catch (RuntimeException e) {
            GUISaveState.clear();
            e.printStackTrace();
        }
        if (commandLine.isFontSizeSpecified()) {
            GUISaveState.getInstance().setFontSize(commandLine.getFontSize());
        }
        DetectorFactoryCollection.instance();
        FindBugsLayoutManagerFactory factory = Driver.isDocking() ? new FindBugsLayoutManagerFactory("edu.umd.cs.findbugs.gui2.DockLayout") : new FindBugsLayoutManagerFactory(SplitLayout.class.getName());
        MainFrame.makeInstance(factory);
        splash.setVisible(false);
        splash.dispose();
    }

    public static void removeSplashScreen() {
        if (splash == null) {
            return;
        }
        splash.setVisible(false);
        splash.dispose();
        if (commandLine.getSaveFile() != null) {
            MainFrame.getInstance().openAnalysis(commandLine.getSaveFile(), SaveType.XML_ANALYSIS);
        } else if (commandLine.isProjectLoadedFromFile()) {
            MainFrame.getInstance().setProject(commandLine.getProject());
            MainFrame.getInstance().newProject();
            MainFrame.getInstance().redoAnalysis();
        }
    }

    public static boolean isDocking() {
        return commandLine.getDocking();
    }

    public static float getFontSize() {
        return commandLine.getFontSize();
    }

    public static int getPriority() {
        return commandLine.getPriority();
    }

    public static AnalysisFeatureSetting[] getAnalysisSettingList() {
        return commandLine.getSettingList();
    }
}

