/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsDisplayFeatures;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectPackagePrefixes;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.LastVersionMatcher;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.AboutDialog;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.BugLoader;
import edu.umd.cs.findbugs.gui2.BugRenderer;
import edu.umd.cs.findbugs.gui2.BugSaver;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.CommentsArea;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.DisplayNonmodelMessage;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBFileChooser;
import edu.umd.cs.findbugs.gui2.FBFrame;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.FindBugsAnalysisFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFBAFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFBPFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFilterFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsLayoutManager;
import edu.umd.cs.findbugs.gui2.FindBugsLayoutManagerFactory;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.NewFilterFromBug;
import edu.umd.cs.findbugs.gui2.NewProjectWizard;
import edu.umd.cs.findbugs.gui2.PreferencesFrame;
import edu.umd.cs.findbugs.gui2.ProjectSettings;
import edu.umd.cs.findbugs.gui2.RecentMenu;
import edu.umd.cs.findbugs.gui2.SaveType;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterDialog;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import edu.umd.cs.findbugs.gui2.SourceCodeDisplay;
import edu.umd.cs.findbugs.gui2.SwingThread;
import edu.umd.cs.findbugs.gui2.ViewFilter;
import edu.umd.cs.findbugs.log.ConsoleLogger;
import edu.umd.cs.findbugs.log.LogSync;
import edu.umd.cs.findbugs.log.Logger;
import edu.umd.cs.findbugs.sourceViewer.NavigableTextPane;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import edu.umd.cs.findbugs.util.Multiset;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends FBFrame
implements LogSync,
IGuiCallback {
    private AbstractExecutorService bugUpdateExecutor = new EventQueueExecutor();
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(MainFrame.class.getName());
    JTree tree;
    private BasicTreeUI treeUI;
    boolean userInputEnabled;
    static final String DEFAULT_SOURCE_CODE_MSG = L10N.getLocalString("msg.nosource_txt", "No available source");
    static final int COMMENTS_TAB_STRUT_SIZE = 5;
    static final int COMMENTS_MARGIN = 5;
    static final int SEARCH_TEXT_FIELD_SIZE = 32;
    static final String TITLE_START_TXT = "FindBugs: ";
    private JTextField sourceSearchTextField = new JTextField(32);
    private JButton findButton = MainFrame.newButton("button.find", "First");
    private JButton findNextButton = MainFrame.newButton("button.findNext", "Next");
    private JButton findPreviousButton = MainFrame.newButton("button.findPrev", "Previous");
    public static final boolean DEBUG = SystemProperties.getBoolean("gui2.debug");
    static final boolean MAC_OS_X = SystemProperties.getProperty("os.name").toLowerCase().startsWith("mac os x");
    static final String WINDOW_MODIFIED = "windowModified";
    NavigableTextPane sourceCodeTextPane = new NavigableTextPane();
    private JScrollPane sourceCodeScrollPane;
    final CommentsArea comments;
    private SorterTableColumnModel sorter;
    private JTableHeader tableheader;
    private JLabel statusBarLabel = new JLabel();
    private JLabel signedInLabel;
    private ImageIcon signedInIcon;
    private ImageIcon warningIcon;
    private JPanel summaryTopPanel;
    private final HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
    private final JEditorPane summaryHtmlArea = new JEditorPane();
    private JScrollPane summaryHtmlScrollPane = new JScrollPane(this.summaryHtmlArea);
    private final FindBugsLayoutManagerFactory findBugsLayoutManagerFactory;
    private final FindBugsLayoutManager guiLayout;
    boolean projectChanged = false;
    private final JMenuItem reconfigMenuItem = MainFrame.newJMenuItem("menu.reconfig", "Reconfigure...", 70);
    private JMenuItem redoAnalysis;
    BugLeafNode currentSelectedBugLeaf;
    BugAspects currentSelectedBugAspects;
    private JPopupMenu bugPopupMenu;
    private JPopupMenu branchPopupMenu;
    private static MainFrame instance;
    private RecentMenu recentMenuCache;
    private JMenu recentMenu;
    private JMenuItem preferencesMenuItem;
    private Project curProject = new Project();
    private JScrollPane treeScrollPane;
    private JPanel treePanel;
    private Object lock = new Object();
    private boolean newProject = false;
    final ProjectPackagePrefixes projectPackagePrefixes = new ProjectPackagePrefixes();
    final CountDownLatch mainFrameInitialized = new CountDownLatch(1);
    private Class<?> osxAdapter;
    private Method osxPrefsEnableMethod;
    private Logger logger = new ConsoleLogger(this);
    SourceCodeDisplay displayer = new SourceCodeDisplay(this);
    private SaveType saveType = SaveType.NOT_KNOWN;
    FBFileChooser saveOpenFileChooser;
    FBFileChooser filterOpenFileChooser;
    @CheckForNull
    private File saveFile = null;
    JMenuItem saveMenuItem = MainFrame.newJMenuItem("menu.save_item", "Save", 83);
    BugCollection bugCollection;
    Cloud.CloudListener userAnnotationListener = new Cloud.CloudListener(){

        public void issueUpdated(BugInstance bug) {
            if (MainFrame.this.currentSelectedBugLeaf != null && MainFrame.this.currentSelectedBugLeaf.getBug() == bug) {
                MainFrame.this.comments.updateCommentsFromLeafInformation(MainFrame.this.currentSelectedBugLeaf);
            }
        }

        public void statusUpdated() {
            SwingUtilities.invokeLater(MainFrame.this.updateStatusBarRunner);
        }
    };
    private Cloud.CloudStatusListener cloudStatusListener = new Cloud.CloudStatusListener(){

        public void handleIssueDataDownloadedEvent() {
            MainFrame.this.rebuildBugTreeIfSortablesDependOnCloud();
        }

        public void handleStateChange(Cloud.SigninState oldState, Cloud.SigninState state) {
            MainFrame.this.rebuildBugTreeIfSortablesDependOnCloud();
        }
    };
    final Runnable updateStatusBarRunner = new Runnable(){

        public void run() {
            MainFrame.this.updateStatusBar();
        }
    };
    JMenu viewMenu;
    ViewFilter viewFilter = new ViewFilter(this);
    int waitCount = 0;
    final Object waitLock = new Object();
    JPanel waitPanel;
    JPanel cardPanel;
    JTextField textFieldForPackagesToDisplay;
    volatile String errorMsg = "";
    URL sourceLink;
    boolean listenerAdded = false;
    private JLabel waitStatusLabel;

    static JButton newButton(String key, String name) {
        JButton b = new JButton();
        L10N.localiseButton(b, key, name, false);
        return b;
    }

    static JMenuItem newJMenuItem(String key, String string, int vkF) {
        JMenuItem m = new JMenuItem();
        L10N.localiseButton(m, key, string, false);
        m.setMnemonic(vkF);
        return m;
    }

    static JMenuItem newJMenuItem(String key, String string) {
        JMenuItem m = new JMenuItem();
        L10N.localiseButton(m, key, string, true);
        return m;
    }

    static JMenu newJMenu(String key, String string) {
        JMenu m = new JMenu();
        L10N.localiseButton(m, key, string, true);
        return m;
    }

    static boolean isMacLookAndFeel() {
        return UIManager.getLookAndFeel().getClass().getName().startsWith("apple");
    }

    public static void makeInstance(FindBugsLayoutManagerFactory factory) {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = new MainFrame(factory);
        instance.initializeGUI();
    }

    public static MainFrame getInstance() {
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    public static boolean isAvailable() {
        return instance != null;
    }

    private void initializeGUI() {
        SwingUtilities.invokeLater(new InitializeGUI());
    }

    private MainFrame(FindBugsLayoutManagerFactory factory) {
        this.findBugsLayoutManagerFactory = factory;
        this.guiLayout = factory.getInstance(this);
        this.comments = new CommentsArea(this);
        FindBugsDisplayFeatures.setAbridgedMessages(true);
    }

    void about() {
        AboutDialog dialog = new AboutDialog(this, this.logger, true);
        dialog.setSize(600, 554);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    void preferences() {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        PreferencesFrame.getInstance().setLocationRelativeTo(this);
        PreferencesFrame.getInstance().setVisible(true);
    }

    void enablePreferences(boolean b) {
        this.preferencesMenuItem.setEnabled(b);
        if (MAC_OS_X && this.osxPrefsEnableMethod != null) {
            Object[] args = new Object[]{b};
            try {
                this.osxPrefsEnableMethod.invoke(this.osxAdapter, args);
            }
            catch (Exception e) {
                System.err.println("Exception while enabling Preferences menu: " + e);
            }
        }
    }

    void callOnClose() {
        Cloud cloud;
        this.comments.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        if (this.projectChanged && !SystemProperties.getBoolean("findbugs.skipSaveChangesWarning")) {
            int value = JOptionPane.showConfirmDialog(this, this.getActionWithoutSavingMsg("closing"), L10N.getLocalString("msg.confirm_save_txt", "Do you want to save?"), 1, 3);
            if (value == 2 || value == -1) {
                return;
            }
            if (value == 0) {
                if (this.saveFile == null) {
                    if (!this.saveAs()) {
                        return;
                    }
                } else {
                    this.save();
                }
            }
        }
        GUISaveState.getInstance().setPreviousComments(this.comments.prevCommentsList);
        this.guiLayout.saveState();
        GUISaveState.getInstance().setFrameBounds(this.getBounds());
        GUISaveState.getInstance().save();
        if (this.bugCollection != null && (cloud = this.bugCollection.getCloud()) != null) {
            cloud.shutdown();
        }
        System.exit(0);
    }

    private String getActionWithoutSavingMsg(String action) {
        String msg = L10N.getLocalString("msg.you_are_" + action + "_without_saving_txt", null);
        if (msg != null) {
            return msg;
        }
        return L10N.getLocalString("msg.you_are_" + action + "_txt", "You are " + action) + " " + L10N.getLocalString("msg.without_saving_txt", "without saving. Do you want to save?");
    }

    JMenuItem createRecentItem(final File f, final SaveType localSaveType) {
        if (DEBUG) {
            System.out.println("createRecentItem(" + f + ", " + (Object)((Object)localSaveType) + ")");
        }
        String name = f.getName();
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    MainFrame.this.setCursor(new Cursor(3));
                    if (!f.exists()) {
                        JOptionPane.showMessageDialog(null, L10N.getLocalString("msg.proj_not_found", "This project can no longer be found"));
                        GUISaveState.getInstance().fileNotFound(f);
                        return;
                    }
                    GUISaveState.getInstance().fileReused(f);
                    MainFrame.this.recentMenuCache.addRecentFile(f);
                    if (!f.exists()) {
                        throw new IllegalStateException("User used a recent projects menu item that didn't exist.");
                    }
                    if (MainFrame.this.curProject != null && MainFrame.this.projectChanged) {
                        int response = JOptionPane.showConfirmDialog(MainFrame.this, L10N.getLocalString("dlg.save_current_changes", "The current project has been changed, Save current changes?"), L10N.getLocalString("dlg.save_changes", "Save Changes?"), 1, 2);
                        if (response == 0) {
                            if (MainFrame.this.saveFile != null) {
                                MainFrame.this.save();
                            } else {
                                MainFrame.this.saveAs();
                            }
                        } else if (response == 2) {
                            return;
                        }
                    }
                    SaveType st = SaveType.forFile(f);
                    boolean result = true;
                    switch (st) {
                        case XML_ANALYSIS: {
                            result = MainFrame.this.openAnalysis(f, st);
                            break;
                        }
                        case FBP_FILE: {
                            result = MainFrame.this.openFBPFile(f);
                            break;
                        }
                        case FBA_FILE: {
                            result = MainFrame.this.openFBAFile(f);
                            break;
                        }
                        default: {
                            MainFrame.this.error("Wrong file type in recent menu item.");
                        }
                    }
                    if (!result) {
                        JOptionPane.showMessageDialog(MainFrame.getInstance(), "There was an error in opening the file", "Recent Menu Opening Error", 2);
                    }
                }
                finally {
                    MainFrame.this.setCursor(new Cursor(0));
                    MainFrame.this.setSaveType(localSaveType);
                }
            }
        });
        item.setFont(item.getFont().deriveFont(Driver.getFontSize()));
        return item;
    }

    @Override
    public void registerCloud(Project project, BugCollection collection, Cloud plugin) {
        assert (collection.getCloud() == plugin);
        if (this.bugCollection == collection) {
            plugin.addListener(this.userAnnotationListener);
            plugin.addStatusListener(this.cloudStatusListener);
        }
    }

    @Override
    public void unregisterCloud(Project project, BugCollection collection, Cloud plugin) {
        assert (collection.getCloud() == plugin);
        if (this.bugCollection == collection) {
            plugin.removeListener(this.userAnnotationListener);
            plugin.removeStatusListener(this.cloudStatusListener);
        }
    }

    private void rebuildBugTreeIfSortablesDependOnCloud() {
        BugTreeModel bt = (BugTreeModel)this.getTree().getModel();
        List<Sortables> sortables = this.sorter.getOrderBeforeDivider();
        if (sortables.contains(Sortables.DESIGNATION) || sortables.contains(Sortables.FIRST_SEEN) || sortables.contains(Sortables.FIRSTVERSION) || sortables.contains(Sortables.LASTVERSION)) {
            bt.rebuild();
        }
    }

    @Override
    public ExecutorService getBugUpdateExecutor() {
        return this.bugUpdateExecutor;
    }

    @SwingThread
    void setProjectWithNoBugCollection(Project project) {
        this.setProjectAndBugCollection(project, null);
    }

    @SwingThread
    void setBugCollection(BugCollection bugCollection) {
        this.setProjectAndBugCollection(bugCollection.getProject(), bugCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SwingThread
    private void setProjectAndBugCollection(@CheckForNull Project project, @CheckForNull BugCollection bugCollection) {
        if (DEBUG) {
            if (bugCollection == null) {
                System.out.println("Setting bug collection to null");
            } else {
                System.out.println("Setting bug collection; contains " + bugCollection.getCollection().size() + " bugs");
            }
        }
        this.acquireDisplayWait();
        try {
            Cloud plugin;
            Filter suppressionMatcher;
            if (project != null && (suppressionMatcher = project.getSuppressionFilter()) != null) {
                suppressionMatcher.softAdd(LastVersionMatcher.DEAD_BUG_MATCHER);
            }
            if (this.bugCollection != bugCollection && this.bugCollection != null && (plugin = this.bugCollection.getCloud()) != null) {
                plugin.removeListener(this.userAnnotationListener);
                plugin.removeStatusListener(this.cloudStatusListener);
                plugin.shutdown();
            }
            if (bugCollection != null) {
                this.setProject(project);
                this.bugCollection = bugCollection;
                this.displayer.clearCache();
                plugin = bugCollection.getCloud();
                if (plugin != null) {
                    plugin.addListener(this.userAnnotationListener);
                    plugin.addStatusListener(this.cloudStatusListener);
                }
                this.updateBugTree();
            }
            this.setProjectChanged(false);
            Runnable runnable = new Runnable(){

                public void run() {
                    PreferencesFrame.getInstance().updateFilterPanel();
                    MainFrame.this.reconfigMenuItem.setEnabled(true);
                    MainFrame.this.comments.configureForCurrentCloud();
                    MainFrame.this.setViewMenu();
                    MainFrame.this.newProject();
                    MainFrame.this.clearSourcePane();
                    MainFrame.this.clearSummaryTab();
                    MainFrame.this.changeTitle();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        finally {
            this.releaseDisplayWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBugTree() {
        this.acquireDisplayWait();
        try {
            BugTreeModel model = (BugTreeModel)this.getTree().getModel();
            if (this.bugCollection != null) {
                BugSet bs = new BugSet(this.bugCollection);
                model.getOffListenerList();
                model.changeSet(bs);
                if (bs.size() == 0 && bs.sizeUnfiltered() > 0) {
                    this.warnUserOfFilters();
                }
            }
            this.updateStatusBar();
            this.changeTitle();
        }
        finally {
            this.releaseDisplayWait();
        }
    }

    void resetViewCache() {
        ((BugTreeModel)this.getTree().getModel()).clearViewCache();
    }

    void updateProjectAndBugCollection(Project project, BugCollection bugCollection, BugTreeModel previousModel) {
        if (bugCollection != null) {
            this.displayer.clearCache();
            BugSet bs = new BugSet(bugCollection);
            BugTreeModel model = (BugTreeModel)this.tree.getModel();
            model.getOffListenerList();
            model.changeSet(bs);
            this.setProjectChanged(true);
        }
        this.setCursor(new Cursor(0));
    }

    public void changeTitle() {
        String newTitle;
        String oldTitle;
        String name;
        Project project = this.getProject();
        String string = name = project == null ? null : project.getProjectName();
        if (name == null && this.saveFile != null) {
            name = this.saveFile.getAbsolutePath();
        }
        if (name == null) {
            name = "<<unnamed project>>";
        }
        if ((oldTitle = this.getTitle()).equals(newTitle = TITLE_START_TXT + name)) {
            return;
        }
        this.setTitle(newTitle);
    }

    private JPopupMenu createBugPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem filterMenuItem = MainFrame.newJMenuItem("menu.filterBugsLikeThis", "Filter bugs like this");
        filterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveComments(MainFrame.this.currentSelectedBugLeaf, MainFrame.this.currentSelectedBugAspects);
                new NewFilterFromBug(MainFrame.this.currentSelectedBugLeaf.getBug());
                MainFrame.this.setProjectChanged(true);
                MainFrame.getInstance().getTree().setSelectionRow(0);
            }
        });
        popupMenu.add(filterMenuItem);
        JMenu changeDesignationMenu = MainFrame.newJMenu("menu.changeDesignation", "Change bug designation");
        int i = 0;
        int[] keyEvents = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
        for (String key : I18N.instance().getUserDesignationKeys(true)) {
            String name = I18N.instance().getUserDesignation(key);
            this.comments.addDesignationItem(changeDesignationMenu, name, keyEvents[i++]);
        }
        popupMenu.add(changeDesignationMenu);
        return popupMenu;
    }

    boolean shouldDisplayIssueIgnoringPackagePrefixes(BugInstance b) {
        Project project = this.getProject();
        Filter suppressionFilter = project.getSuppressionFilter();
        if (null == this.bugCollection || suppressionFilter.match(b)) {
            return false;
        }
        return this.viewFilter.showIgnoringPackagePrefixes(b);
    }

    boolean shouldDisplayIssue(BugInstance b) {
        Project project = this.getProject();
        Filter suppressionFilter = project.getSuppressionFilter();
        if (null == this.bugCollection || suppressionFilter.match(b)) {
            return false;
        }
        return this.viewFilter.show(b);
    }

    private JPopupMenu createBranchPopUpMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem filterMenuItem = MainFrame.newJMenuItem("menu.filterTheseBugs", "Filter these bugs");
        filterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreePath path;
                    MainFrame.this.saveComments(MainFrame.this.currentSelectedBugLeaf, MainFrame.this.currentSelectedBugAspects);
                    TreePath deletePath = path = MainFrame.getInstance().getTree().getSelectionPath();
                    int startCount = ((BugAspects)path.getLastPathComponent()).getCount();
                    int count = ((BugAspects)path.getParentPath().getLastPathComponent()).getCount();
                    while (count == startCount) {
                        if ((deletePath = deletePath.getParentPath()).getParentPath() == null) {
                            Matcher m = MainFrame.this.currentSelectedBugAspects.getMatcher();
                            Filter suppressionFilter = MainFrame.getInstance().getProject().getSuppressionFilter();
                            suppressionFilter.addChild(m);
                            PreferencesFrame.getInstance().updateFilterPanel();
                            FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
                            return;
                        }
                        count = ((BugAspects)deletePath.getParentPath().getLastPathComponent()).getCount();
                    }
                    BugTreeModel model = MainFrame.getInstance().getBugTreeModel();
                    TreeModelEvent event = new TreeModelEvent((Object)this, deletePath.getParentPath(), new int[]{model.getIndexOfChild(deletePath.getParentPath().getLastPathComponent(), deletePath.getLastPathComponent())}, new Object[]{deletePath.getLastPathComponent()});
                    Matcher m = MainFrame.this.currentSelectedBugAspects.getMatcher();
                    Filter suppressionFilter = MainFrame.getInstance().getProject().getSuppressionFilter();
                    suppressionFilter.addChild(m);
                    PreferencesFrame.getInstance().updateFilterPanel();
                    model.sendEvent(event, BugTreeModel.TreeModification.REMOVE);
                    MainFrame.this.setProjectChanged(true);
                    MainFrame.getInstance().getTree().setSelectionRow(0);
                }
                catch (RuntimeException e) {
                    MainFrame.getInstance().showMessageDialog("Unable to create filter: " + e.getMessage());
                }
            }
        });
        popupMenu.add(filterMenuItem);
        JMenu changeDesignationMenu = MainFrame.newJMenu("menu.changeDesignation", "Change bug designation");
        int i = 0;
        int[] keyEvents = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
        for (String key : I18N.instance().getUserDesignationKeys(true)) {
            String name = I18N.instance().getUserDesignation(key);
            this.addDesignationItem(changeDesignationMenu, name, keyEvents[i++]);
        }
        popupMenu.add(changeDesignationMenu);
        return popupMenu;
    }

    protected JMenuBar createMainMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = MainFrame.newJMenu("menu.file_menu", "File");
        fileMenu.setMnemonic(70);
        JMenu editMenu = MainFrame.newJMenu("menu.edit_menu", "Edit");
        editMenu.setMnemonic(69);
        JMenuItem openMenuItem = MainFrame.newJMenuItem("menu.open_item", "Open...", 79);
        this.recentMenu = MainFrame.newJMenu("menu.recent", "Recent");
        this.recentMenuCache = new RecentMenu(this.recentMenu);
        JMenuItem saveAsMenuItem = MainFrame.newJMenuItem("menu.saveas_item", "Save As...", 65);
        JMenuItem importFilter = MainFrame.newJMenuItem("menu.importFilter_item", "Import filter...");
        JMenuItem exportFilter = MainFrame.newJMenuItem("menu.exportFilter_item", "Export filter...");
        JMenuItem exitMenuItem = null;
        if (!MAC_OS_X) {
            exitMenuItem = MainFrame.newJMenuItem("menu.exit", "Exit", 88);
            exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainFrame.this.callOnClose();
                }
            });
        }
        JMenu windowMenu = this.guiLayout.createWindowMenu();
        JMenuItem newProjectMenuItem = null;
        if (!FindBugs.noAnalysis) {
            newProjectMenuItem = MainFrame.newJMenuItem("menu.new_item", "New Project", 78);
            MainFrame.attachAcceleratorKey(newProjectMenuItem, 78);
            newProjectMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainFrame.this.newProjectMenu();
                }
            });
        }
        this.reconfigMenuItem.setEnabled(false);
        MainFrame.attachAcceleratorKey(this.reconfigMenuItem, 70);
        this.reconfigMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveComments(MainFrame.this.currentSelectedBugLeaf, MainFrame.this.currentSelectedBugAspects);
                new NewProjectWizard(MainFrame.this.curProject);
            }
        });
        JMenuItem mergeMenuItem = MainFrame.newJMenuItem("menu.mergeAnalysis", "Merge Analysis...");
        mergeMenuItem.setEnabled(true);
        mergeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.mergeAnalysis();
            }
        });
        if (!FindBugs.noAnalysis) {
            this.redoAnalysis = MainFrame.newJMenuItem("menu.rerunAnalysis", "Redo Analysis", 82);
            this.redoAnalysis.setEnabled(false);
            MainFrame.attachAcceleratorKey(this.redoAnalysis, 82);
            this.redoAnalysis.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainFrame.this.redoAnalysis();
                }
            });
        }
        openMenuItem.setEnabled(true);
        MainFrame.attachAcceleratorKey(openMenuItem, 79);
        openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.open();
            }
        });
        saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveAs();
            }
        });
        exportFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.exportFilter();
            }
        });
        importFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.importFilter();
            }
        });
        this.saveMenuItem.setEnabled(false);
        MainFrame.attachAcceleratorKey(this.saveMenuItem, 83);
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.save();
            }
        });
        if (!FindBugs.noAnalysis) {
            fileMenu.add(newProjectMenuItem);
        }
        fileMenu.add(this.reconfigMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(openMenuItem);
        fileMenu.add(this.recentMenu);
        fileMenu.addSeparator();
        fileMenu.add(importFilter);
        fileMenu.add(exportFilter);
        fileMenu.addSeparator();
        fileMenu.add(saveAsMenuItem);
        fileMenu.add(this.saveMenuItem);
        if (!FindBugs.noAnalysis) {
            fileMenu.addSeparator();
            fileMenu.add(this.redoAnalysis);
        }
        if (exitMenuItem != null) {
            fileMenu.addSeparator();
            fileMenu.add(exitMenuItem);
        }
        menuBar.add(fileMenu);
        JMenuItem cutMenuItem = new JMenuItem(new CutAction());
        JMenuItem copyMenuItem = new JMenuItem(new CopyAction());
        JMenuItem pasteMenuItem = new JMenuItem(new PasteAction());
        this.preferencesMenuItem = MainFrame.newJMenuItem("menu.preferences_menu", "Filters/Suppressions...");
        JMenuItem sortMenuItem = MainFrame.newJMenuItem("menu.sortConfiguration", "Sort Configuration...");
        JMenuItem goToLineMenuItem = MainFrame.newJMenuItem("menu.gotoLine", "Go to line...");
        MainFrame.attachAcceleratorKey(cutMenuItem, 88);
        MainFrame.attachAcceleratorKey(copyMenuItem, 67);
        MainFrame.attachAcceleratorKey(pasteMenuItem, 86);
        this.preferencesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.preferences();
            }
        });
        sortMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveComments(MainFrame.this.currentSelectedBugLeaf, MainFrame.this.currentSelectedBugAspects);
                SorterDialog.getInstance().setLocationRelativeTo(MainFrame.this);
                SorterDialog.getInstance().setVisible(true);
            }
        });
        MainFrame.attachAcceleratorKey(goToLineMenuItem, 76);
        goToLineMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.guiLayout.makeSourceVisible();
                try {
                    int num = Integer.parseInt(JOptionPane.showInputDialog(MainFrame.this, "", L10N.getLocalString("dlg.go_to_line_lbl", "Go To Line") + ":", 3));
                    MainFrame.this.displayer.showLine(num);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        editMenu.add(cutMenuItem);
        editMenu.add(copyMenuItem);
        editMenu.add(pasteMenuItem);
        editMenu.addSeparator();
        editMenu.add(goToLineMenuItem);
        editMenu.addSeparator();
        if (!MAC_OS_X) {
            editMenu.add(this.preferencesMenuItem);
        }
        editMenu.add(sortMenuItem);
        menuBar.add(editMenu);
        if (windowMenu != null) {
            menuBar.add(windowMenu);
        }
        this.viewMenu = MainFrame.newJMenu("menu.view", "View");
        this.setViewMenu();
        menuBar.add(this.viewMenu);
        ActionMap map = this.tree.getActionMap();
        JMenu navMenu = MainFrame.newJMenu("menu.navigation", "Navigation");
        this.addNavItem(map, navMenu, "menu.expand", "Expand", "expand", 39);
        this.addNavItem(map, navMenu, "menu.collapse", "Collapse", "collapse", 37);
        this.addNavItem(map, navMenu, "menu.up", "Up", "selectPrevious", 38);
        this.addNavItem(map, navMenu, "menu.down", "Down", "selectNext", 40);
        menuBar.add(navMenu);
        JMenu designationMenu = MainFrame.newJMenu("menu.designation", "Designation");
        int i = 0;
        int[] keyEvents = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
        for (String key : I18N.instance().getUserDesignationKeys(true)) {
            String name = I18N.instance().getUserDesignation(key);
            this.addDesignationItem(designationMenu, name, keyEvents[i++]);
        }
        menuBar.add(designationMenu);
        if (!MAC_OS_X) {
            JMenu helpMenu = MainFrame.newJMenu("menu.help_menu", "Help");
            JMenuItem aboutItem = MainFrame.newJMenuItem("menu.about_item", "About FindBugs");
            helpMenu.add(aboutItem);
            aboutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainFrame.this.about();
                }
            });
            menuBar.add(helpMenu);
        }
        return menuBar;
    }

    public void selectPackagePrefixByProject() {
        TreeSet<String> projects = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Multiset<String> count = new Multiset<String>();
        int total = 0;
        for (BugInstance b : this.bugCollection.getCollection()) {
            if (!this.shouldDisplayIssueIgnoringPackagePrefixes(b)) continue;
            TreeSet<String> projectsForThisBug = this.projectPackagePrefixes.getProjects(b.getPrimaryClass().getClassName());
            projects.addAll(projectsForThisBug);
            count.addAll(projectsForThisBug);
            ++total;
        }
        if (projects.size() == 0) {
            JOptionPane.showMessageDialog(this, "No issues in current view");
            return;
        }
        ArrayList<ProjectSelector> selectors = new ArrayList<ProjectSelector>(projects.size() + 1);
        ProjectSelector everything = new ProjectSelector("all projects", "", total);
        selectors.add(everything);
        for (String projectName : projects) {
            ProjectPackagePrefixes.PrefixFilter filter = this.projectPackagePrefixes.getFilter(projectName);
            selectors.add(new ProjectSelector(projectName, filter.toString(), count.getCount(projectName)));
        }
        ProjectSelector choice = (ProjectSelector)JOptionPane.showInputDialog(null, "Choose a project to set appropriate package prefix(es)", "Select package prefixes by package", 3, null, selectors.toArray(), everything);
        if (choice == null) {
            return;
        }
        this.textFieldForPackagesToDisplay.setText(choice.filter);
        this.viewFilter.setPackagesToDisplay(choice.filter);
        this.resetViewCache();
    }

    /*
     * WARNING - void declaration
     */
    public void setViewMenu() {
        void var7_18;
        JRadioButtonMenuItem rbMenuItem;
        Cloud cloud = this.bugCollection == null ? null : this.bugCollection.getCloud();
        this.viewMenu.removeAll();
        if (cloud != null && cloud.supportsCloudSummaries()) {
            JMenuItem cloudReport = new JMenuItem("Cloud summary");
            cloudReport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.displayCloudReport();
                }
            });
            this.viewMenu.add(cloudReport);
        }
        if (this.projectPackagePrefixes.size() > 0 && this.bugCollection != null) {
            JMenuItem selectPackagePrefixMenu = new JMenuItem("Select class search strings by project...");
            selectPackagePrefixMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.selectPackagePrefixByProject();
                }
            });
            this.viewMenu.add(selectPackagePrefixMenu);
        }
        if (this.viewMenu.getItemCount() > 0) {
            this.viewMenu.addSeparator();
        }
        ButtonGroup rankButtonGroup = new ButtonGroup();
        for (final ViewFilter.RankFilter r : ViewFilter.RankFilter.values()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(r.toString());
            rankButtonGroup.add(jRadioButtonMenuItem);
            if (r == ViewFilter.RankFilter.ALL) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.viewFilter.setRank(r);
                    MainFrame.this.resetViewCache();
                }
            });
            this.viewMenu.add(jRadioButtonMenuItem);
        }
        this.viewMenu.addSeparator();
        if (cloud != null && cloud.getMode() == Cloud.Mode.COMMUNAL) {
            ButtonGroup overallClassificationButtonGroup = new ButtonGroup();
            for (final ViewFilter.OverallClassificationFilter overallClassificationFilter : ViewFilter.OverallClassificationFilter.values()) {
                if (cloud != null && !overallClassificationFilter.supported(cloud)) continue;
                rbMenuItem = new JRadioButtonMenuItem(overallClassificationFilter.toString());
                overallClassificationButtonGroup.add(rbMenuItem);
                if (overallClassificationFilter == ViewFilter.OverallClassificationFilter.ALL) {
                    rbMenuItem.setSelected(true);
                }
                rbMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MainFrame.this.viewFilter.setClassification(overallClassificationFilter);
                        MainFrame.this.resetViewCache();
                    }
                });
                this.viewMenu.add(rbMenuItem);
            }
            this.viewMenu.addSeparator();
        }
        ButtonGroup evalButtonGroup = new ButtonGroup();
        for (final ViewFilter.CloudFilter cloudFilter : ViewFilter.CloudFilter.values()) {
            if (cloud != null && !cloudFilter.supported(cloud)) continue;
            rbMenuItem = new JRadioButtonMenuItem(cloudFilter.toString());
            evalButtonGroup.add(rbMenuItem);
            if (cloudFilter == ViewFilter.CloudFilter.ALL) {
                rbMenuItem.setSelected(true);
            }
            rbMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.viewFilter.setEvaluation(cloudFilter);
                    MainFrame.this.resetViewCache();
                }
            });
            this.viewMenu.add(rbMenuItem);
        }
        this.viewMenu.addSeparator();
        ButtonGroup ageButtonGroup = new ButtonGroup();
        ViewFilter.FirstSeenFilter[] arr$ = ViewFilter.FirstSeenFilter.values();
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_18 < len$) {
            final ViewFilter.FirstSeenFilter r = arr$[var7_18];
            JRadioButtonMenuItem rbMenuItem3 = new JRadioButtonMenuItem(r.toString());
            ageButtonGroup.add(rbMenuItem3);
            if (r == ViewFilter.FirstSeenFilter.ALL) {
                rbMenuItem3.setSelected(true);
            }
            rbMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.viewFilter.setFirstSeen(r);
                    MainFrame.this.resetViewCache();
                }
            });
            this.viewMenu.add(rbMenuItem3);
            ++var7_18;
        }
    }

    public void resetCommentsInputPane() {
        this.guiLayout.resetCommentsInputPane();
    }

    private void addNavItem(ActionMap map, JMenu navMenu, String menuNameKey, String menuNameDefault, String actionName, int keyEvent) {
        JMenuItem toggleItem = MainFrame.newJMenuItem(menuNameKey, menuNameDefault);
        toggleItem.addActionListener(this.treeActionAdapter(map, actionName));
        MainFrame.attachAcceleratorKey(toggleItem, keyEvent);
        navMenu.add(toggleItem);
    }

    ActionListener treeActionAdapter(ActionMap map, String actionName) {
        final Action selectPrevious = map.get(actionName);
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                e.setSource(MainFrame.this.tree);
                selectPrevious.actionPerformed(e);
            }
        };
    }

    static void attachAcceleratorKey(JMenuItem item, int keystroke) {
        MainFrame.attachAcceleratorKey(item, keystroke, 0);
    }

    static void attachAcceleratorKey(JMenuItem item, int keystroke, int additionalMask) {
        if (!MAC_OS_X && additionalMask != 0) {
            return;
        }
        item.setAccelerator(KeyStroke.getKeyStroke(keystroke, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | additionalMask));
    }

    @SwingThread
    void expandTree() {
        this.expandTree(Integer.MAX_VALUE);
    }

    @SwingThread
    void expandTree(int max) {
        int rows;
        Debug.printf("expandTree(%d)\n", max);
        JTree jTree = this.getTree();
        int i = 0;
        while (i < (rows = jTree.getRowCount()) && rows < max) {
            jTree.expandRow(i++);
        }
    }

    @SwingThread
    boolean leavesShown() {
        JTree jTree = this.getTree();
        int rows = jTree.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            Object lastPathComponent = treePath.getLastPathComponent();
            if (!(lastPathComponent instanceof BugLeafNode)) continue;
            return true;
        }
        return false;
    }

    @SwingThread
    void expandToFirstLeaf(int max) {
        int rows;
        Debug.println("expand to first leaf");
        if (this.leavesShown()) {
            return;
        }
        JTree jTree = this.getTree();
        int i = 0;
        while (i < (rows = jTree.getRowCount()) && rows < max) {
            TreePath treePath = jTree.getPathForRow(i);
            Object lastPathComponent = treePath.getLastPathComponent();
            if (lastPathComponent instanceof BugLeafNode) {
                return;
            }
            jTree.expandRow(i++);
        }
    }

    void newProject() {
        this.clearSourcePane();
        if (!FindBugs.noAnalysis) {
            if (this.curProject == null) {
                this.redoAnalysis.setEnabled(false);
            } else {
                List<String> fileList = this.curProject.getFileList();
                this.redoAnalysis.setEnabled(!fileList.isEmpty());
            }
        }
        if (this.newProject) {
            this.setProjectChanged(true);
            this.saveFile = null;
            this.saveMenuItem.setEnabled(false);
            this.reconfigMenuItem.setEnabled(true);
            this.newProject = false;
        }
    }

    private void importFilter() {
        this.filterOpenFileChooser.setDialogTitle(L10N.getLocalString("dlg.importFilter_ttl", "Import and merge filter..."));
        boolean retry = true;
        File f = null;
        while (retry) {
            Filter filter;
            retry = false;
            int value = this.filterOpenFileChooser.showOpenDialog(this);
            if (value != 0) {
                return;
            }
            f = this.filterOpenFileChooser.getSelectedFile();
            if (!f.exists()) {
                JOptionPane.showMessageDialog(this.filterOpenFileChooser, "No such file", "Invalid File", 2);
                retry = true;
                continue;
            }
            try {
                filter = Filter.parseFilter(f.getPath());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.filterOpenFileChooser, "Could not load filter.");
                retry = true;
                continue;
            }
            this.projectChanged = true;
            if (this.getProject().getSuppressionFilter() == null) {
                this.getProject().setSuppressionFilter(filter);
            } else {
                for (Matcher m : filter.getChildren()) {
                    this.getProject().getSuppressionFilter().addChild(m);
                }
            }
            PreferencesFrame.getInstance().updateFilterPanel();
        }
    }

    private void open() {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        if (this.projectChanged) {
            int response = JOptionPane.showConfirmDialog(this, L10N.getLocalString("dlg.save_current_changes", "The current project has been changed, Save current changes?"), L10N.getLocalString("dlg.save_changes", "Save Changes?"), 1, 2);
            if (response == 0) {
                if (this.saveFile != null) {
                    this.save();
                } else {
                    this.saveAs();
                }
            } else if (response == 2) {
                return;
            }
        }
        boolean loading = true;
        SaveType fileType = SaveType.NOT_KNOWN;
        while (loading) {
            File f;
            int value = this.saveOpenFileChooser.showOpenDialog(this);
            if (value != 0) {
                return;
            }
            loading = false;
            fileType = this.convertFilterToType(this.saveOpenFileChooser.getFileFilter());
            if (!fileType.isValid(f = this.saveOpenFileChooser.getSelectedFile())) {
                JOptionPane.showMessageDialog(this.saveOpenFileChooser, "That file is not compatible with the choosen file type", "Invalid File", 2);
                loading = true;
                continue;
            }
            switch (fileType) {
                case XML_ANALYSIS: {
                    if (!f.getName().endsWith(".xml")) {
                        JOptionPane.showMessageDialog(this.saveOpenFileChooser, L10N.getLocalString("dlg.not_xml_data_lbl", "This is not a saved bug XML data file."));
                        loading = true;
                        break;
                    }
                    if (this.openAnalysis(f, fileType)) break;
                    JOptionPane.showMessageDialog(this.saveOpenFileChooser, "An error occurred while trying to load the analysis.");
                    loading = true;
                    break;
                }
                case FBP_FILE: {
                    if (this.openFBPFile(f)) break;
                    JOptionPane.showMessageDialog(this.saveOpenFileChooser, "An error occurred while trying to load the analysis.");
                    loading = true;
                    break;
                }
                case FBA_FILE: {
                    if (this.openFBAFile(f)) break;
                    JOptionPane.showMessageDialog(this.saveOpenFileChooser, "An error occurred while trying to load the analysis.");
                    loading = true;
                    break;
                }
            }
        }
    }

    private boolean openFBAFile(File f) {
        return this.openAnalysis(f, SaveType.FBA_FILE);
    }

    private boolean openFBPFile(File f) {
        if (!f.exists() || !f.canRead()) {
            return false;
        }
        this.prepareForFileLoad(f, SaveType.FBP_FILE);
        this.loadProjectFromFile(f);
        return true;
    }

    private boolean exportFilter() {
        if (this.getProject().getSuppressionFilter() == null) {
            JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.no_filter", "There is no filter"));
            return false;
        }
        this.filterOpenFileChooser.setDialogTitle(L10N.getLocalString("dlg.exportFilter_ttl", "Export filter..."));
        boolean retry = true;
        boolean alreadyExists = true;
        File f = null;
        while (retry) {
            retry = false;
            int value = this.filterOpenFileChooser.showSaveDialog(this);
            if (value != 0) {
                return false;
            }
            f = this.filterOpenFileChooser.getSelectedFile();
            alreadyExists = f.exists();
            if (alreadyExists) {
                int response = JOptionPane.showConfirmDialog(this.filterOpenFileChooser, L10N.getLocalString("dlg.file_exists_lbl", "This file already exists.\nReplace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                if (response == 0) {
                    retry = false;
                }
                if (response == 2) {
                    retry = true;
                    continue;
                }
            }
            Filter suppressionFilter = this.getProject().getSuppressionFilter();
            try {
                suppressionFilter.writeEnabledMatchersAsXML(new FileOutputStream(f));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.saving_error_lbl", "An error occurred in saving."));
                return false;
            }
        }
        return true;
    }

    private boolean saveAs() {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        this.saveOpenFileChooser.setDialogTitle(L10N.getLocalString("dlg.saveas_ttl", "Save as..."));
        if (this.curProject == null) {
            JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.no_proj_save_lbl", "There is no project to save"));
            return false;
        }
        boolean retry = true;
        SaveType fileType = SaveType.NOT_KNOWN;
        boolean alreadyExists = true;
        File f = null;
        while (retry) {
            retry = false;
            int value = this.saveOpenFileChooser.showSaveDialog(this);
            if (value != 0) {
                return false;
            }
            fileType = this.convertFilterToType(this.saveOpenFileChooser.getFileFilter());
            if (fileType == SaveType.NOT_KNOWN) {
                Debug.println("Error! fileType == SaveType.NOT_KNOWN");
                retry = true;
                continue;
            }
            f = this.saveOpenFileChooser.getSelectedFile();
            if (!fileType.isValid(f = this.convertFile(f, fileType))) {
                JOptionPane.showMessageDialog(this.saveOpenFileChooser, "That file is not compatible with the chosen file type", "Invalid File", 2);
                retry = true;
                continue;
            }
            alreadyExists = this.fileAlreadyExists(f, fileType);
            if (alreadyExists) {
                int response = -1;
                switch (fileType) {
                    case XML_ANALYSIS: {
                        response = JOptionPane.showConfirmDialog(this.saveOpenFileChooser, L10N.getLocalString("dlg.analysis_exists_lbl", "This analysis already exists.\nReplace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                        break;
                    }
                    case FBP_FILE: {
                        response = JOptionPane.showConfirmDialog(this.saveOpenFileChooser, L10N.getLocalString("FB Project File already exists", "This FB project file already exists.\nDo you want to replace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                        break;
                    }
                    case FBA_FILE: {
                        response = JOptionPane.showConfirmDialog(this.saveOpenFileChooser, L10N.getLocalString("FB Analysis File already exists", "This FB analysis file already exists.\nDo you want to replace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                    }
                }
                if (response == 0) {
                    retry = false;
                }
                if (response == 2) {
                    retry = true;
                    continue;
                }
            }
            SaveReturn successful = SaveReturn.SAVE_ERROR;
            switch (fileType) {
                case XML_ANALYSIS: {
                    successful = this.saveAnalysis(f);
                    break;
                }
                case FBA_FILE: {
                    successful = this.saveFBAFile(f);
                    break;
                }
                case FBP_FILE: {
                    successful = this.saveFBPFile(f);
                }
            }
            if (successful == SaveReturn.SAVE_SUCCESSFUL) continue;
            JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.saving_error_lbl", "An error occurred in saving."));
            return false;
        }
        assert (f != null);
        this.saveMenuItem.setEnabled(false);
        this.setSaveType(fileType);
        this.saveFile = f;
        File xmlFile = f;
        this.addFileToRecent(xmlFile, this.getSaveType());
        return true;
    }

    private SaveType convertFilterToType(FileFilter f) {
        if (f instanceof FindBugsFileFilter) {
            return ((FindBugsFileFilter)f).getSaveType();
        }
        return SaveType.NOT_KNOWN;
    }

    private boolean fileAlreadyExists(File f, SaveType fileType) {
        return f.exists();
    }

    private File convertFile(File f, SaveType fileType) {
        if (!f.getName().endsWith(fileType.getFileExtension())) {
            f = new File(f.getAbsolutePath() + fileType.getFileExtension());
        }
        return f;
    }

    private void save() {
        File sFile = this.saveFile;
        assert (sFile != null);
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        SaveReturn result = SaveReturn.SAVE_ERROR;
        switch (this.getSaveType()) {
            case XML_ANALYSIS: {
                result = this.saveAnalysis(sFile);
                break;
            }
            case FBA_FILE: {
                result = this.saveFBAFile(sFile);
                break;
            }
            case FBP_FILE: {
                result = this.saveFBPFile(sFile);
            }
        }
        if (result != SaveReturn.SAVE_SUCCESSFUL) {
            JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.saving_error_lbl", "An error occurred in saving."));
        }
    }

    private SaveReturn saveFBAFile(File saveFile2) {
        return this.saveAnalysis(saveFile2);
    }

    private SaveReturn saveFBPFile(File saveFile2) {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        try {
            this.getProject().writeXML(saveFile2);
        }
        catch (IOException e) {
            AnalysisContext.logError("Couldn't save FBP file to " + saveFile2, e);
            return SaveReturn.SAVE_IO_EXCEPTION;
        }
        this.setProjectChanged(false);
        return SaveReturn.SAVE_SUCCESSFUL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireDisplayWait() {
        Object object = this.waitLock;
        synchronized (object) {
            ++this.waitCount;
            if (DEBUG) {
                new RuntimeException("acquiring display wait, count " + this.waitCount).printStackTrace(System.out);
            }
            if (this.waitCount == 1) {
                this.showCard(BugCard.WAITCARD, new Cursor(3));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDisplayWait() {
        Object object = this.waitLock;
        synchronized (object) {
            if (this.waitCount <= 0) {
                throw new AssertionError((Object)"Can't decrease wait count; already zero");
            }
            --this.waitCount;
            if (DEBUG) {
                new RuntimeException("releasing display wait, count " + this.waitCount).printStackTrace(System.out);
            }
            if (this.waitCount == 0) {
                this.showCard(BugCard.TREECARD, new Cursor(0));
            }
        }
    }

    private void showCard(final BugCard card, final Cursor cursor) {
        Runnable doRun = new Runnable(){

            public void run() {
                MainFrame.this.recentMenu.setEnabled(card == BugCard.TREECARD);
                MainFrame.this.tableheader.setReorderingAllowed(card == BugCard.TREECARD);
                MainFrame.this.enablePreferences(card == BugCard.TREECARD);
                MainFrame.this.setCursor(cursor);
                CardLayout layout = (CardLayout)MainFrame.this.cardPanel.getLayout();
                layout.show(MainFrame.this.cardPanel, card.name());
                if (card == BugCard.TREECARD) {
                    SorterDialog.getInstance().thaw();
                } else {
                    SorterDialog.getInstance().freeze();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doRun.run();
        } else {
            SwingUtilities.invokeLater(doRun);
        }
    }

    JPanel makeNavigationPanel(String packageSelectorLabel, JComponent packageSelector, JComponent treeHeader, JComponent tree) {
        JPanel topPanel = new JPanel();
        topPanel.setMinimumSize(new Dimension(150, 150));
        topPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipady = 3;
        c.ipadx = 3;
        c.insets = new Insets(6, 6, 6, 6);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        JLabel label = new JLabel(packageSelectorLabel);
        topPanel.add((Component)label, c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        topPanel.add((Component)packageSelector, c);
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        c.ipady = 2;
        c.ipadx = 2;
        c.fill = 2;
        topPanel.add((Component)treeHeader, c);
        c.fill = 1;
        ++c.gridy;
        c.weighty = 1.0;
        c.ipady = 0;
        c.ipadx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        topPanel.add((Component)tree, c);
        return topPanel;
    }

    JPanel bugListPanel() {
        this.tableheader = new JTableHeader();
        this.tableheader.setCursor(Cursor.getPredefinedCursor(10));
        this.tableheader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Debug.println("tableheader.getReorderingAllowed() = " + MainFrame.this.tableheader.getReorderingAllowed());
                if (!MainFrame.this.tableheader.getReorderingAllowed()) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    SorterDialog.getInstance().setVisible(true);
                }
            }

            public void mouseReleased(MouseEvent arg0) {
                if (!MainFrame.this.tableheader.getReorderingAllowed()) {
                    return;
                }
                BugTreeModel bt = (BugTreeModel)MainFrame.this.getTree().getModel();
                bt.checkSorter();
            }
        });
        this.sorter = GUISaveState.getInstance().getStarterTable();
        this.tableheader.setColumnModel(this.sorter);
        this.tableheader.setToolTipText(L10N.getLocalString("tooltip.reorder_message", "Drag to reorder tree folder and sort order"));
        this.tree = new JTree();
        this.treeUI = (BasicTreeUI)this.tree.getUI();
        this.tree.setLargeModel(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new BugRenderer());
        this.tree.setRowHeight((int)(Driver.getFontSize() + 7.0f));
        this.tree.setModel(new BugTreeModel(this.tree, this.sorter, new BugSet(new ArrayList())));
        this.setupTreeListeners();
        this.setProject(new Project());
        this.treeScrollPane = new JScrollPane(this.tree);
        this.treePanel = new JPanel(new BorderLayout());
        this.treePanel.add((Component)this.treeScrollPane, "Center");
        JTable t = new JTable(new DefaultTableModel(0, this.sortables().length));
        t.setTableHeader(this.tableheader);
        this.textFieldForPackagesToDisplay = new JTextField();
        ActionListener filterAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    MainFrame.this.viewFilter.setPackagesToDisplay(MainFrame.this.textFieldForPackagesToDisplay.getText());
                    MainFrame.this.resetViewCache();
                }
                catch (IllegalArgumentException err) {
                    JOptionPane.showMessageDialog(MainFrame.this, err.getMessage(), "Bad class search string", 0);
                }
            }
        };
        this.textFieldForPackagesToDisplay.addActionListener(filterAction);
        JButton filterButton = new JButton("Filter");
        filterButton.addActionListener(filterAction);
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.gridy = 1;
        filterPanel.add((Component)this.textFieldForPackagesToDisplay, gbc);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        filterPanel.add((Component)filterButton, gbc);
        filterPanel.setToolTipText("Only show classes containing the word(s) you specify");
        JPanel sortablePanel = new JPanel(new GridBagLayout());
        JLabel sortableLabel = new JLabel("Group bugs by:");
        sortableLabel.setLabelFor(this.tableheader);
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.gridy = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 1;
        sortablePanel.add((Component)sortableLabel, gbc);
        gbc.weightx = 1.0;
        sortablePanel.add((Component)this.tableheader, gbc);
        this.tableheader.setBorder(new LineBorder(Color.BLACK));
        JPanel topPanel = this.makeNavigationPanel("Class name filter:", filterPanel, sortablePanel, this.treePanel);
        this.cardPanel = new JPanel(new CardLayout());
        this.waitPanel = new JPanel();
        this.waitPanel.setLayout(new BoxLayout(this.waitPanel, 1));
        this.waitPanel.add(new JLabel("Please wait..."));
        this.waitStatusLabel = new JLabel();
        this.waitPanel.add(this.waitStatusLabel);
        this.cardPanel.add((Component)topPanel, BugCard.TREECARD.name());
        this.cardPanel.add((Component)this.waitPanel, BugCard.WAITCARD.name());
        return this.cardPanel;
    }

    public void newTree(final JTree newTree, final BugTreeModel newModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.tree = newTree;
                MainFrame.this.tree.getSelectionModel().setSelectionMode(1);
                MainFrame.this.tree.setLargeModel(true);
                MainFrame.this.tree.setCellRenderer(new BugRenderer());
                MainFrame.this.treePanel.remove(MainFrame.this.treeScrollPane);
                MainFrame.this.treeScrollPane = new JScrollPane(newTree);
                MainFrame.this.treePanel.add(MainFrame.this.treeScrollPane);
                MainFrame.this.setFontSizeHelper(Driver.getFontSize(), MainFrame.this.treeScrollPane);
                MainFrame.this.tree.setRowHeight((int)(Driver.getFontSize() + 7.0f));
                MainFrame.this.getContentPane().validate();
                MainFrame.this.getContentPane().repaint();
                MainFrame.this.setupTreeListeners();
                newModel.openPreviouslySelected(((BugTreeModel)MainFrame.this.tree.getModel()).getOldSelectedBugs());
                MainFrame.this.expandTree(10);
                MainFrame.this.expandToFirstLeaf(14);
                MainFrame.this.getSorter().addColumnModelListener(newModel);
                FilterActivity.addFilterListener(newModel.bugTreeFilterListener);
                MainFrame.this.setSorting(true);
            }
        });
    }

    private void setupTreeListeners() {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent selectionEvent) {
                TreePath path = selectionEvent.getNewLeadSelectionPath();
                if (path != null) {
                    MainFrame.this.saveComments(MainFrame.this.currentSelectedBugLeaf, MainFrame.this.currentSelectedBugAspects);
                    Object lastPathComponent = path.getLastPathComponent();
                    if (lastPathComponent instanceof BugLeafNode) {
                        boolean beforeProjectChanged = MainFrame.this.projectChanged;
                        MainFrame.this.currentSelectedBugLeaf = (BugLeafNode)lastPathComponent;
                        MainFrame.this.currentSelectedBugAspects = null;
                        MainFrame.this.syncBugInformation();
                        MainFrame.this.setProjectChanged(beforeProjectChanged);
                    } else {
                        boolean beforeProjectChanged = MainFrame.this.projectChanged;
                        MainFrame.this.updateDesignationDisplay();
                        MainFrame.this.currentSelectedBugLeaf = null;
                        MainFrame.this.currentSelectedBugAspects = (BugAspects)lastPathComponent;
                        MainFrame.this.syncBugInformation();
                        MainFrame.this.setProjectChanged(beforeProjectChanged);
                    }
                }
                if (MainFrame.this.tree.getSelectionCount() != 1) {
                    Debug.println("Tree selection count not equal to 1, disabling comments tab" + selectionEvent);
                    MainFrame.this.setUserCommentInputEnable(false);
                }
            }
        });
        this.tree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                TreePath path = MainFrame.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                if (e.getButton() == 3 || e.getButton() == 1 && e.isControlDown()) {
                    if (MainFrame.this.tree.getModel().isLeaf(path.getLastPathComponent())) {
                        MainFrame.this.tree.setSelectionPath(path);
                        MainFrame.this.bugPopupMenu.show(MainFrame.this.tree, e.getX(), e.getY());
                    } else {
                        MainFrame.this.tree.setSelectionPath(path);
                        if (path.getParentPath() != null) {
                            MainFrame.this.branchPopupMenu.show(MainFrame.this.tree, e.getX(), e.getY());
                        }
                    }
                }
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });
    }

    void syncBugInformation() {
        boolean prevProjectChanged = this.projectChanged;
        if (this.currentSelectedBugLeaf != null) {
            BugInstance bug = this.currentSelectedBugLeaf.getBug();
            this.displayer.displaySource(bug, bug.getPrimarySourceLineAnnotation());
            this.updateDesignationDisplay();
            this.comments.updateCommentsFromLeafInformation(this.currentSelectedBugLeaf);
            this.updateSummaryTab(this.currentSelectedBugLeaf);
        } else if (this.currentSelectedBugAspects != null) {
            this.updateDesignationDisplay();
            this.comments.updateCommentsFromNonLeafInformation(this.currentSelectedBugAspects);
            this.displayer.displaySource(null, null);
            this.clearSummaryTab();
        } else {
            this.displayer.displaySource(null, null);
            this.clearSummaryTab();
        }
        this.setProjectChanged(prevProjectChanged);
    }

    void clearSourcePane() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.setSourceTab("", null);
                MainFrame.this.sourceCodeTextPane.setDocument(SourceCodeDisplay.SOURCE_NOT_RELEVANT);
            }
        });
    }

    private void setUserCommentInputEnable(boolean b) {
        this.comments.setUserCommentInputEnable(b);
    }

    JPanel statusBar() {
        JPanel statusBar = new JPanel();
        statusBar.setBorder(new BevelBorder(1));
        statusBar.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        statusBar.add((Component)this.statusBarLabel, constraints.clone());
        constraints.weightx = 0.0;
        constraints.fill = 0;
        try {
            this.signedInIcon = this.loadImageResource("greencircle.png", 16, 16);
            this.warningIcon = this.loadImageResource("warningicon.png", 16, 16);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not load status icons", e);
            this.signedInIcon = null;
            this.warningIcon = null;
        }
        this.signedInLabel = new JLabel();
        this.signedInLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.signedInLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JPopupMenu menu = new JPopupMenu();
                Cloud.SigninState signinState = MainFrame.this.bugCollection.getCloud().getSigninState();
                boolean isSignedIn = signinState == Cloud.SigninState.SIGNED_IN;
                final JCheckBoxMenuItem signInAuto = new JCheckBoxMenuItem("Sign in automatically");
                signInAuto.setToolTipText("Saves your Cloud session for the next time you run FindBugs. No personal information or passwords are saved.");
                signInAuto.setSelected(MainFrame.this.bugCollection.getCloud().isSavingSignInInformationEnabled());
                signInAuto.setEnabled(isSignedIn);
                signInAuto.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        boolean checked = signInAuto.isSelected();
                        if (checked != MainFrame.this.bugCollection.getCloud().isSavingSignInInformationEnabled()) {
                            System.out.println("checked: " + checked);
                            MainFrame.this.bugCollection.getCloud().setSaveSignInInformation(checked);
                        }
                    }
                });
                menu.add(signInAuto);
                switch (signinState) {
                    case SIGNED_OUT: 
                    case UNAUTHENTICATED: 
                    case SIGNIN_FAILED: {
                        menu.add(new AbstractAction("Sign in"){

                            public void actionPerformed(ActionEvent e) {
                                try {
                                    MainFrame.this.bugCollection.getCloud().signIn();
                                }
                                catch (IOException e1) {
                                    MainFrame.this.showMessageDialog("Sign-in error: " + e1.getMessage());
                                    LOGGER.log(Level.SEVERE, "Could not sign in", e1);
                                }
                            }
                        });
                        break;
                    }
                    default: {
                        menu.add(new AbstractAction("Sign out"){

                            public void actionPerformed(ActionEvent e) {
                                MainFrame.this.bugCollection.getCloud().signOut();
                            }
                        }).setEnabled(isSignedIn);
                    }
                }
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        constraints.anchor = 13;
        constraints.insets = new Insets(0, 5, 0, 5);
        statusBar.add((Component)this.signedInLabel, constraints.clone());
        this.signedInLabel.setVisible(false);
        JLabel logoLabel = new JLabel();
        constraints.insets = new Insets(0, 0, 0, 0);
        ImageIcon logoIcon = new ImageIcon(MainFrame.class.getResource("logo_umd.png"));
        logoLabel.setIcon(logoIcon);
        logoLabel.setPreferredSize(new Dimension(logoIcon.getIconWidth(), logoIcon.getIconHeight()));
        constraints.anchor = 17;
        statusBar.add((Component)logoLabel, constraints.clone());
        return statusBar;
    }

    private ImageIcon loadImageResource(String filename, int width, int height) throws IOException {
        return new ImageIcon(ImageIO.read(MainFrame.class.getResource(filename)).getScaledInstance(width, height, 4));
    }

    private String join(String s1, String s2) {
        if (s1 == null || s1.length() == 0) {
            return s2;
        }
        if (s2 == null || s2.length() == 0) {
            return s1;
        }
        return s1 + "; " + s2;
    }

    @SwingThread
    void updateStatusBar() {
        Cloud plugin;
        int countFilteredBugs = BugSet.countFilteredBugs();
        String msg = "";
        if (countFilteredBugs == 1) {
            msg = "  1 " + L10N.getLocalString("statusbar.bug_hidden", "bug hidden by filters");
        } else if (countFilteredBugs > 1) {
            msg = "  " + countFilteredBugs + " " + L10N.getLocalString("statusbar.bugs_hidden", "bugs hidden by filters");
        }
        boolean showLoggedInStatus = false;
        if (this.bugCollection != null && (plugin = this.bugCollection.getCloud()) != null) {
            Cloud.SigninState state;
            String pluginMsg = plugin.getStatusMsg();
            if (pluginMsg != null && pluginMsg.length() > 1) {
                msg = this.join(msg, pluginMsg);
            }
            if ((state = plugin.getSigninState()) == Cloud.SigninState.SIGNING_IN) {
                this.signedInLabel.setText("<html>FindBugs Cloud:<br> signing in");
                this.signedInLabel.setIcon(null);
                showLoggedInStatus = true;
            } else if (state == Cloud.SigninState.SIGNED_IN) {
                this.signedInLabel.setText("<html>FindBugs Cloud:<br> signed in as " + plugin.getUser());
                this.signedInLabel.setIcon(this.signedInIcon);
                showLoggedInStatus = true;
            } else if (state == Cloud.SigninState.SIGNIN_FAILED) {
                this.signedInLabel.setText("<html>FindBugs Cloud:<br> sign-in failed");
                this.signedInLabel.setIcon(this.warningIcon);
                showLoggedInStatus = true;
            } else if (state == Cloud.SigninState.SIGNED_OUT || state == Cloud.SigninState.UNAUTHENTICATED) {
                this.signedInLabel.setText("<html>FindBugs Cloud:<br> not signed in");
                this.signedInLabel.setIcon(null);
                showLoggedInStatus = true;
            }
        }
        this.signedInLabel.setVisible(showLoggedInStatus);
        if (this.errorMsg != null && this.errorMsg.length() > 0) {
            msg = this.join(msg, this.errorMsg);
        }
        this.waitStatusLabel.setText(msg);
        if (msg.length() == 0) {
            msg = "http://findbugs.sourceforge.net";
        }
        this.statusBarLabel.setText(msg);
    }

    @Override
    public void setErrorMessage(String errorMsg) {
        this.errorMsg = errorMsg;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.updateStatusBar();
            }
        });
    }

    private void updateSummaryTab(BugLeafNode node) {
        final BugInstance bug = node.getBug();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.summaryTopPanel.removeAll();
                MainFrame.this.summaryTopPanel.add(MainFrame.this.bugSummaryComponent(bug.getAbridgedMessage(), bug));
                for (BugAnnotation b : bug.getAnnotationsForMessage(true)) {
                    MainFrame.this.summaryTopPanel.add(MainFrame.this.bugSummaryComponent(b, bug));
                }
                MainFrame.this.summaryHtmlArea.setText(bug.getBugPattern().getDetailHTML());
                MainFrame.this.summaryTopPanel.add(Box.createVerticalGlue());
                MainFrame.this.summaryTopPanel.revalidate();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MainFrame.this.summaryHtmlScrollPane.getVerticalScrollBar().setValue(MainFrame.this.summaryHtmlScrollPane.getVerticalScrollBar().getMinimum());
                    }
                });
            }
        });
    }

    private void clearSummaryTab() {
        this.summaryHtmlArea.setText("");
        this.summaryTopPanel.removeAll();
        this.summaryTopPanel.revalidate();
    }

    JSplitPane summaryTab() {
        int fontSize = (int)Driver.getFontSize();
        this.summaryTopPanel = new JPanel();
        this.summaryTopPanel.setLayout(new GridLayout(0, 1));
        this.summaryTopPanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.summaryTopPanel.setMinimumSize(new Dimension(fontSize * 50, fontSize * 5));
        JPanel summaryTopOuter = new JPanel(new BorderLayout());
        summaryTopOuter.add((Component)this.summaryTopPanel, "North");
        this.summaryHtmlArea.setToolTipText(L10N.getLocalString("tooltip.longer_description", "This gives a longer description of the detected bug pattern"));
        this.summaryHtmlArea.setContentType("text/html");
        this.summaryHtmlArea.setEditable(false);
        this.summaryHtmlArea.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutDialog.editorPaneHyperlinkUpdate(evt);
            }
        });
        this.setStyleSheets();
        JScrollPane summaryScrollPane = new JScrollPane(summaryTopOuter);
        summaryScrollPane.getVerticalScrollBar().setUnitIncrement((int)Driver.getFontSize());
        JSplitPane splitP = new JSplitPane(0, false, summaryScrollPane, this.summaryHtmlScrollPane);
        splitP.setDividerLocation(GUISaveState.getInstance().getSplitSummary());
        splitP.setOneTouchExpandable(true);
        splitP.setUI(new BasicSplitPaneUI(){

            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    public void setBorder(Border b) {
                    }
                };
            }
        });
        splitP.setBorder(null);
        return splitP;
    }

    private Component bugSummaryComponent(String str, BugInstance bug) {
        JLabel label = new JLabel();
        label.setFont(label.getFont().deriveFont(Driver.getFontSize()));
        label.setFont(label.getFont().deriveFont(0));
        label.setForeground(Color.BLACK);
        label.setText(str);
        SourceLineAnnotation link = bug.getPrimarySourceLineAnnotation();
        if (link != null) {
            label.addMouseListener(new BugSummaryMouseListener(bug, label, link));
        }
        return label;
    }

    private Component bugSummaryComponent(BugAnnotation value, BugInstance bug) {
        JLabel label = new JLabel();
        label.setFont(label.getFont().deriveFont(Driver.getFontSize()));
        label.setFont(label.getFont().deriveFont(0));
        label.setForeground(Color.BLACK);
        ClassAnnotation primaryClass = bug.getPrimaryClass();
        String sourceCodeLabel = L10N.getLocalString("summary.source_code", "source code.");
        String summaryLine = L10N.getLocalString("summary.line", "Line");
        String summaryLines = L10N.getLocalString("summary.lines", "Lines");
        String clickToGoToText = L10N.getLocalString("tooltip.click_to_go_to", "Click to go to");
        if (value instanceof SourceLineAnnotation) {
            SourceLineAnnotation link = (SourceLineAnnotation)value;
            if (this.sourceCodeExists(link)) {
                String srcStr = "";
                int start = link.getStartLine();
                int end = link.getEndLine();
                if (start < 0 && end < 0) {
                    srcStr = sourceCodeLabel;
                } else if (start == end) {
                    srcStr = " [" + summaryLine + " " + start + "]";
                } else if (start < end) {
                    srcStr = " [" + summaryLines + " " + start + " - " + end + "]";
                }
                label.setToolTipText(clickToGoToText + " " + srcStr);
                label.addMouseListener(new BugSummaryMouseListener(bug, label, link));
            }
            label.setText(link.toString());
        } else if (value instanceof BugAnnotationWithSourceLines) {
            BugAnnotationWithSourceLines note = (BugAnnotationWithSourceLines)value;
            SourceLineAnnotation link = note.getSourceLines();
            String srcStr = "";
            if (link != null && this.sourceCodeExists(link)) {
                int start = link.getStartLine();
                int end = link.getEndLine();
                if (start < 0 && end < 0) {
                    srcStr = sourceCodeLabel;
                } else if (start == end) {
                    srcStr = " [" + summaryLine + " " + start + "]";
                } else if (start < end) {
                    srcStr = " [" + summaryLines + " " + start + " - " + end + "]";
                }
                if (!srcStr.equals("")) {
                    label.setToolTipText(clickToGoToText + " " + srcStr);
                    label.addMouseListener(new BugSummaryMouseListener(bug, label, link));
                }
            }
            String noteText = note == bug.getPrimaryMethod() || note == bug.getPrimaryField() ? note.toString() : note.toString(primaryClass);
            if (!srcStr.equals(sourceCodeLabel)) {
                label.setText(noteText + srcStr);
            } else {
                label.setText(noteText);
            }
        } else {
            label.setText(value.toString(primaryClass));
        }
        return label;
    }

    public void waitUntilReady() throws InterruptedException {
        this.mainFrameInitialized.await();
    }

    private boolean sourceCodeExists(@Nonnull SourceLineAnnotation note) {
        try {
            this.getProject().getSourceFinder().findSourceFile(note);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void setStyleSheets() {
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule("body {font-size: " + Driver.getFontSize() + "pt}");
        styleSheet.addRule("H1 {color: red;  font-size: 120%; font-weight: bold;}");
        styleSheet.addRule("code {font-family: courier; font-size: " + Driver.getFontSize() + "pt}");
        styleSheet.addRule(" a:link { color: #0000FF; } ");
        styleSheet.addRule(" a:visited { color: #800080; } ");
        styleSheet.addRule(" a:active { color: #FF0000; text-decoration: underline; } ");
        this.htmlEditorKit.setStyleSheet(styleSheet);
        this.summaryHtmlArea.setEditorKit(this.htmlEditorKit);
    }

    JPanel createCommentsInputPanel() {
        return this.comments.createCommentsInputPanel();
    }

    JPanel createSourceCodePanel() {
        Font sourceFont = new Font("Monospaced", 0, (int)Driver.getFontSize());
        this.sourceCodeTextPane.setFont(sourceFont);
        this.sourceCodeTextPane.setEditable(false);
        this.sourceCodeTextPane.getCaret().setSelectionVisible(true);
        this.sourceCodeTextPane.setDocument(SourceCodeDisplay.SOURCE_NOT_RELEVANT);
        this.sourceCodeScrollPane = new JScrollPane(this.sourceCodeTextPane);
        this.sourceCodeScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.sourceCodeScrollPane, "Center");
        panel.revalidate();
        if (DEBUG) {
            System.out.println("Created source code panel");
        }
        return panel;
    }

    JPanel createSourceSearchPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel thePanel = new JPanel();
        thePanel.setLayout(gridbag);
        this.findButton.setToolTipText("Find first occurrence");
        this.findNextButton.setToolTipText("Find next occurrence");
        this.findPreviousButton.setToolTipText("Find previous occurrence");
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 5);
        c.fill = 2;
        gridbag.setConstraints(this.sourceSearchTextField, c);
        thePanel.add(this.sourceSearchTextField);
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.searchSource(0);
            }
        });
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        gridbag.setConstraints(this.findButton, c);
        thePanel.add(this.findButton);
        this.findNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.searchSource(1);
            }
        });
        c.gridx = 2;
        c.weightx = 0.0;
        c.fill = 0;
        gridbag.setConstraints(this.findNextButton, c);
        thePanel.add(this.findNextButton);
        this.findPreviousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.searchSource(2);
            }
        });
        c.gridx = 3;
        c.weightx = 0.0;
        c.fill = 0;
        gridbag.setConstraints(this.findPreviousButton, c);
        thePanel.add(this.findPreviousButton);
        return thePanel;
    }

    void searchSource(int type) {
        int targetLineNum = -1;
        String targetString = this.sourceSearchTextField.getText();
        switch (type) {
            case 0: {
                targetLineNum = this.displayer.find(targetString);
                break;
            }
            case 1: {
                targetLineNum = this.displayer.findNext(targetString);
                break;
            }
            case 2: {
                targetLineNum = this.displayer.findPrevious(targetString);
            }
        }
        if (targetLineNum != -1) {
            this.displayer.foundItem(targetLineNum);
        }
    }

    void setSourceTab(String title, @CheckForNull BugInstance bug) {
        JComponent label = this.guiLayout.getSourceViewComponent();
        if (label != null) {
            Cloud plugin;
            URL u = null;
            if (bug != null && (plugin = this.bugCollection.getCloud()).supportsSourceLinks()) {
                u = plugin.getSourceLink(bug);
            }
            if (u != null) {
                this.addLink(label, u);
            } else {
                this.removeLink(label);
            }
        }
        this.guiLayout.setSourceTitle(title);
    }

    void addLink(JComponent component, URL source) {
        this.sourceLink = source;
        component.setEnabled(true);
        if (!this.listenerAdded) {
            this.listenerAdded = true;
            component.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    URL u = MainFrame.this.sourceLink;
                    if (u != null) {
                        LaunchBrowser.showDocument(u);
                    }
                }
            });
        }
        component.setCursor(new Cursor(12));
        Cloud plugin = this.bugCollection.getCloud();
        if (plugin != null) {
            component.setToolTipText(plugin.getSourceLinkToolTip(null));
        }
    }

    void removeLink(JComponent component) {
        this.sourceLink = null;
        component.setEnabled(false);
        component.setCursor(new Cursor(0));
        component.setToolTipText("");
    }

    SorterTableColumnModel getSorter() {
        return this.sorter;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        float size = Driver.getFontSize();
        this.getJMenuBar().setFont(this.getJMenuBar().getFont().deriveFont(size));
        for (int i = 0; i < this.getJMenuBar().getMenuCount(); ++i) {
            for (int j = 0; j < this.getJMenuBar().getMenu(i).getMenuComponentCount(); ++j) {
                Component temp = this.getJMenuBar().getMenu(i).getMenuComponent(j);
                temp.setFont(temp.getFont().deriveFont(size));
            }
        }
        this.bugPopupMenu.setFont(this.bugPopupMenu.getFont().deriveFont(size));
        this.setFontSizeHelper(size, this.bugPopupMenu.getComponents());
        this.branchPopupMenu.setFont(this.branchPopupMenu.getFont().deriveFont(size));
        this.setFontSizeHelper(size, this.branchPopupMenu.getComponents());
    }

    public JTree getTree() {
        return this.tree;
    }

    public BugTreeModel getBugTreeModel() {
        return (BugTreeModel)this.getTree().getModel();
    }

    public synchronized Project getProject() {
        if (this.curProject == null) {
            this.curProject = new Project();
        }
        return this.curProject;
    }

    public synchronized void setProject(Project p) {
        this.curProject = p;
    }

    public void setSorting(boolean b) {
        this.tableheader.setReorderingAllowed(b);
    }

    private void setSaveMenu() {
        File s = this.saveFile;
        this.saveMenuItem.setEnabled(this.projectChanged && s != null && this.getSaveType() != SaveType.FBP_FILE && s.exists());
    }

    public void setProjectChanged(boolean b) {
        if (this.curProject == null) {
            return;
        }
        if (this.projectChanged == b) {
            return;
        }
        this.projectChanged = b;
        this.setSaveMenu();
        this.getRootPane().putClientProperty(WINDOW_MODIFIED, b);
    }

    public boolean getProjectChanged() {
        return this.projectChanged;
    }

    private SaveReturn saveProject(File dir) {
        if (!dir.mkdir()) {
            return SaveReturn.SAVE_IO_EXCEPTION;
        }
        File f = new File(dir.getAbsolutePath() + File.separator + dir.getName() + ".xml");
        File filtersAndSuppressions = new File(dir.getAbsolutePath() + File.separator + dir.getName() + ".fas");
        BugSaver.saveBugs(f, this.bugCollection, this.getProject());
        try {
            this.getProjectSettings().save(new FileOutputStream(filtersAndSuppressions));
        }
        catch (IOException e) {
            Debug.println(e);
            return SaveReturn.SAVE_IO_EXCEPTION;
        }
        this.setProjectChanged(false);
        return SaveReturn.SAVE_SUCCESSFUL;
    }

    private void saveComments(BugLeafNode theNode, BugAspects theAspects) {
        this.comments.saveComments(theNode, theAspects);
    }

    void saveComments() {
        this.comments.saveComments();
    }

    public Color getSourceColor() {
        return this.sourceCodeTextPane.getBackground();
    }

    @Override
    public void error(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    @Override
    public void writeToLog(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    private SaveReturn saveAnalysis(File f) {
        BugSaver.saveBugs(f, this.bugCollection, this.getProject());
        this.setProjectChanged(false);
        return SaveReturn.SAVE_SUCCESSFUL;
    }

    public boolean openAnalysis(File f, SaveType saveType) {
        if (!f.exists() || !f.canRead()) {
            throw new IllegalArgumentException("Can't read " + f.getPath());
        }
        this.prepareForFileLoad(f, saveType);
        this.loadAnalysis(f);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openBugCollection(SortedBugCollection bugs) {
        this.acquireDisplayWait();
        try {
            this.prepareForFileLoad(null, null);
            Project project = bugs.getProject();
            project.setGuiCallback(this);
            BugLoader.addDeadBugMatcher(project);
            this.setProjectAndBugCollectionInSwingThread(project, bugs);
        }
        finally {
            this.releaseDisplayWait();
        }
    }

    private void prepareForFileLoad(File f, SaveType saveType) {
        this.createProjectSettings();
        this.clearSourcePane();
        this.clearSummaryTab();
        this.comments.setUserCommentInputEnable(false);
        this.reconfigMenuItem.setEnabled(true);
        this.setProjectChanged(false);
        this.setSaveType(saveType);
        this.saveFile = f;
        this.addFileToRecent(f, saveType);
    }

    private void loadAnalysis(final File file) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MainFrame.this.acquireDisplayWait();
                try {
                    Project project = new Project();
                    project.setGuiCallback(MainFrame.this);
                    project.setCurrentWorkingDirectory(file.getParentFile());
                    BugLoader.loadBugs(MainFrame.this, project, file);
                    project.getSourceFinder();
                    MainFrame.this.updateBugTree();
                }
                finally {
                    MainFrame.this.releaseDisplayWait();
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            new Thread(runnable, "Analysis loading thread").start();
        } else {
            runnable.run();
        }
    }

    private void loadAnalysis(final URL url) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MainFrame.this.acquireDisplayWait();
                try {
                    Project project = new Project();
                    project.setGuiCallback(MainFrame.this);
                    BugLoader.loadBugs(MainFrame.this, project, url);
                    project.getSourceFinder();
                    MainFrame.this.updateBugTree();
                }
                finally {
                    MainFrame.this.releaseDisplayWait();
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            new Thread(runnable, "Analysis loading thread").start();
        } else {
            runnable.run();
        }
    }

    private void loadProjectFromFile(final File f) {
        Runnable runnable = new Runnable(){

            public void run() {
                Project project = BugLoader.loadProject(MainFrame.this, f);
                BugCollection bc = project == null ? null : BugLoader.doAnalysis(project);
                MainFrame.this.updateProjectAndBugCollection(project, bc, null);
                MainFrame.this.setProjectAndBugCollectionInSwingThread(project, bc);
            }
        };
        if (EventQueue.isDispatchThread()) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    void redoAnalysis() {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        this.acquireDisplayWait();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    MainFrame.this.updateDesignationDisplay();
                    BugCollection bc = BugLoader.redoAnalysisKeepComments(MainFrame.this.getProject());
                    MainFrame.this.updateProjectAndBugCollection(MainFrame.this.getProject(), bc, null);
                }
                finally {
                    MainFrame.this.releaseDisplayWait();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeAnalysis() {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        this.acquireDisplayWait();
        try {
            BugCollection bc = BugLoader.combineBugHistories();
            this.setBugCollection(bc);
        }
        finally {
            this.releaseDisplayWait();
        }
    }

    private ProjectSettings getProjectSettings() {
        return ProjectSettings.getInstance();
    }

    private void loadProjectSettings(File fasFile) throws FileNotFoundException {
        ProjectSettings.loadInstance(new FileInputStream(fasFile));
    }

    private void createProjectSettings() {
        ProjectSettings.newInstance();
    }

    private void addFileToRecent(File xmlFile, SaveType st) {
        ArrayList<File> xmlFiles = GUISaveState.getInstance().getRecentFiles();
        if (!xmlFiles.contains(xmlFile)) {
            GUISaveState.getInstance().addRecentFile(xmlFile);
        }
        this.recentMenuCache.addRecentFile(xmlFile);
    }

    private void newProjectMenu() {
        this.comments.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        new NewProjectWizard();
        this.newProject = true;
    }

    void updateDesignationDisplay() {
        this.comments.updateDesignationComboBox();
    }

    void addDesignationItem(JMenu menu, String menuName, int keyEvent) {
        this.comments.addDesignationItem(menu, menuName, keyEvent);
    }

    void warnUserOfFilters() {
        JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.everything_is_filtered", "All bugs in this project appear to be filtered out.  \nYou may wish to check your filter settings in the preferences menu."), "Warning", 2);
    }

    void setSaveType(SaveType saveType) {
        if (DEBUG && this.saveType != saveType) {
            System.out.println("Changing save type from " + (Object)((Object)this.saveType) + " to " + (Object)((Object)saveType));
        }
        this.saveType = saveType;
    }

    SaveType getSaveType() {
        return this.saveType;
    }

    @Override
    public void showMessageDialogAndWait(final String message) throws InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(this, message);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(MainFrame.this, message);
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void showMessageDialog(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(this, message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(MainFrame.this, message);
                }
            });
        }
    }

    public int showConfirmDialog(String message, String title, int optionType) {
        return JOptionPane.showConfirmDialog(this, message, title, optionType);
    }

    @Override
    public int showConfirmDialog(String message, String title, String ok, String cancel) {
        return JOptionPane.showOptionDialog(this, message, title, 2, -1, null, new Object[]{ok, cancel}, ok);
    }

    void setProjectAndBugCollectionInSwingThread(Project project, BugCollection bc) {
        this.setProjectAndBugCollection(project, bc);
    }

    public Sortables[] getAvailableSortables() {
        ArrayList<Sortables> a = new ArrayList<Sortables>(Sortables.values().length);
        for (Sortables s : Sortables.values()) {
            if (!s.isAvailable(this)) continue;
            a.add(s);
        }
        Sortables[] sortables = new Sortables[a.size()];
        a.toArray(sortables);
        return sortables;
    }

    public Sortables[] sortables() {
        return Sortables.values();
    }

    @Override
    public InputStream getProgressMonitorInputStream(InputStream in, int length, String msg) {
        ProgressMonitorInputStream pmin = new ProgressMonitorInputStream(this, msg, in);
        ProgressMonitor pm = pmin.getProgressMonitor();
        if (length > 0) {
            pm.setMaximum(length);
        }
        return pmin;
    }

    public void showStatus(String msg) {
        this.guiLayout.setSourceTitle(msg);
    }

    @Override
    public void displayNonmodelMessage(String title, String message) {
        DisplayNonmodelMessage.displayNonmodelMessage(title, message, this, true);
    }

    public void displayCloudReport() {
        Cloud cloud = this.bugCollection.getCloud();
        if (cloud == null) {
            JOptionPane.showMessageDialog(this, "There is no cloud");
            return;
        }
        cloud.waitUntilIssueDataDownloaded();
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        cloud.printCloudSummary(writer, this.getDisplayedBugs(), this.viewFilter.getPackagePrefixes());
        writer.close();
        String report = stringWriter.toString();
        DisplayNonmodelMessage.displayNonmodelMessage("Cloud summary", report, this, false);
    }

    public Iterable<BugInstance> getDisplayedBugs() {
        return new Iterable<BugInstance>(){

            @Override
            public Iterator<BugInstance> iterator() {
                return new ShownBugsIterator();
            }
        };
    }

    @Override
    public String showQuestionDialog(String message, String title, String defaultValue) {
        return (String)JOptionPane.showInputDialog(this, message, title, 3, null, null, defaultValue);
    }

    @Override
    public List<String> showForm(String message, String title, List<IGuiCallback.FormItem> items) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)new JLabel(message), gbc);
        gbc.gridwidth = 1;
        for (IGuiCallback.FormItem item : items) {
            JTextField field;
            ++gbc.gridy;
            panel.add((Component)new JLabel(item.getLabel()), gbc);
            String defaultValue = item.getDefaultValue();
            if (item.getPossibleValues() != null) {
                DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
                JComboBox box = new JComboBox(model);
                item.setField(box);
                for (String possibleValue : item.getPossibleValues()) {
                    model.addElement(possibleValue);
                }
                if (defaultValue == null) {
                    model.setSelectedItem(model.getElementAt(0));
                } else {
                    model.setSelectedItem(defaultValue);
                }
                panel.add(box, gbc);
                continue;
            }
            JTextField jTextField = field = item.isPassword() ? new JPasswordField() : new JTextField();
            if (defaultValue != null) {
                field.setText(defaultValue);
            }
            item.setField(field);
            panel.add((Component)field, gbc);
        }
        int result = JOptionPane.showConfirmDialog(this, panel, title, 2);
        if (result != 0) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (IGuiCallback.FormItem item : items) {
            JComponent field = item.getField();
            if (field instanceof JTextComponent) {
                JTextComponent textComponent = (JTextComponent)field;
                results.add(textComponent.getText());
                continue;
            }
            if (!(field instanceof JComboBox)) continue;
            JComboBox box = (JComboBox)field;
            results.add((String)box.getSelectedItem());
        }
        return results;
    }

    @Override
    public boolean showDocument(URL u) {
        return LaunchBrowser.showDocument(u);
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    @Override
    public void invokeInGUIThread(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventQueueExecutor
    extends AbstractExecutorService {
        private EventQueueExecutor() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void execute(Runnable command) {
            if (SwingUtilities.isEventDispatchThread()) {
                command.run();
                return;
            }
            try {
                SwingUtilities.invokeAndWait(command);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShownBugsIterator
    implements Iterator<BugInstance> {
        Iterator<BugInstance> base;
        boolean nextKnown;
        BugInstance next;

        ShownBugsIterator() {
            this.base = MainFrame.this.bugCollection.getCollection().iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.nextKnown) {
                this.nextKnown = true;
                while (this.base.hasNext()) {
                    this.next = this.base.next();
                    if (!MainFrame.this.shouldDisplayIssue(this.next)) continue;
                    return true;
                }
                this.next = null;
                return false;
            }
            return this.next != null;
        }

        @Override
        public BugInstance next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BugInstance result = this.next;
            this.next = null;
            this.nextKnown = false;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class PasteAction
    extends TextAction {
        public PasteAction() {
            super(L10N.getLocalString("txt.paste", "Paste"));
        }

        public void actionPerformed(ActionEvent evt) {
            JTextComponent text = this.getTextComponent(evt);
            if (text == null) {
                return;
            }
            text.paste();
        }
    }

    static class CopyAction
    extends TextAction {
        public CopyAction() {
            super(L10N.getLocalString("txt.copy", "Copy"));
        }

        public void actionPerformed(ActionEvent evt) {
            JTextComponent text = this.getTextComponent(evt);
            if (text == null) {
                return;
            }
            text.copy();
        }
    }

    static class CutAction
    extends TextAction {
        public CutAction() {
            super(L10N.getLocalString("txt.cut", "Cut"));
        }

        public void actionPerformed(ActionEvent evt) {
            JTextComponent text = this.getTextComponent(evt);
            if (text == null) {
                return;
            }
            text.cut();
        }
    }

    private class BugSummaryMouseListener
    extends MouseAdapter {
        private final BugInstance bugInstance;
        private final JLabel label;
        private final SourceLineAnnotation note;

        BugSummaryMouseListener(@NonNull BugInstance bugInstance, @NonNull JLabel label, SourceLineAnnotation link) {
            this.bugInstance = bugInstance;
            this.label = label;
            this.note = link;
        }

        public void mouseClicked(MouseEvent e) {
            MainFrame.this.displayer.displaySource(this.bugInstance, this.note);
        }

        public void mouseEntered(MouseEvent e) {
            this.label.setForeground(Color.blue);
            MainFrame.this.setCursor(new Cursor(12));
        }

        public void mouseExited(MouseEvent e) {
            this.label.setForeground(Color.black);
            MainFrame.this.setCursor(new Cursor(0));
        }
    }

    private final class InitializeGUI
    implements Runnable {
        private InitializeGUI() {
        }

        public void run() {
            String loadFromURL;
            block17: {
                MainFrame.this.setTitle("FindBugs");
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Could not load Windows Look&Feel", e);
                    }
                }
                try {
                    MainFrame.this.guiLayout.initialize();
                }
                catch (Exception e) {
                    if (!UIManager.getLookAndFeel().getName().equals("Metal")) {
                        System.err.println("Exception caught initializing GUI; reverting to CrossPlatformLookAndFeel");
                        try {
                            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                        }
                        catch (Exception e2) {
                            System.err.println("Exception while setting CrossPlatformLookAndFeel: " + e2);
                            throw new Error(e2);
                        }
                        MainFrame.this.guiLayout.initialize();
                    }
                    throw new Error(e);
                }
                MainFrame.this.bugPopupMenu = MainFrame.this.createBugPopupMenu();
                MainFrame.this.branchPopupMenu = MainFrame.this.createBranchPopUpMenu();
                MainFrame.this.comments.loadPrevCommentsList(GUISaveState.getInstance().getPreviousComments().toArray(new String[GUISaveState.getInstance().getPreviousComments().size()]));
                MainFrame.this.updateStatusBar();
                MainFrame.this.setBounds(GUISaveState.getInstance().getFrameBounds());
                Toolkit.getDefaultToolkit().setDynamicLayout(true);
                MainFrame.this.setDefaultCloseOperation(0);
                MainFrame.this.setJMenuBar(MainFrame.this.createMainMenuBar());
                MainFrame.this.setVisible(true);
                MainFrame.this.saveOpenFileChooser = new FBFileChooser();
                MainFrame.this.saveOpenFileChooser.setFileSelectionMode(2);
                MainFrame.this.saveOpenFileChooser.setAcceptAllFileFilterUsed(false);
                MainFrame.this.saveOpenFileChooser.addChoosableFileFilter(FindBugsAnalysisFileFilter.INSTANCE);
                MainFrame.this.saveOpenFileChooser.addChoosableFileFilter(FindBugsFBPFileFilter.INSTANCE);
                MainFrame.this.saveOpenFileChooser.addChoosableFileFilter(FindBugsFBAFileFilter.INSTANCE);
                MainFrame.this.saveOpenFileChooser.setFileFilter(FindBugsAnalysisFileFilter.INSTANCE);
                MainFrame.this.filterOpenFileChooser = new FBFileChooser();
                MainFrame.this.filterOpenFileChooser.setFileSelectionMode(2);
                MainFrame.this.filterOpenFileChooser.setFileFilter(FindBugsFilterFileFilter.INSTANCE);
                JToolTip tempToolTip = MainFrame.this.tableheader.createToolTip();
                UIManager.put("ToolTip.font", new FontUIResource(tempToolTip.getFont().deriveFont(Driver.getFontSize())));
                if (MAC_OS_X) {
                    try {
                        MainFrame.this.osxAdapter = Class.forName("edu.umd.cs.findbugs.gui2.OSXAdapter");
                        Class[] defArgs = new Class[]{MainFrame.class};
                        Method registerMethod = MainFrame.this.osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                        if (registerMethod != null) {
                            registerMethod.invoke((Object)MainFrame.this.osxAdapter, MainFrame.this);
                        }
                        defArgs[0] = Boolean.TYPE;
                        MainFrame.this.osxPrefsEnableMethod = MainFrame.this.osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
                        MainFrame.this.enablePreferences(true);
                    }
                    catch (NoClassDefFoundError e) {
                        System.err.println("This version of Mac OS X does not support the Apple EAWT. Application Menu handling has been disabled (" + e + ")");
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("This version of Mac OS X does not support the Apple EAWT. Application Menu handling has been disabled (" + e + ")");
                    }
                    catch (Exception e) {
                        System.err.println("Exception while loading the OSXAdapter: " + e);
                        e.printStackTrace();
                        if (!DEBUG) break block17;
                        e.printStackTrace();
                    }
                }
            }
            if ((loadFromURL = SystemProperties.getOSDependentProperty("findbugs.loadBugsFromURL")) != null) {
                try {
                    loadFromURL = SystemProperties.rewriteURLAccordingToProperties(loadFromURL);
                    URL url = new URL(loadFromURL);
                    MainFrame.this.loadAnalysis(url);
                }
                catch (MalformedURLException e1) {
                    JOptionPane.showMessageDialog(MainFrame.this, "Error loading " + loadFromURL);
                }
            }
            MainFrame.this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    MainFrame.this.comments.resized();
                }
            });
            MainFrame.this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    if (MainFrame.this.comments.hasFocus()) {
                        MainFrame.this.setProjectChanged(true);
                    }
                    MainFrame.this.callOnClose();
                }
            });
            Driver.removeSplashScreen();
            MainFrame.this.mainFrameInitialized.countDown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BugCard {
        TREECARD,
        WAITCARD;

    }

    static class ProjectSelector {
        final String projectName;
        final String filter;
        final int count;

        public ProjectSelector(String projectName, String filter, int count) {
            this.projectName = projectName;
            this.filter = filter;
            this.count = count;
        }

        public String toString() {
            return String.format("%s -- [%d issues]", this.projectName, this.count);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SaveReturn {
        SAVE_SUCCESSFUL,
        SAVE_IO_EXCEPTION,
        SAVE_ERROR;

    }
}

