/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.FBDialog;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterFactory;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.PreferencesFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NewFilterFromBug
extends FBDialog {
    private HashMap<JCheckBox, Sortables> map = new HashMap();
    static List<NewFilterFromBug> listOfAllFrames = new ArrayList<NewFilterFromBug>();

    public NewFilterFromBug(final BugInstance bug) {
        this.setModal(true);
        listOfAllFrames.add(this);
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Filter out all bugs whose..."), "North");
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 1));
        for (Sortables s : MainFrame.getInstance().getAvailableSortables()) {
            if (s.equals(Sortables.DIVIDER)) continue;
            JCheckBox radio = new JCheckBox(s.toString() + " is " + s.formatValue(s.getFrom(bug)));
            this.map.put(radio, s);
            center.add(radio);
        }
        this.add((Component)center, "Center");
        JPanel south = new JPanel();
        JButton okButton = new JButton(L10N.getLocalString("dlg.ok_btn", "OK"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HashSet<Sortables> set = new HashSet<Sortables>();
                for (Map.Entry e : NewFilterFromBug.this.map.entrySet()) {
                    if (!((JCheckBox)e.getKey()).isSelected()) continue;
                    set.add((Sortables)e.getValue());
                }
                if (!set.isEmpty()) {
                    Matcher m = FilterFactory.makeMatcher(set, bug);
                    Filter f = MainFrame.getInstance().getProject().getSuppressionFilter();
                    f.addChild(m);
                    PreferencesFrame.getInstance().updateFilterPanel();
                    FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
                    NewFilterFromBug.this.dispose();
                }
            }
        });
        JButton cancelButton = new JButton(L10N.getLocalString("dlg.cancel_btn", "Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewFilterFromBug.this.dispose();
            }
        });
        Util.addOkAndCancelButtons(south, okButton, cancelButton);
        this.add((Component)south, "South");
        this.pack();
        this.setVisible(true);
    }

    static void closeAll() {
        for (NewFilterFromBug frame : listOfAllFrames) {
            frame.dispose();
        }
        listOfAllFrames.clear();
    }
}

