/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.CheckBoxList;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBDialog;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.FilterMatcher;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.NewFilterFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreeModel;

public class PreferencesFrame
extends FBDialog {
    private static int PROPERTIES_TAB = 0;
    private static int FILTERS_TAB = 1;
    private static int SUPPRESSIONS_TAB = 2;
    JTabbedPane mainTabPane;
    private static PreferencesFrame instance;
    private CheckBoxList filterCheckBoxList = new CheckBoxList();
    private JButton addButton;
    JButton removeButton;
    JButton removeAllButton;
    boolean frozen = false;
    private JTextField tabTextField;
    private JTextField fontTextField;
    private JTextField packagePrefixLengthTextField;
    private static int TAB_MIN;
    private static int TAB_MAX;
    private static int FONT_MIN;
    private static int FONT_MAX;

    public static PreferencesFrame getInstance() {
        if (instance == null) {
            instance = new PreferencesFrame();
        }
        return instance;
    }

    private PreferencesFrame() {
        this.setTitle(L10N.getLocalString("dlg.fil_sup_ttl", "Filters/Suppressions"));
        this.setModal(true);
        this.mainTabPane = new JTabbedPane();
        this.mainTabPane.add("Properties", this.createPropertiesPane());
        this.mainTabPane.add(L10N.getLocalString("pref.filters", "Filters"), this.createFilterPane());
        MainFrame.getInstance().updateStatusBar();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        top.add(Box.createHorizontalStrut(5));
        top.add(this.mainTabPane);
        top.add(Box.createHorizontalStrut(5));
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(new JButton(new AbstractAction(L10N.getLocalString("pref.close", "Close")){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.setVisible(false);
                TreeModel bt = MainFrame.getInstance().getTree().getModel();
                if (bt instanceof BugTreeModel) {
                    ((BugTreeModel)bt).checkSorter();
                }
                PreferencesFrame.this.resetPropertiesPane();
            }
        }));
        bottom.add(Box.createHorizontalStrut(5));
        this.add(Box.createVerticalStrut(5));
        this.add(top);
        this.add(Box.createVerticalStrut(5));
        this.add(bottom);
        this.add(Box.createVerticalStrut(5));
        this.setDefaultCloseOperation(1);
        this.pack();
    }

    private JPanel createPropertiesPane() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel mainPanel = new JPanel();
        float currFS = Driver.getFontSize();
        JPanel temp = new JPanel();
        temp.add(new JLabel("Tab size"));
        this.tabTextField = new JTextField(Integer.toString(GUISaveState.getInstance().getTabSize()));
        this.tabTextField.setPreferredSize(new Dimension((int)(currFS * 2.0f), (int)((double)currFS * 1.3)));
        temp.add(this.tabTextField);
        mainPanel.add(temp);
        mainPanel.add(Box.createVerticalStrut(5));
        temp = new JPanel();
        temp.add(new JLabel("Font size"));
        this.fontTextField = new JTextField(Float.toString(GUISaveState.getInstance().getFontSize()));
        this.fontTextField.setPreferredSize(new Dimension((int)(currFS * 3.0f), (int)((double)currFS * 1.3)));
        temp.add(this.fontTextField);
        mainPanel.add(temp);
        mainPanel.add(Box.createVerticalGlue());
        temp = new JPanel();
        temp.add(new JLabel("Package prefix length"));
        this.packagePrefixLengthTextField = new JTextField(Integer.toString(GUISaveState.getInstance().getPackagePrefixSegments()));
        this.packagePrefixLengthTextField.setPreferredSize(new Dimension((int)(currFS * 2.0f), (int)((double)currFS * 1.3)));
        temp.add(this.packagePrefixLengthTextField);
        mainPanel.add(temp);
        mainPanel.add(Box.createVerticalGlue());
        contentPanel.add((Component)mainPanel, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(new JButton(new AbstractAction("Apply"){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.changeTabSize();
                PreferencesFrame.this.changeFontSize();
                PreferencesFrame.this.changePackagePrefixLength();
            }
        }));
        bottomPanel.add(new JButton(new AbstractAction("Reset"){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.resetPropertiesPane();
            }
        }));
        contentPanel.add((Component)bottomPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowDeactivated(WindowEvent e) {
                PreferencesFrame.this.resetPropertiesPane();
            }
        });
        return contentPanel;
    }

    private void changeTabSize() {
        int tabSize = 0;
        try {
            tabSize = Integer.decode(this.tabTextField.getText());
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(instance, "Error in tab size field.", "Tab Size Error", 1);
            return;
        }
        if (tabSize < TAB_MIN || tabSize > TAB_MAX) {
            JOptionPane.showMessageDialog(instance, "Tab size exceedes range (" + TAB_MIN + " - " + TAB_MAX + ").", "Tab Size Excedes Range", 1);
            return;
        }
        if (tabSize != GUISaveState.getInstance().getTabSize()) {
            GUISaveState.getInstance().setTabSize(tabSize);
            MainFrame.getInstance().displayer.clearCache();
            MainFrame.getInstance().syncBugInformation();
        }
    }

    private void changeFontSize() {
        float fontSize = 0.0f;
        try {
            fontSize = Float.parseFloat(this.fontTextField.getText());
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(instance, "Error in font size field.", "Font Size Error", 1);
            return;
        }
        if (fontSize < (float)FONT_MIN || fontSize > (float)FONT_MAX) {
            JOptionPane.showMessageDialog(instance, "Font size exceedes range (" + FONT_MIN + " - " + FONT_MAX + ").", "Font Size Exceedes Range", 1);
            return;
        }
        if (fontSize != GUISaveState.getInstance().getFontSize()) {
            GUISaveState.getInstance().setFontSize(fontSize);
            JOptionPane.showMessageDialog(instance, "To implement the new font size please restart FindBugs.", "Changing Font", 1);
        }
    }

    private void changePackagePrefixLength() {
        int value = 0;
        try {
            value = Integer.parseInt(this.packagePrefixLengthTextField.getText());
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(instance, "Error in package prefix length field.", "Package Prefix Length Error", 1);
            return;
        }
        if (value < 1 || value > 12) {
            JOptionPane.showMessageDialog(instance, "package prefix length exceedes range (1 - 12).", "package prefix lengthe exceedes range", 1);
            return;
        }
        if (value != GUISaveState.getInstance().getPackagePrefixSegments()) {
            GUISaveState.getInstance().setPackagePrefixSegments(value);
            BugTreeModel bt = (BugTreeModel)MainFrame.getInstance().getTree().getModel();
            bt.needToRebuild();
            bt.checkSorter();
        }
    }

    private void resetPropertiesPane() {
        this.tabTextField.setText(Integer.toString(GUISaveState.getInstance().getTabSize()));
        this.fontTextField.setText(Float.toString(GUISaveState.getInstance().getFontSize()));
    }

    private JPanel createFilterPane() {
        this.addButton = new JButton(L10N.getLocalString("dlg.add_dot_btn", "Add..."));
        this.removeButton = new JButton(L10N.getLocalString("dlg.remove_btn", "Remove"));
        this.removeAllButton = new JButton(L10N.getLocalString("dlg.remove_all_btn", "Remove All"));
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 4;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        filterPanel.add((Component)new JScrollPane(this.filterCheckBoxList), gbc);
        this.updateFilterPanel();
        gbc.gridheight = 1;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        filterPanel.add((Component)this.addButton, gbc);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewFilterFrame.open();
            }
        });
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 0, 0, 0);
        filterPanel.add((Component)this.removeButton, gbc);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Object[] selected = PreferencesFrame.this.filterCheckBoxList.getSelectedValues();
                boolean needsRebuild = false;
                if (selected.length == 0) {
                    return;
                }
                for (Object o : selected) {
                    MatchBox box = (MatchBox)o;
                    if (MainFrame.getInstance().getProject().getSuppressionFilter().isEnabled(box.getMatcher())) {
                        needsRebuild = true;
                    }
                    MainFrame.getInstance().getProject().getSuppressionFilter().removeChild(box.getMatcher());
                }
                FilterActivity.notifyListeners(FilterListener.Action.UNFILTERING, null);
                MainFrame.getInstance().setProjectChanged(true);
                PreferencesFrame.this.updateFilterPanel();
            }
        });
        gbc.gridy = 2;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 0, 0, 0);
        filterPanel.add((Component)this.removeAllButton, gbc);
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boolean needsRebuild = false;
                Filter suppressionFilter = MainFrame.getInstance().getProject().getSuppressionFilter();
                if (!suppressionFilter.isEmpty()) {
                    needsRebuild = true;
                }
                suppressionFilter.clear();
                if (needsRebuild) {
                    FilterActivity.notifyListeners(FilterListener.Action.UNFILTERING, null);
                }
                MainFrame.getInstance().setProjectChanged(true);
                PreferencesFrame.this.updateFilterPanel();
            }
        });
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        filterPanel.add(Box.createGlue(), gbc);
        return filterPanel;
    }

    void updateFilterPanel() {
        ArrayList<MatchBox> boxes = new ArrayList<MatchBox>();
        final Filter f = MainFrame.getInstance().getProject().getSuppressionFilter();
        Iterator<Matcher> i = f.childIterator();
        while (i.hasNext()) {
            final Matcher m = i.next();
            MatchBox box = new MatchBox(m.toString(), m);
            box.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    boolean wasSelected;
                    boolean isSelected = ((JCheckBox)evt.getSource()).isSelected();
                    if (isSelected == (wasSelected = f.isEnabled(m))) {
                        return;
                    }
                    f.setEnabled(m, isSelected);
                    FilterActivity.notifyListeners(isSelected ? FilterListener.Action.FILTERING : FilterListener.Action.UNFILTERING, null);
                    MainFrame.getInstance().updateStatusBar();
                    MainFrame.getInstance().setProjectChanged(true);
                }
            });
            box.setSelected(f.isEnabled(m));
            boxes.add(box);
        }
        this.filterCheckBoxList.setListData(boxes.toArray(new MatchBox[boxes.size()]));
    }

    void freeze() {
        this.frozen = true;
        this.filterCheckBoxList.setEnabled(false);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    void thaw() {
        this.filterCheckBoxList.setEnabled(true);
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        this.frozen = false;
    }

    void setSelectedTab(int index) {
        if (index > 0 && index <= this.mainTabPane.getTabCount()) {
            this.mainTabPane.setSelectedIndex(index);
        }
    }

    static {
        TAB_MIN = 1;
        TAB_MAX = 20;
        FONT_MIN = 10;
        FONT_MAX = 99;
    }

    private static class FilterCheckBoxListener
    implements ItemListener {
        FilterMatcher filter;

        FilterCheckBoxListener(FilterMatcher filter) {
            this.filter = filter;
        }

        public void itemStateChanged(ItemEvent evt) {
            this.filter.setActive(((JCheckBox)evt.getSource()).isSelected());
            MainFrame.getInstance().updateStatusBar();
            MainFrame.getInstance().setProjectChanged(true);
        }
    }

    private static class UneditableTableModel
    extends DefaultTableModel {
        public UneditableTableModel(Object[][] tableData, String[] strings) {
            super(tableData, strings);
        }

        public boolean isCellEditable(int x, int y) {
            return false;
        }
    }

    private static class MatchBox
    extends JCheckBox {
        Matcher m;

        MatchBox(String text, Matcher m) {
            super(text);
            this.m = m;
        }

        Matcher getMatcher() {
            return this.m;
        }
    }
}

