/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.CheckBoxList;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBDialog;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class SorterDialog
extends FBDialog {
    private JTableHeader preview;
    private ArrayList<SortableCheckBox> checkBoxSortList = new ArrayList();
    JButton sortApply;

    public static SorterDialog getInstance() {
        return new SorterDialog();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ((SorterTableColumnModel)this.preview.getColumnModel()).createFrom(MainFrame.getInstance().getSorter());
            this.setSorterCheckBoxes();
        }
    }

    private SorterDialog() {
        this.setTitle("Sort By...");
        this.add(this.createSorterPane());
        this.pack();
        this.setLocationByPlatform(true);
        this.setResizable(false);
        this.preview.setColumnModel(new SorterTableColumnModel(MainFrame.getInstance().getSorter().getOrder()));
    }

    private JPanel createSorterPane() {
        JPanel sorter = new JPanel();
        JPanel insidePanel = new JPanel();
        insidePanel.setLayout(new BorderLayout());
        sorter.setLayout(new BorderLayout());
        this.preview = new JTableHeader();
        Sortables[] sortables = MainFrame.getInstance().getAvailableSortables();
        this.preview.setColumnModel(new SorterTableColumnModel(sortables));
        for (Sortables s : sortables) {
            this.checkBoxSortList.add(new SortableCheckBox(s));
        }
        this.setSorterCheckBoxes();
        insidePanel.add((Component)new CheckBoxList(this.checkBoxSortList.toArray(new JCheckBox[this.checkBoxSortList.size()])), "North");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JTable t = new JTable(new DefaultTableModel(0, sortables.length));
        t.setTableHeader(this.preview);
        JScrollPane sp = new JScrollPane(t);
        int num = (int)((double)Driver.getFontSize() * 1.2);
        sp.setPreferredSize(new Dimension(670, 10 + num));
        bottomPanel.add((Component)sp, "Center");
        insidePanel.add((Component)bottomPanel, "South");
        this.sortApply = new JButton(L10N.getLocalString("dlg.apply_btn", "Apply"));
        this.sortApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().getSorter().createFrom((SorterTableColumnModel)SorterDialog.this.preview.getColumnModel());
                ((BugTreeModel)MainFrame.getInstance().getTree().getModel()).checkSorter();
                SorterDialog.this.dispose();
            }
        });
        bottomPanel.add((Component)this.sortApply, "South");
        sorter.add((Component)new JScrollPane(insidePanel), "Center");
        return sorter;
    }

    private void setSorterCheckBoxes() {
        SorterTableColumnModel sorter = MainFrame.getInstance().getSorter();
        for (SortableCheckBox c : this.checkBoxSortList) {
            c.setSelected(sorter.isShown(c.sortable));
        }
    }

    void freeze() {
        this.sortApply.setEnabled(false);
    }

    void thaw() {
        this.sortApply.setEnabled(true);
    }

    class SortableCheckBox
    extends JCheckBox {
        final Sortables sortable;

        SortableCheckBox(Sortables s) {
            super(s == Sortables.DIVIDER ? L10N.getLocalString("sort.divider", "[divider]") : s.toString());
            this.sortable = s;
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    ((SorterTableColumnModel)SorterDialog.this.preview.getColumnModel()).setVisible(SortableCheckBox.this.sortable, SortableCheckBox.this.isSelected());
                }
            });
        }
    }
}

