/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.gui2.FindBugsLayoutManager;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class SplitLayout
implements FindBugsLayoutManager {
    final MainFrame frame;
    JLabel sourceTitle;
    JSplitPane topLeftSPane;
    JSplitPane topSPane;
    JSplitPane summarySPane;
    JSplitPane mainSPane;
    JButton viewSource = new JButton("View in browser");

    public SplitLayout(MainFrame frame) {
        this.frame = frame;
    }

    public JMenu createWindowMenu() {
        return null;
    }

    public void resetCommentsInputPane() {
        int position = this.topLeftSPane.getDividerLocation();
        this.topLeftSPane.setRightComponent(this.frame.createCommentsInputPanel());
        this.topLeftSPane.setDividerLocation(position);
    }

    public void initialize() {
        Font buttonFont = this.viewSource.getFont();
        this.viewSource.setFont(buttonFont.deriveFont(buttonFont.getSize() / 2));
        this.viewSource.setPreferredSize(new Dimension(150, 15));
        this.viewSource.setEnabled(false);
        this.topLeftSPane = new JSplitPane(0, this.frame.bugListPanel(), this.frame.createCommentsInputPanel());
        this.topLeftSPane.setOneTouchExpandable(true);
        this.topLeftSPane.setDividerLocation(GUISaveState.getInstance().getSplitTreeComments());
        this.removeSplitPaneBorders(this.topLeftSPane);
        JPanel sourceTitlePanel = new JPanel();
        sourceTitlePanel.setLayout(new BorderLayout());
        JPanel sourcePanel = new JPanel();
        BorderLayout sourcePanelLayout = new BorderLayout();
        sourcePanelLayout.setHgap(3);
        sourcePanelLayout.setVgap(3);
        sourcePanel.setLayout(sourcePanelLayout);
        this.sourceTitle = new JLabel();
        this.sourceTitle.setText(L10N.getLocalString("txt.source_listing", ""));
        sourceTitlePanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        sourceTitlePanel.add((Component)this.viewSource, "East");
        sourceTitlePanel.add((Component)this.sourceTitle, "Center");
        sourcePanel.setBorder(new LineBorder(Color.GRAY));
        sourcePanel.add((Component)sourceTitlePanel, "North");
        sourcePanel.add((Component)this.frame.createSourceCodePanel(), "Center");
        sourcePanel.add((Component)this.frame.createSourceSearchPanel(), "South");
        this.topSPane = new JSplitPane(1, this.topLeftSPane, sourcePanel);
        this.topSPane.setOneTouchExpandable(true);
        this.topSPane.setDividerLocation(GUISaveState.getInstance().getSplitTop());
        this.removeSplitPaneBorders(this.topSPane);
        this.summarySPane = this.frame.summaryTab();
        this.mainSPane = new JSplitPane(0, this.topSPane, this.summarySPane);
        this.mainSPane.setOneTouchExpandable(true);
        this.mainSPane.setDividerLocation(GUISaveState.getInstance().getSplitMain());
        this.removeSplitPaneBorders(this.mainSPane);
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)this.mainSPane, "Center");
        this.frame.add((Component)this.frame.statusBar(), "South");
    }

    private void removeSplitPaneBorders(JSplitPane pane) {
        pane.setUI(new BasicSplitPaneUI(){

            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    public void setBorder(Border b) {
                    }
                };
            }
        });
        pane.setBorder(new EmptyBorder(3, 3, 3, 3));
    }

    public void makeCommentsVisible() {
    }

    public void makeSourceVisible() {
    }

    public void saveState() {
        GUISaveState.getInstance().setSplitTreeComments(this.topLeftSPane.getDividerLocation());
        GUISaveState.getInstance().setSplitTop(this.topSPane.getDividerLocation());
        GUISaveState.getInstance().setSplitSummary(this.summarySPane.getDividerLocation());
        GUISaveState.getInstance().setSplitMain(this.mainSPane.getDividerLocation());
    }

    public void setSourceTitle(String title) {
        this.sourceTitle.setText(title);
    }

    public JComponent getSourceViewComponent() {
        return this.viewSource;
    }
}

