/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multiset<K> {
    final Map<K, Integer> map;

    public Multiset() {
        this.map = new HashMap<K, Integer>();
    }

    public Multiset(Map<K, Integer> map) {
        this.map = map;
    }

    public Multiset(Multiset<K> mset) {
        this.map = new HashMap<K, Integer>(mset.map);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int numKeys() {
        return this.map.size();
    }

    public void add(K k) {
        this.add(k, 1);
    }

    public boolean remove(K k) {
        Integer v = this.map.get(k);
        if (v == null || v == 0) {
            return false;
        }
        if (v == 1) {
            this.map.remove(k);
            return true;
        }
        this.map.put(k, v - 1);
        return true;
    }

    public void add(K k, int val) {
        Integer v = this.map.get(k);
        if (v == null) {
            this.map.put(k, val);
        } else {
            this.map.put(k, v + val);
        }
    }

    public void addAll(Iterable<K> c) {
        for (K k : c) {
            this.add(k);
        }
    }

    public int getCount(K k) {
        Integer v = this.map.get(k);
        if (v == null) {
            return 0;
        }
        return v;
    }

    public Iterable<Map.Entry<K, Integer>> entrySet() {
        return this.map.entrySet();
    }

    public Set<K> uniqueKeys() {
        return this.map.keySet();
    }

    public Iterable<Map.Entry<K, Integer>> entriesInDecreasingFrequency() {
        TreeSet<Map.Entry<K, Integer>> result = new TreeSet<Map.Entry<K, Integer>>(new EntryComparator());
        result.addAll(this.map.entrySet());
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntryComparator<E>
    implements Comparator<Map.Entry<E, Integer>>,
    Serializable {
        EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<E, Integer> o1, Map.Entry<E, Integer> o2) {
            int c2;
            int c1 = o1.getValue();
            if (c1 < (c2 = o2.getValue().intValue())) {
                return 1;
            }
            if (c1 > c2) {
                return -1;
            }
            return System.identityHashCode(o1.getKey()) - System.identityHashCode(o2.getKey());
        }
    }
}

