/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFinder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.DocumentException;

public class CopyBuggySource {
    private static final String USAGE = "Usage: <cmd>   <bugs.xml> <destinationSrcDir>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws IOException, DocumentException {
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        if (args.length != 2) {
            System.out.println(USAGE);
            return;
        }
        SortedBugCollection origCollection = new SortedBugCollection();
        origCollection.readXML(args[0]);
        File src = new File(args[1]);
        byte[] buf = new byte[4096];
        if (!src.isDirectory()) {
            throw new IllegalArgumentException(args[1] + " is not a source directory");
        }
        Project project = origCollection.getProject();
        SourceFinder sourceFinder = new SourceFinder(project);
        HashSet<String> copied = new HashSet<String>();
        HashSet<String> couldNotCreate = new HashSet<String>();
        for (BugInstance bug : origCollection.getCollection()) {
            Iterator<BugAnnotation> i = bug.annotationIterator();
            while (i.hasNext()) {
                FileOutputStream out;
                InputStream in;
                File file;
                block16: {
                    SourceLineAnnotation sourceAnnotation;
                    BugAnnotation ann = i.next();
                    if (ann instanceof BugAnnotationWithSourceLines) {
                        sourceAnnotation = ((BugAnnotationWithSourceLines)ann).getSourceLines();
                    } else {
                        if (!(ann instanceof SourceLineAnnotation)) continue;
                        sourceAnnotation = (SourceLineAnnotation)ann;
                    }
                    if (sourceAnnotation == null || sourceAnnotation.isUnknown()) continue;
                    String packageName = sourceAnnotation.getPackageName();
                    String sourceFile = sourceAnnotation.getSourceFile();
                    String fullName = packageName == "" ? sourceFile : packageName.replace('.', File.separatorChar) + File.separatorChar + sourceFile;
                    if (!copied.add(fullName)) continue;
                    file = new File(src, fullName);
                    if (file.exists()) {
                        System.out.println(file + " already exists");
                        continue;
                    }
                    File parent = file.getParentFile();
                    in = null;
                    out = null;
                    in = sourceFinder.openSource(packageName, sourceFile);
                    if (parent.mkdirs() || parent.isDirectory()) break block16;
                    String path = parent.getPath();
                    if (couldNotCreate.add(path)) {
                        System.out.println("Can't to create directory for " + path);
                    }
                    in.close();
                    CopyBuggySource.close(in);
                    CopyBuggySource.close(out);
                    continue;
                }
                try {
                    int sz;
                    out = new FileOutputStream(file);
                    while ((sz = in.read(buf)) >= 0) {
                        ((OutputStream)out).write(buf, 0, sz);
                    }
                    System.out.println("Copied " + file);
                }
                catch (FileNotFoundException e) {
                    System.out.println("Did not find " + file);
                    CopyBuggySource.close(in);
                    CopyBuggySource.close(out);
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Problem copying " + file);
                    e.printStackTrace(System.out);
                    {
                        catch (Throwable throwable) {
                            CopyBuggySource.close(in);
                            CopyBuggySource.close(out);
                            throw throwable;
                        }
                    }
                    CopyBuggySource.close(in);
                    CopyBuggySource.close(out);
                    continue;
                }
                CopyBuggySource.close(in);
                CopyBuggySource.close(out);
            }
        }
    }

    public static void close(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

