/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.dom4j.DocumentException;

public class ListBugDatabaseInfo {
    private static final String USAGE = "Usage: " + ListBugDatabaseInfo.class.getName() + " [options] data1File data2File data3File ... ";

    public static void main(String[] args) throws IOException, DocumentException {
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        ListBugDatabaseInfoCommandLine commandLine = new ListBugDatabaseInfoCommandLine();
        int argCount = commandLine.parse(args, 0, Integer.MAX_VALUE, USAGE);
        PrintWriter out = new PrintWriter(System.out);
        if (argCount == args.length) {
            ListBugDatabaseInfo.listVersion(out, null, commandLine.formatDates);
        } else {
            out.println("version\ttime\tclasses\tNCSS\ttotal\thigh\tmedium\tlow\tfile");
            while (argCount < args.length) {
                String fileName = args[argCount++];
                ListBugDatabaseInfo.listVersion(out, fileName, commandLine.formatDates);
            }
        }
        out.close();
    }

    private static void listVersion(PrintWriter out, @CheckForNull String fileName, boolean formatDates) throws IOException, DocumentException {
        SortedBugCollection origCollection = new SortedBugCollection();
        if (fileName == null) {
            origCollection.readXML(System.in);
        } else {
            origCollection.readXML(fileName);
        }
        AppVersion appVersion = origCollection.getCurrentAppVersion();
        ProjectStats stats = origCollection.getProjectStats();
        out.print(appVersion.getReleaseName());
        out.print('\t');
        if (formatDates) {
            out.print("\"" + new Date(appVersion.getTimestamp()) + "\"");
        } else {
            out.print(appVersion.getTimestamp());
        }
        out.print('\t');
        out.print(appVersion.getNumClasses());
        out.print('\t');
        out.print(appVersion.getCodeSize());
        out.print('\t');
        out.print(stats.getTotalBugs());
        out.print('\t');
        out.print(stats.getBugsOfPriority(1));
        out.print('\t');
        out.print(stats.getBugsOfPriority(2));
        out.print('\t');
        out.print(stats.getBugsOfPriority(3));
        if (fileName != null) {
            out.print('\t');
            out.print(fileName);
        }
        out.println();
    }

    static class ListBugDatabaseInfoCommandLine
    extends CommandLine {
        boolean formatDates = false;

        ListBugDatabaseInfoCommandLine() {
            this.addSwitch("-formatDates", "render dates in textual form");
        }

        public void handleOption(String option, String optionalExtraPart) {
            if (!option.equals("-formatDates")) {
                throw new IllegalArgumentException("unknown option: " + option);
            }
            this.formatDates = true;
        }

        public void handleOptionWithArgument(String option, String argument) {
            throw new IllegalArgumentException("unknown option: " + option);
        }
    }
}

