/*
 * Decompiled with CFR 0.152.
 */
package com.zanox.hudson.plugins;

import com.zanox.hudson.plugins.Entry;
import com.zanox.hudson.plugins.EntryCopier;
import com.zanox.hudson.plugins.FTPPublisher;
import com.zanox.hudson.plugins.FTPSite;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPPublisher
extends Notifier {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    protected static final SimpleDateFormat ID_FORMATTER = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private String siteName;
    private final List<Entry> entries = new ArrayList();
    private Boolean useTimestamps = false;
    private Boolean flatten = true;

    public void setUseTimestamps(boolean useTimestamps) {
        this.useTimestamps = useTimestamps;
    }

    public boolean isUseTimestamps() {
        return this.useTimestamps;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public FTPPublisher() {
        int a = 2;
    }

    public FTPPublisher(String siteName) {
        this.siteName = siteName;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public FTPSite getSite() {
        FTPSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (FTPSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() == Result.FAILURE || build.getResult() == Result.ABORTED) {
            return true;
        }
        FTPSite ftpsite = null;
        try {
            ftpsite = this.getSite();
            listener.getLogger().println("Connecting to " + ftpsite.getHostname());
            ftpsite.createSession();
            EntryCopier copier = new EntryCopier(build, listener, ftpsite, this.flatten.booleanValue(), this.useTimestamps.booleanValue());
            int copied = 0;
            for (Entry e : this.entries) {
                copied += copier.copy(e);
            }
            listener.getLogger().println("Transfered " + copied + " files.");
        }
        catch (Throwable th) {
            th.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
        }
        finally {
            if (ftpsite != null) {
                ftpsite.closeSession();
            }
        }
        return true;
    }
}

