/*
 * Decompiled with CFR 0.152.
 */
package com.zanox.hudson.plugins;

import com.jcraft.jsch.SftpException;
import com.zanox.hudson.plugins.Entry;
import com.zanox.hudson.plugins.FTPSite;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryCopier {
    protected static final SimpleDateFormat ID_FORMATTER = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private AbstractBuild<?, ?> build;
    private BuildListener listener;
    private Map<String, String> envVars;
    private URI workSpaceDir;
    private FTPSite ftpSite;
    private boolean flatten;
    private boolean useTimestamps;

    public EntryCopier(AbstractBuild<?, ?> build, BuildListener listener, FTPSite ftpSite, boolean flatten, boolean useTimestamps) throws IOException, InterruptedException {
        this.build = build;
        this.listener = listener;
        this.ftpSite = ftpSite;
        this.envVars = build.getEnvironment((TaskListener)listener);
        this.workSpaceDir = build.getWorkspace().toURI().normalize();
        this.flatten = flatten;
        this.useTimestamps = useTimestamps;
    }

    public int copy(Entry entry) throws IOException, SftpException, InterruptedException {
        String expanded = Util.replaceMacro((String)entry.sourceFile, this.envVars);
        FilePath[] sourceFiles = null;
        String baseSourceDir = this.workSpaceDir.getPath();
        FilePath tmp = new FilePath(this.build.getWorkspace(), expanded);
        if (tmp.exists() && tmp.isDirectory()) {
            sourceFiles = tmp.list("**/*");
            baseSourceDir = tmp.toURI().normalize().getPath();
            this.listener.getLogger().println("Preparing to copy directory : " + baseSourceDir);
        } else {
            sourceFiles = this.build.getWorkspace().list(expanded);
            baseSourceDir = this.workSpaceDir.getPath();
            this.listener.getLogger().println(this.workSpaceDir);
        }
        if (sourceFiles.length == 0) {
            this.listener.getLogger().println("No file(s) found: " + expanded);
            return 0;
        }
        int fileCount = 0;
        String subRoot = Util.replaceMacro((String)entry.filePath, this.envVars);
        if (this.useTimestamps) {
            subRoot = subRoot + "/" + ID_FORMATTER.format(this.build.getTimestamp().getTime());
        }
        this.ftpSite.changedToProjectRootDir("", this.listener.getLogger());
        this.ftpSite.mkdirs(subRoot, this.listener.getLogger());
        for (FilePath sourceFile : sourceFiles) {
            this.copyFile(sourceFile, subRoot, baseSourceDir);
            ++fileCount;
        }
        this.listener.getLogger().println("transferred " + fileCount + " files to " + subRoot);
        return fileCount;
    }

    public void copyFile(FilePath sourceFile, String destDir, String baseSourceDir) throws IOException, SftpException, InterruptedException {
        this.ftpCdMkdirs(sourceFile, destDir, baseSourceDir);
        this.ftpSite.upload(sourceFile, this.envVars, this.listener.getLogger());
    }

    private void ftpCdMkdirs(FilePath sourceFile, String entryRootFolder, String baseSourceDir) throws IOException, SftpException, InterruptedException {
        String relativeSourcePath = this.getRelativeToCopyBaseDirectory(baseSourceDir, sourceFile);
        this.ftpSite.changedToProjectRootDir(entryRootFolder, this.listener.getLogger());
        if (!this.flatten) {
            this.ftpSite.mkdirs(relativeSourcePath, this.listener.getLogger());
        }
    }

    private String getRelativeToCopyBaseDirectory(String baseDir, FilePath sourceFile) throws IOException, InterruptedException {
        URI sourceFileURI = sourceFile.toURI().normalize();
        String relativeSourceFile = sourceFileURI.getPath().replaceFirst(baseDir, "");
        int lastSlashIndex = relativeSourceFile.lastIndexOf("/");
        if (lastSlashIndex == -1) {
            return ".";
        }
        return relativeSourceFile.substring(0, lastSlashIndex);
    }
}

