/*
 * Decompiled with CFR 0.152.
 */
package com.zanox.hudson.plugins;

import com.zanox.hudson.plugins.Entry;
import com.zanox.hudson.plugins.EntryCopier;
import com.zanox.hudson.plugins.FTPSite;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPPublisher
extends Notifier {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    protected static final SimpleDateFormat ID_FORMATTER = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private String siteName;
    private final List<Entry> entries = new ArrayList<Entry>();
    private Boolean useTimestamps = false;
    private Boolean flatten = true;

    public void setUseTimestamps(boolean useTimestamps) {
        this.useTimestamps = useTimestamps;
    }

    public boolean isUseTimestamps() {
        return this.useTimestamps;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public FTPPublisher() {
        int a = 2;
    }

    public FTPPublisher(String siteName) {
        this.siteName = siteName;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public FTPSite getSite() {
        FTPSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (FTPSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() == Result.FAILURE || build.getResult() == Result.ABORTED) {
            return true;
        }
        FTPSite ftpsite = null;
        try {
            ftpsite = this.getSite();
            listener.getLogger().println("Connecting to " + ftpsite.getHostname());
            ftpsite.createSession();
            EntryCopier copier = new EntryCopier(build, listener, ftpsite, this.flatten, this.useTimestamps);
            int copied = 0;
            for (Entry e : this.entries) {
                copied += copier.copy(e);
            }
            listener.getLogger().println("Transfered " + copied + " files.");
        }
        catch (Throwable th) {
            th.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
        }
        finally {
            if (ftpsite != null) {
                ftpsite.closeSession();
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private final CopyOnWriteList<FTPSite> sites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(FTPPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Publish artifacts to FTP";
        }

        public String getHelpFile() {
            return "/plugin/ftppublisher/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) {
            FTPPublisher pub = new FTPPublisher();
            pub.setFlatten(formData.getBoolean("flatten"));
            pub.setUseTimestamps(formData.getBoolean("useTimestamps"));
            req.bindParameters((Object)pub, "publisher.");
            req.bindParameters((Object)pub, "ftp.");
            pub.getEntries().addAll(req.bindParametersToList(Entry.class, "ftp.entry."));
            return pub;
        }

        public FTPSite[] getSites() {
            Iterator it = this.sites.iterator();
            int size = 0;
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return (FTPSite[])this.sites.toArray((Object[])new FTPSite[size]);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.sites.replaceBy((Collection)req.bindParametersToList(FTPSite.class, "ftp."));
            this.save();
            return true;
        }

        public FormValidation doLoginCheck(StaplerRequest request) {
            String hostname = Util.fixEmpty((String)request.getParameter("hostname"));
            if (hostname == null) {
                return FormValidation.ok();
            }
            FTPSite site = new FTPSite(hostname, request.getParameter("port"), request.getParameter("timeOut"), request.getParameter("user"), request.getParameter("pass"));
            site.setFtpDir(request.getParameter("ftpDir"));
            try {
                site.createSession();
                site.closeSession();
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

