/*
 * Decompiled with CFR 0.152.
 */
package com.zanox.hudson.plugins;

import com.jcraft.jsch.SftpException;
import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPSite {
    private static final int DEFAULT_FTP_PORT = 21;
    private String hostname;
    private int timeOut;
    private int port;
    private String username;
    private String password;
    private String ftpDir = "/";
    private FTPClient ftpClient;

    public FTPSite() {
    }

    public FTPSite(String hostname, int port, int timeOut, String username, String password, String ftpDir) {
        this.hostname = hostname;
        this.port = port;
        this.timeOut = timeOut;
        this.username = username;
        this.password = password;
        this.ftpDir = ftpDir;
    }

    public FTPSite(String hostname, String port, String timeOut, String username, String password) {
        this.hostname = hostname;
        try {
            this.port = Integer.parseInt(port);
            this.timeOut = Integer.parseInt(timeOut);
        }
        catch (Exception e) {
            this.port = 21;
        }
        this.username = username;
        this.password = password;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return "" + this.port;
    }

    public void setPort(String port) {
        if (port != null) {
            try {
                this.port = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                this.port = 21;
            }
        } else {
            this.port = 21;
        }
    }

    public int getIntegerPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFtpDir() {
        return this.ftpDir;
    }

    public void setFtpDir(String rootRepositoryPath) {
        this.ftpDir = rootRepositoryPath;
    }

    public String getName() {
        return this.hostname;
    }

    public void createSession() throws IOException {
        this.ftpClient = new FTPClient();
        this.ftpClient.setDefaultTimeout(this.timeOut);
        this.ftpClient.connect(this.hostname, this.port);
        this.ftpClient.login(this.username, this.password);
        this.ftpClient.setFileType(2);
        if (!this.ftpClient.changeWorkingDirectory(this.ftpDir)) {
            throw new IOException("Can't connect/access FTP directory:" + this.ftpDir);
        }
    }

    public void closeSession() {
        if (this.ftpClient != null) {
            try {
                this.ftpClient.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.ftpClient = null;
        }
    }

    public void changedToProjectRootDir(String projectRootDir, PrintStream logger) throws IOException {
        if (!this.ftpClient.changeWorkingDirectory("/" + this.ftpDir + "/" + projectRootDir)) {
            logger.println("error by changing into the " + this.ftpDir + "/" + projectRootDir);
        }
        logger.println("current root dir " + this.ftpClient.printWorkingDirectory());
    }

    public void upload(FilePath filePath, Map<String, String> envVars, PrintStream logger) throws IOException, InterruptedException, SftpException {
        if (this.ftpClient == null) {
            throw new IOException("Connection to " + this.hostname + ", user=" + this.username + " is not established");
        }
        if (filePath.isDirectory()) {
            FilePath[] subfiles = filePath.list("**/*");
            if (subfiles != null) {
                for (int i = 0; i < subfiles.length; ++i) {
                    this.upload(subfiles[i], envVars, logger);
                }
            }
        } else {
            String localfilename = filePath.getName();
            InputStream in = filePath.read();
            this.ftpClient.storeFile(localfilename, in);
            in.close();
        }
    }

    public void mkdirs(String filePath, PrintStream logger) throws SftpException, IOException {
        String[] pathnames = filePath.split("/");
        String curdir = this.ftpDir;
        if (pathnames != null) {
            for (int i = 0; i < pathnames.length; ++i) {
                if (pathnames[i].length() == 0) continue;
                if (!this.ftpClient.changeWorkingDirectory(curdir + "/" + pathnames[i])) {
                    this.ftpClient.mkd(pathnames[i]);
                }
                curdir = curdir + "/" + pathnames[i];
                this.ftpClient.changeWorkingDirectory(pathnames[i]);
            }
        }
    }
}

