/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gant;

import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.plugins.gant.GantInstallation;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gant
extends Builder {
    private final String targets;
    private final String gantName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public Gant(String targets, String gantName) {
        this.targets = targets;
        this.gantName = gantName;
    }

    public String getTargets() {
        return this.targets;
    }

    public GantInstallation getGant() {
        for (GantInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.gantName == null || !i.getName().equals(this.gantName)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        Project proj = (Project)build.getProject();
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execName = launcher.isUnix() ? "gant" : "gant.bat";
        String normalizedTarget = this.targets.replaceAll("[\t\r\n]+", " ");
        GantInstallation ai = this.getGant();
        if (ai == null) {
            args.add(execName);
        } else {
            File exec = ai.getExecutable();
            if (!ai.getExists()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        }
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized(normalizedTarget);
        Map env = build.getEnvVars();
        if (ai != null) {
            env.put("GROOVY_HOME", ai.getGroovyHome());
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        try {
            int r = launcher.launch(args.toCommandArray(), env, (OutputStream)listener.getLogger(), proj.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        private volatile GantInstallation[] installations = new GantInstallation[0];

        private DescriptorImpl() {
            super(Gant.class);
            this.load();
        }

        public String getHelpFile() {
            return "/plugin/gant/help.html";
        }

        public String getDisplayName() {
            return "Invoke Gant script";
        }

        public GantInstallation[] getInstallations() {
            return this.installations;
        }

        public boolean configure(StaplerRequest req) {
            this.installations = req.bindParametersToList(GantInstallation.class, "gant.").toArray(new GantInstallation[0]);
            this.save();
            return true;
        }

        public void doCheckGroovyHome(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                public void check() throws IOException, ServletException {
                    File f = this.getFileParameter("value");
                    if (!f.isDirectory()) {
                        this.error(f + " is not a directory");
                        return;
                    }
                    if (!new File(f, "bin/groovy").exists() && !new File(f, "bin/groovy.bat").exists()) {
                        this.error(f + " doesn't look like a Groovy directory");
                        return;
                    }
                    if (!new File(f, "bin/gant").exists() && !new File(f, "bin/gant.bat").exists()) {
                        this.error(f + " looks like a Groovy but Gant is not found in here");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }
    }
}

