/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gant;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.gant.Gant;
import hudson.plugins.gant.GantInstallation;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gant
extends Builder {
    private final String targets;
    private final String gantName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl(null);

    @DataBoundConstructor
    public Gant(String targets, String gantName) {
        this.targets = targets;
        this.gantName = gantName;
    }

    public String getTargets() {
        return this.targets;
    }

    public GantInstallation getGant() {
        for (GantInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.gantName == null || !i.getName().equals(this.gantName)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execName = launcher.isUnix() ? "gant" : "gant.bat";
        String normalizedTarget = this.targets.replaceAll("[\t\r\n]+", " ");
        GantInstallation ai = this.getGant();
        if (ai == null) {
            args.add(execName);
        } else {
            File exec = ai.getExecutable();
            if (!ai.getExists()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        }
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized(normalizedTarget);
        EnvVars env = build.getEnvironment((TaskListener)listener);
        if (ai != null) {
            env.put("GROOVY_HOME", ai.getGroovyHome());
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        try {
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)listener.getLogger()).pwd(build.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }
}

