/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gerrit.ssh;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.IgnoreHostKeyVerification;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.io.File;
import java.io.IOException;

public class SSHMarker {
    private SshClient client = null;

    public void connect(String host, int port) throws IOException {
        SshClient client = new SshClient();
        client.connect(host, port, (HostKeyVerification)new IgnoreHostKeyVerification());
        this.client = client;
    }

    public void authenticate(String username, File private_key_file, String passPhrase) throws IOException {
        assert (this.client != null);
        PublicKeyAuthenticationClient pk = new PublicKeyAuthenticationClient();
        pk.setUsername(username);
        SshPrivateKeyFile file = SshPrivateKeyFile.parse((File)private_key_file);
        SshPrivateKey key = file.toPrivateKey(passPhrase);
        pk.setKey(key);
        this.client.authenticate((SshAuthenticationClient)pk);
    }

    public static boolean IsPrivateKeyFileValid(File f) {
        SshPrivateKeyFile file;
        try {
            file = SshPrivateKeyFile.parse((File)f);
        }
        catch (IOException e) {
            return false;
        }
        return file != null;
    }

    public static boolean CheckPassPhrase(File f, String p) {
        SshPrivateKeyFile file;
        try {
            file = SshPrivateKeyFile.parse((File)f);
        }
        catch (IOException e) {
            return false;
        }
        try {
            SshPrivateKey key = file.toPrivateKey(p);
        }
        catch (InvalidSshKeyException e) {
            return false;
        }
        return true;
    }

    public void executeCommand(String command) throws IOException, InterruptedException {
        assert (this.client != null);
        SessionChannelClient session = this.client.openSessionChannel();
        session.executeCommand(command);
        session.setLocalEOF();
        while (!session.isRemoteEOF()) {
            Thread.sleep(10L);
        }
        session.close();
    }

    public void disconnect() {
        assert (this.client != null);
        this.client.disconnect();
    }
}

