/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gerrit;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.gerrit.git.GitTools;
import hudson.plugins.gerrit.ssh.SSHMarker;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GerritNotifier
extends Notifier
implements Serializable {
    private final String git_home;
    private final String gerrit_host;
    private final int gerrit_port;
    private final String gerrit_username;
    private final String approve_value;
    private final String unstable_value;
    private final String reject_value;
    private final String gerrit_approve_command = "gerrit approve --verified=%s --message=\"%s\" %s";
    protected static final String NO_BUILD_URL = "No build url.";
    private final String private_key_file_path;
    private final String passPhrase;
    transient SSHMarker marker;
    transient GitTools git;

    public void setMarker(SSHMarker marker) {
        this.marker = marker;
    }

    public void setGitTools(GitTools git) {
        this.git = git;
    }

    public String getGerrit_host() {
        return this.gerrit_host;
    }

    public int getGerrit_port() {
        return this.gerrit_port;
    }

    public String getGerrit_username() {
        return this.gerrit_username;
    }

    public String getApprove_value() {
        return this.approve_value;
    }

    public String getUnstable_value() {
        return this.unstable_value;
    }

    public String getReject_value() {
        return this.reject_value;
    }

    public String getGerrit_approve_command() {
        return "gerrit approve --verified=%s --message=\"%s\" %s";
    }

    public String getPrivate_key_file_path() {
        return this.private_key_file_path;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    @DataBoundConstructor
    public GerritNotifier(String git_home, String gerrit_host, int gerrit_port, String gerrit_username, String approve_value, String unstable_value, String reject_value, String private_key_file_path, String passPhrase) {
        this.git_home = git_home;
        this.gerrit_host = gerrit_host;
        this.gerrit_port = gerrit_port;
        this.gerrit_username = gerrit_username;
        this.approve_value = approve_value;
        this.unstable_value = unstable_value;
        this.reject_value = reject_value;
        this.private_key_file_path = private_key_file_path;
        this.passPhrase = passPhrase;
        this.marker = new SSHMarker();
        this.git = new GitTools();
    }

    public String getGit_home() {
        return this.git_home;
    }

    public String generateComment(String verify_value, String message, String revision) {
        return String.format("gerrit approve --verified=%s --message=\"%s\" %s", verify_value, message, revision);
    }

    public String generateApproveCommand(String jobUrl, String revision) {
        return this.generateComment(this.approve_value, jobUrl, revision);
    }

    public String generateUnstableCommand(String jobUrl, String revision) {
        return this.generateComment(this.unstable_value, "Build is unstable " + jobUrl, revision);
    }

    public String generateFailedCommand(String jobUrl, String revision) {
        return this.generateComment(this.reject_value, "Build failed " + jobUrl, revision);
    }

    public String generateDidNotFinishCommand(String jobUrl, String revision) {
        return this.generateComment("0", "Build did not finish, " + jobUrl, revision);
    }

    private void verifyGerrit(String message) throws IOException, InterruptedException {
        File privateKeyFile = new File(this.private_key_file_path);
        this.marker.connect(this.gerrit_host, this.gerrit_port);
        this.marker.authenticate(this.gerrit_username, privateKeyFile, this.passPhrase);
        this.marker.executeCommand(message);
        this.marker.disconnect();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        FilePath ws = build.getWorkspace();
        if (this.marker == null) {
            this.marker = new SSHMarker();
        }
        String head = (String)ws.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

            public String invoke(File workspace, VirtualChannel channel) throws IOException {
                if (GerritNotifier.this.git == null) {
                    GerritNotifier.this.git = new GitTools();
                }
                return GerritNotifier.this.git.getHead(workspace, GerritNotifier.this.git_home).name();
            }
        });
        try {
            Result r = build.getResult();
            String buildUrl = this.getBuildUrl(build, listener);
            if (r == Result.ABORTED || r == Result.NOT_BUILT) {
                listener.getLogger().println("Build was aborted, notifying gerrit");
                this.verifyGerrit(this.generateDidNotFinishCommand(buildUrl, head));
            } else if (r.isBetterOrEqualTo(Result.SUCCESS)) {
                listener.getLogger().println("Approving " + head);
                this.verifyGerrit(this.generateApproveCommand(buildUrl, head));
            } else if (r.isBetterOrEqualTo(Result.UNSTABLE)) {
                listener.getLogger().println("Rejecting unstable " + head);
                this.verifyGerrit(this.generateUnstableCommand(buildUrl, head));
            } else {
                listener.getLogger().println("Rejecting failed " + head);
                this.verifyGerrit(this.generateFailedCommand(buildUrl, head));
            }
        }
        catch (IOException e) {
            listener.getLogger().println(e.getMessage());
            e.printStackTrace(listener.getLogger());
            build.setResult(Result.ABORTED);
            return false;
        }
        catch (InterruptedException e) {
            listener.getLogger().println("Interrupted: " + e.getMessage());
            build.setResult(Result.ABORTED);
        }
        return true;
    }

    String getBuildUrl(AbstractBuild build, BuildListener listener) throws IOException {
        EnvVars vars = null;
        try {
            vars = build.getEnvironment((TaskListener)listener);
        }
        catch (InterruptedException e) {
            listener.getLogger().println(e.getMessage());
            e.printStackTrace();
            return NO_BUILD_URL;
        }
        String buildUrl = NO_BUILD_URL;
        if (vars.containsKey((Object)"BUILD_URL")) {
            buildUrl = (String)vars.get((Object)"BUILD_URL");
        }
        return buildUrl;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        String path_to_private_key_file;

        public FormValidation doCheckGerrit_username(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGerrit_host(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a gerritHost");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPrivate_key_file_path(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a path to private key file");
            }
            File f = new File(value);
            if (!f.exists()) {
                return FormValidation.error((String)"File doesn't exists");
            }
            if (!SSHMarker.IsPrivateKeyFileValid(f)) {
                return FormValidation.error((String)"Private key file is not valid");
            }
            this.path_to_private_key_file = value;
            return FormValidation.ok();
        }

        public FormValidation doCheckPassPhrase(@QueryParameter String value) {
            if (this.path_to_private_key_file == null) {
                return FormValidation.error((String)"Define path to private key file first");
            }
            File f = new File(this.path_to_private_key_file);
            if (!f.exists()) {
                return FormValidation.error((String)"No private key file");
            }
            if (!SSHMarker.IsPrivateKeyFileValid(f)) {
                return FormValidation.error((String)"Private key file is not valid");
            }
            if (!SSHMarker.CheckPassPhrase(f, value)) {
                return FormValidation.error((String)"Passphrase is not valid");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Gerrit Integration";
        }

        public String guessSSHKeyFile() {
            String user_home = System.getProperty("user.home");
            String ssh_path = user_home + File.separatorChar + ".ssh" + File.separatorChar;
            File f = new File(ssh_path + "id_dsa");
            if (f.exists()) {
                return ssh_path + "id_dsa";
            }
            f = new File(ssh_path + "id_rsa");
            if (f.exists()) {
                return ssh_path + "id_rsa";
            }
            return "";
        }
    }
}

