/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gerrit;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.gerrit.GerritNotifier;
import hudson.plugins.gerrit.git.GitTools;
import hudson.plugins.gerrit.ssh.SSHMarker;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

public class GerritNotifier
extends Notifier
implements Serializable {
    private final String git_home;
    private final String gerrit_host;
    private final int gerrit_port;
    private final String gerrit_username;
    private final String approve_value;
    private final String unstable_value;
    private final String reject_value;
    private String review_approve_value = "0";
    private String review_unstable_value = "0";
    private String review_reject_value = "0";
    private final String gerrit_approve_command = "gerrit approve --verified=%s --code-review=%s --message=\"%s\" %s";
    protected static final String NO_BUILD_URL = "No build url.";
    private final String private_key_file_path;
    private final String passPhrase;
    transient SSHMarker marker;
    transient GitTools git;

    public void setMarker(SSHMarker marker) {
        this.marker = marker;
    }

    public void setGitTools(GitTools git) {
        this.git = git;
    }

    public String getGerrit_host() {
        return this.gerrit_host;
    }

    public int getGerrit_port() {
        return this.gerrit_port;
    }

    public String getGerrit_username() {
        return this.gerrit_username;
    }

    public String getApprove_value() {
        return this.approve_value;
    }

    public String getUnstable_value() {
        return this.unstable_value;
    }

    public String getReject_value() {
        return this.reject_value;
    }

    public String getGerrit_approve_command() {
        return "gerrit approve --verified=%s --code-review=%s --message=\"%s\" %s";
    }

    public String getPrivate_key_file_path() {
        return this.private_key_file_path;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    @DataBoundConstructor
    public GerritNotifier(String git_home, String gerrit_host, int gerrit_port, String gerrit_username, String approve_value, String unstable_value, String reject_value, String review_approve_value, String review_unstable_value, String review_reject_value, String private_key_file_path, String passPhrase) {
        this.git_home = git_home;
        this.gerrit_host = gerrit_host;
        this.gerrit_port = gerrit_port;
        this.gerrit_username = gerrit_username;
        this.approve_value = approve_value;
        this.unstable_value = unstable_value;
        this.reject_value = reject_value;
        this.review_approve_value = review_approve_value;
        this.review_unstable_value = review_unstable_value;
        this.review_reject_value = review_reject_value;
        this.private_key_file_path = private_key_file_path;
        this.passPhrase = passPhrase;
        this.marker = new SSHMarker();
        this.git = new GitTools();
    }

    public String getGit_home() {
        return this.git_home;
    }

    public String generateComment(String verify_value, String review_value, String message, String revision) {
        if (review_value == null) {
            review_value = "0";
        }
        return String.format("gerrit approve --verified=%s --code-review=%s --message=\"%s\" %s", verify_value, review_value, message, revision);
    }

    public String generateApproveCommand(String jobUrl, String revision) {
        return this.generateComment(this.approve_value, this.review_approve_value, jobUrl, revision);
    }

    public String generateUnstableCommand(String jobUrl, String revision) {
        return this.generateComment(this.unstable_value, this.review_unstable_value, "Build is unstable " + jobUrl, revision);
    }

    public String generateFailedCommand(String jobUrl, String revision) {
        return this.generateComment(this.reject_value, this.review_reject_value, "Build failed " + jobUrl, revision);
    }

    public String generateDidNotFinishCommand(String jobUrl, String revision) {
        return this.generateComment("0", "0", "Build did not finish, " + jobUrl, revision);
    }

    private void verifyGerrit(String message) throws IOException, InterruptedException {
        File privateKeyFile = new File(this.private_key_file_path);
        this.marker.connect(this.gerrit_host, this.gerrit_port);
        this.marker.authenticate(this.gerrit_username, privateKeyFile, this.passPhrase);
        this.marker.executeCommand(message);
        this.marker.disconnect();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        FilePath ws = build.getWorkspace();
        if (this.marker == null) {
            this.marker = new SSHMarker();
        }
        String head = (String)ws.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Result r = build.getResult();
            String buildUrl = this.getBuildUrl(build, listener);
            if (r == Result.ABORTED || r == Result.NOT_BUILT) {
                listener.getLogger().println("Build was aborted, notifying gerrit");
                this.verifyGerrit(this.generateDidNotFinishCommand(buildUrl, head));
            } else if (r.isBetterOrEqualTo(Result.SUCCESS)) {
                listener.getLogger().println("Approving " + head);
                this.verifyGerrit(this.generateApproveCommand(buildUrl, head));
            } else if (r.isBetterOrEqualTo(Result.UNSTABLE)) {
                listener.getLogger().println("Rejecting unstable " + head);
                this.verifyGerrit(this.generateUnstableCommand(buildUrl, head));
            } else {
                listener.getLogger().println("Rejecting failed " + head);
                this.verifyGerrit(this.generateFailedCommand(buildUrl, head));
            }
        }
        catch (IOException e) {
            listener.getLogger().println(e.getMessage());
            e.printStackTrace(listener.getLogger());
            build.setResult(Result.ABORTED);
            return false;
        }
        catch (InterruptedException e) {
            listener.getLogger().println("Interrupted: " + e.getMessage());
            build.setResult(Result.ABORTED);
        }
        return true;
    }

    String getBuildUrl(AbstractBuild build, BuildListener listener) throws IOException {
        EnvVars vars = null;
        try {
            vars = build.getEnvironment((TaskListener)listener);
        }
        catch (InterruptedException e) {
            listener.getLogger().println(e.getMessage());
            e.printStackTrace();
            return NO_BUILD_URL;
        }
        String buildUrl = NO_BUILD_URL;
        if (vars.containsKey((Object)"BUILD_URL")) {
            buildUrl = (String)vars.get((Object)"BUILD_URL");
        }
        return buildUrl;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    static /* synthetic */ String access$000(GerritNotifier x0) {
        return x0.git_home;
    }
}

