/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.util.ArgumentListBuilder;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitAPI
implements IGitAPI {
    Launcher launcher;
    FilePath workspace;
    TaskListener listener;
    String gitExe;

    public GitAPI(String gitExe, Launcher launcher, FilePath workspace, TaskListener listener) {
        this.launcher = launcher;
        this.workspace = workspace;
        this.listener = listener;
        this.gitExe = gitExe;
    }

    public String getGitExe() {
        return this.gitExe;
    }

    public boolean hasGitRepo() throws GitException {
        try {
            return (Boolean)this.workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git");
        }
    }

    public boolean hasGitModules() throws GitException {
        try {
            return (Boolean)this.workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules");
        }
    }

    public void fetch() throws GitException {
        this.listener.getLogger().println("Fetching upstream changes");
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "fetch"});
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)this.listener.getLogger(), this.workspace).join() != 0) {
                throw new GitException("Failed to fetch");
            }
        }
        catch (Exception e) {
            throw new GitException("Failed to fetch", (Throwable)e);
        }
    }

    public void clone(String source) throws GitException {
        this.listener.getLogger().println("Cloning repository " + source);
        try {
            this.workspace.deleteRecursive();
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.error("Failed to clean the workspace"));
            throw new GitException("Failed to delete workspace", (Throwable)e);
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "clone"});
        args.add(new String[]{source, this.workspace.getRemote()});
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)this.listener.getLogger(), null).join() != 0) {
                throw new GitException("Clone returned an error code");
            }
        }
        catch (Exception e) {
            throw new GitException("Failed to clone " + source);
        }
    }

    public void diff(OutputStream baos) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "diff", "--shortstat", "origin"});
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), baos, this.workspace).join() != 0) {
                throw new GitException("Failed to diff");
            }
        }
        catch (Exception e) {
            throw new GitException("Failed to diff", (Throwable)e);
        }
    }

    public void log(OutputStream fos) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "log", "--numstat", "-M", "--summary", "--pretty=raw", "HEAD..origin"});
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), fos, this.workspace).join() != 0) {
                throw new GitException("Error launching git log");
            }
        }
        catch (Exception e) {
            throw new GitException("Error performing git log", (Throwable)e);
        }
    }

    public void merge() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "merge", "origin"});
        this.launch(args.toCommandArray(), "Error in merge");
    }

    private void launch(String[] args, String error) {
        try {
            if (this.launcher.launch(args, this.createEnvVarMap(), (OutputStream)this.listener.getLogger(), this.workspace).join() != 0) {
                throw new GitException(error);
            }
        }
        catch (Exception e) {
            throw new GitException(error, (Throwable)e);
        }
    }

    public void submoduleInit() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "submodule", "init"});
        this.launch(args.toCommandArray(), "Error in submodule init");
    }

    public void submoduleUpdate() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "submodule", "update"});
        this.launch(args.toCommandArray(), "Error in submodule init");
    }

    protected final Map<String, String> createEnvVarMap() {
        HashMap<String, String> env = new HashMap<String, String>();
        return env;
    }
}

