/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.GitWeb;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends SCM
implements Serializable {
    private final String source;
    private final String branch;
    private boolean hasSubmodules;
    private GitWeb browser;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GitSCM(String source, String branch, boolean submodules, GitWeb browser) {
        this.source = source;
        branch = Util.fixEmpty((String)branch);
        if (branch != null && branch.equals("master")) {
            branch = null;
        }
        this.branch = branch;
        this.hasSubmodules = submodules;
        this.browser = browser;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch == null ? "master" : this.branch;
    }

    public GitWeb getBrowser() {
        return this.browser;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        listener.getLogger().println("Poll for changes");
        boolean canUpdate = (Boolean)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        if (git.hasGitRepo()) {
            listener.getLogger().println("Update repository");
            git.fetch();
            return this.anyChanges(launcher, workspace, listener);
        }
        listener.getLogger().println("Clone entire repository");
        git.clone(this.source);
        if (git.hasGitModules()) {
            git.submoduleInit();
            git.submoduleUpdate();
        }
        return true;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, (TaskListener)listener);
        if (git.hasGitRepo()) {
            listener.getLogger().println("Checkout (update)");
            git.fetch();
            this.putChangelogDiffsIntoFile(launcher, workspace, (TaskListener)listener, changelogFile);
            git.merge();
            if (git.hasGitModules()) {
                git.submoduleUpdate();
            }
        } else {
            listener.getLogger().println("Checkout (clone)");
            git.clone(this.source);
            if (git.hasGitModules()) {
                git.submoduleInit();
                git.submoduleUpdate();
            }
        }
        return true;
    }

    private boolean anyChanges(Launcher launcher, FilePath workspace, TaskListener listener) throws IOException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        listener.getLogger().println("Diff against original");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        git.diff((OutputStream)baos);
        baos.close();
        String result = baos.toString();
        return result.contains("changed");
    }

    private void putChangelogDiffsIntoFile(Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile) throws IOException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        git.log((OutputStream)fos);
        fos.close();
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public boolean getHasSubmodules() {
        return this.hasSubmodules;
    }

    public void setHasSubmodules(boolean hasSubmodules) {
        this.hasSubmodules = hasSubmodules;
    }
}

