/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.browser.GitWeb;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.ByteBuffer;
import hudson.util.FormFieldValidator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends SCM
implements Serializable {
    private final String source;
    private final String branch;
    private boolean hasSubmodules;
    private GitWeb browser;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GitSCM(String source, String branch, boolean submodules, GitWeb browser) {
        this.source = source;
        branch = Util.fixEmpty((String)branch);
        if (branch != null && branch.equals("master")) {
            branch = null;
        }
        this.branch = branch;
        this.hasSubmodules = submodules;
        this.browser = browser;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch == null ? "master" : this.branch;
    }

    public GitWeb getBrowser() {
        return this.browser;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        listener.getLogger().println("Poll for changes");
        boolean canUpdate = (Boolean)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

            public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
                File dotGit = new File(ws, ".git");
                return dotGit.exists();
            }
        });
        if (git.hasGitRepo()) {
            listener.getLogger().println("Update repository");
            git.fetch();
            return this.anyChanges(launcher, workspace, listener);
        }
        listener.getLogger().println("Clone entire repository");
        git.clone(this.source);
        if (git.hasGitModules()) {
            git.submoduleInit();
            git.submoduleUpdate();
        }
        return true;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, (TaskListener)listener);
        if (git.hasGitRepo()) {
            listener.getLogger().println("Checkout (update)");
            git.fetch();
            this.putChangelogDiffsIntoFile(launcher, workspace, (TaskListener)listener, changelogFile);
            git.merge();
            if (git.hasGitModules()) {
                git.submoduleUpdate();
            }
        } else {
            listener.getLogger().println("Checkout (clone)");
            git.clone(this.source);
            if (git.hasGitModules()) {
                git.submoduleInit();
                git.submoduleUpdate();
            }
        }
        return true;
    }

    private boolean anyChanges(Launcher launcher, FilePath workspace, TaskListener listener) throws IOException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        listener.getLogger().println("Diff against original");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        git.diff(baos);
        baos.close();
        String result = baos.toString();
        return result.contains("changed");
    }

    private void putChangelogDiffsIntoFile(Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile) throws IOException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        git.log(fos);
        fos.close();
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public boolean getHasSubmodules() {
        return this.hasSubmodules;
    }

    public void setHasSubmodules(boolean hasSubmodules) {
        this.hasSubmodules = hasSubmodules;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends SCMDescriptor<GitSCM> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private String gitExe;

        private DescriptorImpl() {
            super(GitSCM.class, GitWeb.class);
            this.load();
        }

        public String getDisplayName() {
            return "Git";
        }

        public String getGitExe() {
            if (this.gitExe == null) {
                return "git";
            }
            return this.gitExe;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new GitSCM(req.getParameter("git.source"), req.getParameter("git.branch"), req.getParameter("git.submodules") != null, (GitWeb)RepositoryBrowsers.createInstance(GitWeb.class, (StaplerRequest)req, (String)"git.browser"));
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.gitExe = req.getParameter("git.gitExe");
            this.save();
            return true;
        }

        public void doGitExeCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.Executable(req, rsp){

                protected void checkExecutable(File exe) throws IOException, ServletException {
                    ByteBuffer baos = new ByteBuffer();
                    try {
                        Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch(new String[]{DescriptorImpl.this.getGitExe(), "--version"}, new String[0], (OutputStream)baos, null);
                        proc.join();
                        String result = baos.toString();
                        this.ok();
                    }
                    catch (IOException e) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.error("Unable to check git version");
                }
            }.process();
        }
    }
}

