/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitPublisher;
import hudson.plugins.git.GitSCM;
import hudson.tasks.Publisher;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitPublisher
extends Publisher
implements Serializable {
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        GitAPI git = new GitAPI(GitSCM.DescriptorImpl.DESCRIPTOR.getGitExe(), launcher, build.getProject().getWorkspace(), (TaskListener)listener);
        String tag = "hudson-" + build.number + "-" + build.getResult().toString();
        String buildnumber = "hudson-" + build.getProject().getName() + "-" + build.getNumber();
        git.deleteTag(buildnumber);
        buildnumber = buildnumber + "-" + build.getResult().toString();
        git.tag(buildnumber, "Hudson Build #" + build.getNumber());
        git.push();
        return true;
    }
}

