/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Tag;
import hudson.plugins.git.browser.GitWeb;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends SCM
implements Serializable {
    private final String source;
    private final String branch;
    private GitWeb browser;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GitSCM(String source, String branch, GitWeb browser) {
        this.source = source;
        this.branch = branch = Util.fixEmpty((String)branch);
        this.browser = browser;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch == null ? "" : this.branch;
    }

    public GitWeb getBrowser() {
        return this.browser;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        listener.getLogger().println("Poll for changes");
        if (git.hasGitRepo()) {
            listener.getLogger().println("Update repository");
            git.fetch();
            return this.branchesThatNeedBuilding(launcher, workspace, listener).size() > 0;
        }
        return true;
    }

    private Collection<Branch> filterBranches(Collection<Branch> branches) {
        if (this.branch == null || this.branch.length() == 0) {
            return branches;
        }
        HashSet<Branch> interesting = new HashSet<Branch>(branches);
        for (Branch b : branches) {
            if (b.getName().equals(this.branch)) continue;
            interesting.remove(b);
        }
        return interesting;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, (TaskListener)listener);
        if (git.hasGitRepo()) {
            listener.getLogger().println("Checkout (update)");
            git.fetch();
            if (git.hasGitModules()) {
                git.submoduleUpdate();
            }
        } else {
            listener.getLogger().println("Checkout (clone)");
            git.clone(this.source);
            if (git.hasGitModules()) {
                git.submoduleInit();
                git.submoduleUpdate();
            }
        }
        Set toBeBuilt = this.branchesThatNeedBuilding(launcher, workspace, (TaskListener)listener);
        String revToBuild = null;
        if (toBeBuilt.size() == 0) {
            listener.getLogger().println("Nothing to do (no unbuilt branches)");
            revToBuild = git.revParse("HEAD");
        } else {
            revToBuild = ((Branch)toBeBuilt.iterator().next()).getSHA1();
        }
        git.checkout(revToBuild);
        String lastRevWas = this.whenWasBranchLastBuilt(revToBuild, launcher, workspace, (TaskListener)listener);
        this.putChangelogDiffsIntoFile(lastRevWas, revToBuild, launcher, workspace, (TaskListener)listener, changelogFile);
        String buildnumber = "hudson-" + build.getProject().getName() + "-" + build.getNumber();
        git.tag(buildnumber, "Hudson Build #" + build.getNumber());
        return true;
    }

    private Set<Branch> branchesThatNeedBuilding(Launcher launcher, FilePath workspace, TaskListener listener) throws IOException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        HashSet<String> setOfThingsBuilt = new HashSet<String>();
        HashSet<Branch> branchesThatNeedBuilding = new HashSet<Branch>();
        for (Tag tag : git.getTags()) {
            if (!tag.getName().startsWith("hudson")) continue;
            setOfThingsBuilt.add(tag.getCommitSHA1());
        }
        for (Branch branch : this.filterBranches((Collection)git.getBranches())) {
            if (!branch.getName().startsWith("origin/") || setOfThingsBuilt.contains(branch.getSHA1())) continue;
            branchesThatNeedBuilding.add(branch);
        }
        return branchesThatNeedBuilding;
    }

    private String whenWasBranchLastBuilt(String branchId, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        HashSet<String> setOfThingsBuilt = new HashSet<String>();
        for (Tag tag : git.getTags()) {
            if (!tag.getName().startsWith("hudson")) continue;
            setOfThingsBuilt.add(tag.getCommitSHA1());
        }
        try {
            while (true) {
                String rev;
                if (setOfThingsBuilt.contains(rev = git.revParse(branchId))) {
                    return rev;
                }
                branchId = branchId + "^";
            }
        }
        catch (GitException ex) {
            return null;
        }
    }

    private void putChangelogDiffsIntoFile(String revFrom, String revTo, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile) throws IOException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        git.log(revFrom, revTo, (OutputStream)fos);
        fos.close();
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }
}

