/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitChangeSet
extends ChangeLogSet.Entry {
    String author;
    String msg;
    String id;
    Collection<String> affectedPaths = new HashSet<String>();

    public GitChangeSet(List<String> lines) {
        if (lines.size() > 0) {
            this.parseCommit(lines);
        }
    }

    private void parseCommit(List<String> lines) {
        String comment = "";
        for (String line : lines) {
            String[] paths;
            String pathString;
            String[] items;
            if (line.length() <= 0) continue;
            if (line.startsWith("commit ")) {
                this.id = line.split(" ")[1];
                continue;
            }
            if (line.startsWith("tree") || line.startsWith("parent")) continue;
            if (line.startsWith("committer")) {
                this.author = line.substring(10, line.indexOf(" <"));
                continue;
            }
            if (line.startsWith("author ")) continue;
            if (line.startsWith("    ")) {
                comment = comment + line + "\n";
                continue;
            }
            if (line.startsWith(" create")) {
                items = line.split(" ");
                pathString = line.substring(line.indexOf(items[4]));
                this.affectedPaths.add(pathString);
                continue;
            }
            if (line.startsWith(" delete")) {
                items = line.split(" ");
                pathString = line.substring(line.indexOf(items[4]));
                this.affectedPaths.add(pathString);
                continue;
            }
            if (line.startsWith(" rename")) {
                items = line.split(" ");
                pathString = line.substring(line.indexOf(items[2]));
                pathString = pathString.substring(0, pathString.lastIndexOf(" "));
                paths = this.unsplit(pathString);
                this.affectedPaths.add(paths[0]);
                this.affectedPaths.add(paths[1]);
                continue;
            }
            if (line.startsWith(" copy")) {
                items = line.split(" ");
                pathString = line.substring(line.indexOf(items[2]));
                pathString = pathString.substring(0, pathString.lastIndexOf(" "));
                paths = this.unsplit(pathString);
                this.affectedPaths.add(paths[1]);
                continue;
            }
            if (line.startsWith(" mode") || !line.startsWith(" ")) continue;
            throw new RuntimeException("Log contains line that is not expected: " + line);
        }
        this.msg = comment;
    }

    public String[] unsplit(String data) {
        try {
            if (!data.contains("{")) {
                String left = data.substring(0, data.indexOf(" => "));
                String right = data.substring(data.indexOf(" => ") + 4);
                return new String[]{left, right};
            }
            String pre = data.substring(0, data.indexOf(123));
            String post = data.substring(data.indexOf(125) + 1);
            String left = data.substring(data.indexOf(123) + 1, data.indexOf(" => "));
            String right = data.substring(data.indexOf(" => ") + 4, data.indexOf("}"));
            String leftItem = pre + left + post;
            String rightItem = pre + right + post;
            leftItem = leftItem.replaceAll("//", "/");
            rightItem = rightItem.replaceAll("//", "/");
            return new String[]{leftItem, rightItem};
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    public Collection<String> getAffectedPaths() {
        return this.affectedPaths;
    }

    public User getAuthor() {
        return User.get((String)this.author, (boolean)true);
    }

    public String getMsg() {
        return this.msg;
    }

    public String getId() {
        return this.id;
    }
}

