/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitSCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitPublisher
extends Publisher
implements Serializable {
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        GitAPI git = new GitAPI(GitSCM.DescriptorImpl.DESCRIPTOR.getGitExe(), launcher, build.getProject().getWorkspace(), (TaskListener)listener);
        String tag = "hudson-" + build.number + "-" + build.getResult().toString();
        String buildnumber = "hudson-" + build.getProject().getName() + "-" + build.getNumber();
        git.deleteTag(buildnumber);
        buildnumber = buildnumber + "-" + build.getResult().toString();
        git.tag(buildnumber, "Hudson Build #" + build.getNumber());
        git.push();
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(GitPublisher.class);
        }

        public String getDisplayName() {
            return "Push GIT tags back to origin repository";
        }

        public String getHelpFile() {
            return "/plugin/git/gitPublisher.html";
        }

        public void doCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.WorkspaceFileMask(req, rsp).process();
        }

        public GitPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new GitPublisher();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

