/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Tag;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitAPI
implements IGitAPI {
    Launcher launcher;
    FilePath workspace;
    TaskListener listener;
    String gitExe;

    public GitAPI(String gitExe, Launcher launcher, FilePath workspace, TaskListener listener) {
        this.launcher = launcher;
        this.workspace = workspace;
        this.listener = listener;
        this.gitExe = gitExe;
    }

    public String getGitExe() {
        return this.gitExe;
    }

    public boolean hasGitRepo() throws GitException {
        try {
            return (Boolean)this.workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git");
        }
    }

    public boolean hasGitModules() throws GitException {
        try {
            return (Boolean)this.workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules");
        }
    }

    public void fetch(String repository, String refspec) throws GitException {
        this.listener.getLogger().println("Fetching upstream changes" + (repository != null ? " from " + repository : ""));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "fetch"});
        if (repository != null) {
            args.add(repository);
            if (refspec != null) {
                args.add(refspec);
            }
        }
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)this.listener.getLogger(), this.workspace).join() != 0) {
                throw new GitException("Failed to fetch");
            }
        }
        catch (IOException e) {
            throw new GitException("Failed to fetch", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new GitException("Failed to fetch", (Throwable)e);
        }
    }

    public void fetch() throws GitException {
        this.fetch(null, null);
    }

    public void clone(String source) throws GitException {
        this.listener.getLogger().println("Cloning repository " + source);
        try {
            this.workspace.deleteRecursive();
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.error("Failed to clean the workspace"));
            throw new GitException("Failed to delete workspace", (Throwable)e);
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "clone"});
        args.add(new String[]{source, this.workspace.getRemote()});
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)this.listener.getLogger(), null).join() != 0) {
                throw new GitException("Clone returned an error code");
            }
        }
        catch (Exception e) {
            throw new GitException("Failed to clone " + source);
        }
    }

    public String revParse(String revName) throws GitException {
        String result;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "rev-parse", revName});
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)fos, this.workspace).join() != 0) {
                throw new GitException("Error launching git rev-parse");
            }
            fos.close();
            result = fos.toString().trim();
        }
        catch (Exception e) {
            throw new GitException("Error performing git rev-parse", (Throwable)e);
        }
        if (result.contains("fatal")) {
            throw new GitException("Error fetching revision information " + result);
        }
        return result;
    }

    public void diff(OutputStream baos) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "diff", "--shortstat", "origin"});
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), baos, this.workspace).join() != 0) {
                throw new GitException("Failed to diff");
            }
        }
        catch (Exception e) {
            throw new GitException("Failed to diff", (Throwable)e);
        }
    }

    public void log(String revFrom, String revTo, OutputStream fos) throws GitException {
        String revSpec = revFrom == null ? revTo : revFrom + ".." + revTo;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "log", "--numstat", "-M", "--summary", "--pretty=raw", revSpec});
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), fos, this.workspace).join() != 0) {
                throw new GitException("Error launching git log");
            }
        }
        catch (Exception e) {
            throw new GitException("Error performing git log", (Throwable)e);
        }
    }

    public void merge(String revSpec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "merge", revSpec});
        this.launch(args.toCommandArray(), "Error in merge");
    }

    private void launch(String[] args, String error) {
        try {
            if (this.launcher.launch(args, this.createEnvVarMap(), (OutputStream)this.listener.getLogger(), this.workspace).join() != 0) {
                throw new GitException(error);
            }
        }
        catch (Exception e) {
            throw new GitException(error, (Throwable)e);
        }
    }

    public void submoduleInit() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "submodule", "init"});
        this.launch(args.toCommandArray(), "Error in submodule init");
    }

    public void submoduleUpdate() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "submodule", "update"});
        this.launch(args.toCommandArray(), "Error in submodule update");
    }

    protected final Map<String, String> createEnvVarMap() {
        HashMap<String, String> env = new HashMap<String, String>();
        return env;
    }

    public void tag(String tagName, String comment) throws GitException {
        tagName = tagName.replace(' ', '_');
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "tag", "-a", "-f", tagName, "-m", comment});
        this.launch(args.toCommandArray(), "Error in tag");
    }

    public List<Tag> getTags() throws GitException {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "tag", "-l"});
        try {
            String line;
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)fos, this.workspace).join() != 0) {
                return tags;
            }
            fos.close();
            BufferedReader rdr = new BufferedReader(new StringReader(fos.toString()));
            while ((line = rdr.readLine()) != null) {
                Tag t = new Tag(line, this.revParse(line));
                t.setCommitSHA1(this.getTagCommit(t.getSHA1()));
                tags.add(t);
            }
            return tags;
        }
        catch (Exception e) {
            throw new GitException("Error performing git rev-parse", (Throwable)e);
        }
    }

    public void push(String refspec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "push", "--tags", "origin"});
        if (refspec != null) {
            args.add(refspec);
        }
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)fos, this.workspace).join() != 0) {
                throw new GitException("Error launching git push");
            }
            fos.close();
        }
        catch (Exception e) {
            throw new GitException("Error performing git push", (Throwable)e);
        }
    }

    private List<Branch> parseBranches(String fos) throws IOException {
        String line;
        ArrayList<Branch> tags = new ArrayList<Branch>();
        BufferedReader rdr = new BufferedReader(new StringReader(fos));
        while ((line = rdr.readLine()) != null) {
            if ((line = line.substring(2)).startsWith("(")) continue;
            tags.add(new Branch(line, this.revParse(line)));
        }
        return tags;
    }

    public List<Branch> getBranches() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "branch", "-a"});
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)fos, this.workspace).join() != 0) {
                throw new GitException("Error launching git branch");
            }
            fos.close();
            return this.parseBranches(fos.toString());
        }
        catch (Exception e) {
            throw new GitException("Error performing git branch", (Throwable)e);
        }
    }

    public List<Branch> getBranchesContaining(String revspec) throws GitException {
        ArrayList<Branch> tags = new ArrayList<Branch>();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "branch", "-a", "--contains", revspec});
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)fos, this.workspace).join() != 0) {
                return tags;
            }
            fos.close();
            return this.parseBranches(fos.toString());
        }
        catch (Exception e) {
            throw new GitException("Error performing git branch", (Throwable)e);
        }
    }

    public void checkout(String ref) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "checkout", "-f", ref});
        this.launch(args.toCommandArray(), "Error in checkout");
    }

    public void deleteTag(String tagName) throws GitException {
        tagName = tagName.replace(' ', '_');
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "tag", "-d", tagName});
        this.launch(args.toCommandArray(), "Error in deleteTag");
    }

    private String getTagCommit(String tagName) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "cat-file", "-p", tagName});
        try {
            String line;
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)fos, this.workspace).join() != 0) {
                throw new GitException("Error executing cat-file");
            }
            fos.close();
            BufferedReader rdr = new BufferedReader(new StringReader(fos.toString()));
            while ((line = rdr.readLine()) != null) {
                if (!line.startsWith("object")) continue;
                return line.substring(7);
            }
            return null;
        }
        catch (Exception e) {
            throw new GitException("Error performing git cat-file", (Throwable)e);
        }
    }

    public List<IndexEntry> lsTree(String treeIsh) throws GitException {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "ls-tree", treeIsh});
        try {
            String line;
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)fos, this.workspace).join() != 0) {
                throw new GitException("Error executing ls-tree");
            }
            fos.close();
            BufferedReader rdr = new BufferedReader(new StringReader(fos.toString()));
            while ((line = rdr.readLine()) != null) {
                String[] entry = line.split("\\s+");
                entries.add(new IndexEntry(entry[0], entry[1], entry[2], entry[3]));
            }
            return entries;
        }
        catch (Exception e) {
            throw new GitException("Error performing git ls-tree", (Throwable)e);
        }
    }

    public List<String> revList() throws GitException {
        ArrayList<String> entries = new ArrayList<String>();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "rev-list", "--all"});
        try {
            String line;
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)fos, this.workspace).join() != 0) {
                throw new GitException("Error executing rev-list");
            }
            fos.close();
            BufferedReader rdr = new BufferedReader(new StringReader(fos.toString()));
            while ((line = rdr.readLine()) != null) {
                entries.add(line);
            }
            return entries;
        }
        catch (Exception e) {
            throw new GitException("Error performing git rev-list", (Throwable)e);
        }
    }

    public void add(String filePattern) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "add", filePattern});
        this.launch(args.toCommandArray(), "Error in add");
    }

    public void branch(String name) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "branch", name});
        this.launch(args.toCommandArray(), "Error in branch");
    }

    public void commit(String comment) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "commit", "-m", comment});
        this.launch(args.toCommandArray(), "Error in commit");
    }

    public void commit(File f) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "commit", "-F", f.getAbsolutePath()});
        this.launch(args.toCommandArray(), "Error in commit");
    }
}

