/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.RemoteRepository;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleCombinator;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.Tag;
import hudson.plugins.git.browser.GitWeb;
import hudson.plugins.git.util.GitUtils;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends SCM
implements Serializable {
    private final String source;
    private List<RemoteRepository> repositories;
    private final String branch;
    private final boolean doMerge;
    private final boolean doGenerateSubmoduleConfigurations;
    private final String mergeTarget;
    private GitWeb browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    private static final long serialVersionUID = 1L;

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    @DataBoundConstructor
    public GitSCM(String source, String branch, boolean doMerge, boolean doGenerateSubmoduleConfigurations, String mergeTarget, List<RemoteRepository> repositories, Collection<SubmoduleConfig> submoduleCfg, GitWeb browser) {
        this.source = source;
        branch = Util.fixEmpty((String)branch);
        this.repositories = repositories;
        this.branch = branch;
        this.browser = browser;
        this.doMerge = doMerge;
        this.mergeTarget = mergeTarget;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations;
        this.submoduleCfg = submoduleCfg;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch == null ? "" : this.branch;
    }

    public GitWeb getBrowser() {
        return this.browser;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        listener.getLogger().println("Poll for changes");
        if (git.hasGitRepo()) {
            listener.getLogger().println("Update repository");
            git.fetch();
            for (RemoteRepository remoteRepository : this.repositories) {
                this.fetchFrom((IGitAPI)git, launcher, workspace, listener, remoteRepository);
            }
            return this.branchesThatNeedBuilding(launcher, workspace, listener).size() > 0;
        }
        return true;
    }

    private void fetchFrom(IGitAPI git, Launcher launcher, FilePath workspace, TaskListener listener, RemoteRepository remoteRepository) {
        try {
            git.fetch(remoteRepository.getUrl(), remoteRepository.getRefspec());
            List submodules = new GitUtils(listener, git).getSubmodules("HEAD");
            for (IndexEntry submodule : submodules) {
                try {
                    RemoteRepository submoduleRemoteRepository = remoteRepository.getSubmoduleRepository(submodule.getFile());
                    FilePath subdir = new FilePath(workspace, submodule.getFile());
                    GitAPI subGit = new GitAPI(this.getDescriptor().getGitExe(), launcher, subdir, listener);
                    subGit.fetch(submoduleRemoteRepository.getUrl(), submoduleRemoteRepository.getRefspec());
                }
                catch (GitException ex) {
                    listener.getLogger().println("Problem fetching from " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
                }
            }
        }
        catch (GitException ex) {
            listener.getLogger().println("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getUrl() + " - could be unavailable. Continuing anyway");
        }
    }

    private Collection<Revision> filterBranches(Collection<Revision> branches) {
        if (this.branch == null || this.branch.length() == 0) {
            return branches;
        }
        HashSet<Revision> interesting = new HashSet<Revision>();
        for (Revision r : branches) {
            for (Branch b : r.getBranches()) {
                if (b.getName().equals(this.branch)) continue;
                interesting.add(r);
            }
        }
        return interesting;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        String lastRevWas;
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, (TaskListener)listener);
        if (git.hasGitRepo()) {
            listener.getLogger().println("Checkout (update)");
            git.fetch();
            for (RemoteRepository remoteRepository : this.repositories) {
                try {
                    git.fetch(remoteRepository.getUrl(), remoteRepository.getRefspec());
                }
                catch (GitException ex) {
                    listener.getLogger().println("Problem fetching from " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
                }
            }
        } else {
            listener.getLogger().println("Checkout (clone)");
            git.clone(this.source);
            if (git.hasGitModules()) {
                git.submoduleInit();
                git.submoduleUpdate();
            }
        }
        Set toBeBuilt = this.branchesThatNeedBuilding(launcher, workspace, (TaskListener)listener);
        String log = "Candidate revisions to be built: ";
        for (Revision b : toBeBuilt) {
            log = log + b.toString() + "; ";
        }
        listener.getLogger().println(log);
        Revision revToBuild = null;
        String buildnumber = "hudson-" + build.getProject().getName() + "-" + build.getNumber();
        if (toBeBuilt.size() == 0) {
            revToBuild = new Revision(git.revParse("HEAD"));
            listener.getLogger().println("Nothing to do (no unbuilt branches) - rebuilding HEAD " + revToBuild);
        } else {
            revToBuild = (Revision)toBeBuilt.iterator().next();
        }
        if (this.doMerge && !revToBuild.containsBranchName(this.getMergeTarget())) {
            listener.getLogger().println("Merging " + revToBuild + " onto " + this.getMergeTarget());
            git.checkout(this.getRemoteMergeTarget());
            try {
                git.merge(revToBuild.getSha1());
            }
            catch (Exception ex) {
                listener.getLogger().println("Branch not suitable for integration as it does not merge cleanly");
                git.checkout(revToBuild.getSha1());
                git.tag(buildnumber, "Hudson Build #" + build.getNumber());
                return false;
            }
            if (git.hasGitModules()) {
                git.submoduleUpdate();
            }
            git.tag(buildnumber, "Hudson Build #" + build.getNumber());
            String lastRevWas2 = this.whenWasBranchLastBuilt(revToBuild.getSha1(), launcher, workspace, (TaskListener)listener);
            this.putChangelogDiffsIntoFile(lastRevWas2, git.revParse("HEAD"), launcher, workspace, (TaskListener)listener, changelogFile);
            return true;
        }
        listener.getLogger().println("Checking out " + revToBuild);
        git.checkout(revToBuild.getSha1());
        if (this.doGenerateSubmoduleConfigurations) {
            SubmoduleCombinator combinator = new SubmoduleCombinator((IGitAPI)git, launcher, (TaskListener)listener, workspace, this.submoduleCfg);
            combinator.createSubmoduleCombinations();
        }
        if (git.hasGitModules()) {
            git.submoduleInit();
            for (RemoteRepository remoteRepository : this.repositories) {
                this.fetchFrom((IGitAPI)git, launcher, workspace, (TaskListener)listener, remoteRepository);
            }
            git.submoduleUpdate();
        }
        if ((lastRevWas = this.whenWasBranchLastBuilt(revToBuild.getSha1(), launcher, workspace, (TaskListener)listener)) != null) {
            changelogFile.delete();
            FileOutputStream fos = new FileOutputStream(changelogFile);
            fos.write("First Time Build of Branch.".getBytes());
            fos.close();
        } else {
            this.putChangelogDiffsIntoFile(lastRevWas, revToBuild.getSha1(), launcher, workspace, (TaskListener)listener, changelogFile);
        }
        git.tag(buildnumber, "Hudson Build #" + build.getNumber());
        return true;
    }

    private Set<Revision> branchesThatNeedBuilding(Launcher launcher, FilePath workspace, TaskListener listener) throws IOException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        HashSet<String> setOfThingsBuilt = new HashSet<String>();
        HashSet<Revision> branchesThatNeedBuilding = new HashSet<Revision>();
        for (Tag tag : git.getTags()) {
            if (!tag.getName().startsWith("hudson")) continue;
            setOfThingsBuilt.add(tag.getCommitSHA1());
        }
        for (Revision revision : this.filterBranches(new GitUtils(listener, (IGitAPI)git).getTipBranches())) {
            if (setOfThingsBuilt.contains(revision.getSha1())) continue;
            branchesThatNeedBuilding.add(revision);
        }
        return branchesThatNeedBuilding;
    }

    private String whenWasBranchLastBuilt(String branchId, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        HashSet<String> setOfThingsBuilt = new HashSet<String>();
        for (Tag tag : git.getTags()) {
            if (!tag.getName().startsWith("hudson")) continue;
            setOfThingsBuilt.add(tag.getCommitSHA1());
        }
        if (setOfThingsBuilt.isEmpty()) {
            return null;
        }
        try {
            while (true) {
                String rev;
                if (setOfThingsBuilt.contains(rev = git.revParse(branchId))) {
                    return rev;
                }
                branchId = branchId + "^";
            }
        }
        catch (GitException ex) {
            return null;
        }
    }

    private void putChangelogDiffsIntoFile(String revFrom, String revTo, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile) throws IOException {
        GitAPI git = new GitAPI(this.getDescriptor().getGitExe(), launcher, workspace, listener);
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        git.log(revFrom, revTo, (OutputStream)fos);
        fos.close();
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public boolean getDoMerge() {
        return this.doMerge;
    }

    public boolean getDoGenerate() {
        return this.doGenerateSubmoduleConfigurations;
    }

    public String getMergeTarget() {
        return this.mergeTarget;
    }

    public String getRemoteMergeTarget() {
        return "origin/" + this.mergeTarget;
    }
}

