/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import java.util.regex.Pattern;

public class SubmoduleConfig {
    String submoduleName;
    String[] branches;

    public String getSubmoduleName() {
        return this.submoduleName;
    }

    public void setSubmoduleName(String submoduleName) {
        this.submoduleName = submoduleName;
    }

    public String[] getBranches() {
        return this.branches;
    }

    public void setBranches(String[] branches) {
        this.branches = branches;
    }

    public boolean revisionMatchesInterest(Revision r) {
        for (Branch br : r.getBranches()) {
            if (!this.branchMatchesInterest(br)) continue;
            return true;
        }
        return false;
    }

    public boolean branchMatchesInterest(Branch br) {
        for (String regex : this.branches) {
            if (Pattern.matches(regex, br.getName())) continue;
            return false;
        }
        return true;
    }

    public String getBranchesString() {
        String ret = "";
        for (String branch : this.branches) {
            if (ret.length() > 0) {
                ret = ret + ",";
            }
            ret = ret + branch;
        }
        return ret;
    }
}

