/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitUtils {
    IGitAPI git;
    TaskListener listener;

    public GitUtils(TaskListener listener, IGitAPI git) {
        this.git = git;
        this.listener = listener;
    }

    public List<IndexEntry> getSubmodules(String treeIsh) {
        List submodules = this.git.lsTree(treeIsh);
        Iterator it = submodules.iterator();
        while (it.hasNext()) {
            if (((IndexEntry)it.next()).getMode().equals("160000")) continue;
            it.remove();
        }
        return submodules;
    }

    private String listBranches(Collection<Branch> list) {
        String txt = "";
        for (Branch branch : list) {
            txt = txt + branch.getName() + " ";
        }
        return txt;
    }

    public Collection<Revision> getAllBranchRevisions() {
        HashMap<String, Revision> revisions = new HashMap<String, Revision>();
        List branches = this.git.getBranches();
        for (Branch b : branches) {
            Revision r = (Revision)revisions.get(b.getSHA1());
            if (r == null) {
                r = new Revision(b.getSHA1());
                revisions.put(b.getSHA1(), r);
            }
            r.getBranches().add(b);
        }
        return revisions.values();
    }

    public Collection<Revision> getTipBranches() {
        Collection revisions = this.getAllBranchRevisions();
        Iterator it = revisions.iterator();
        block0: while (it.hasNext()) {
            Revision r = (Revision)it.next();
            List contained = this.git.getBranchesContaining(r.getSha1());
            boolean remove = false;
            for (Branch candidate : contained) {
                if (candidate.getSHA1().equals(r.getSha1())) continue;
                it.remove();
                continue block0;
            }
        }
        return revisions;
    }
}

