/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.RemoteRepository;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.Tag;
import hudson.plugins.git.browser.GitWeb;
import hudson.plugins.git.util.GitUtils;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GitSCM
extends SCM
implements Serializable {
    private final String source;
    private List<RemoteRepository> repositories;
    private final String branch;
    private final boolean doMerge;
    private final boolean doGenerateSubmoduleConfigurations;
    private final String mergeTarget;
    private GitWeb browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    private static final long serialVersionUID = 1L;

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    @DataBoundConstructor
    public GitSCM(String source, String branch, boolean doMerge, boolean doGenerateSubmoduleConfigurations, String mergeTarget, List<RemoteRepository> repositories, Collection<SubmoduleConfig> submoduleCfg, GitWeb browser) {
        this.source = source;
        branch = Util.fixEmpty((String)branch);
        this.repositories = repositories;
        this.branch = branch;
        this.browser = browser;
        this.doMerge = doMerge;
        this.mergeTarget = mergeTarget;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations;
        this.submoduleCfg = submoduleCfg;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch == null ? "" : this.branch;
    }

    public GitWeb getBrowser() {
        return this.browser;
    }

    public List<RemoteRepository> getRepositories() {
        if (this.repositories == null) {
            return new ArrayList<RemoteRepository>();
        }
        return this.repositories;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        String gitExe = this.getDescriptor().getGitExe();
        boolean pollChangesResult = (Boolean)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        return pollChangesResult;
    }

    private void fetchFrom(IGitAPI git, File workspace, TaskListener listener, RemoteRepository remoteRepository) {
        try {
            git.fetch(remoteRepository.getUrl(), remoteRepository.getRefspec());
            List submodules = new GitUtils(listener, git).getSubmodules("HEAD");
            for (IndexEntry submodule : submodules) {
                try {
                    RemoteRepository submoduleRemoteRepository = remoteRepository.getSubmoduleRepository(submodule.getFile());
                    File subdir = new File(workspace, submodule.getFile());
                    GitAPI subGit = new GitAPI(git.getGitExe(), new FilePath(subdir), listener);
                    subGit.fetch(submoduleRemoteRepository.getUrl(), submoduleRemoteRepository.getRefspec());
                }
                catch (GitException ex) {
                    listener.getLogger().println("Problem fetching from " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
                }
            }
        }
        catch (GitException ex) {
            listener.getLogger().println("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getUrl() + " - could be unavailable. Continuing anyway");
        }
    }

    private boolean changeLogResult(String changeLog, File changelogFile) throws IOException {
        if (changeLog == null) {
            return false;
        }
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        fos.write(changeLog.getBytes());
        fos.close();
        return true;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        String projectName = build.getProject().getName();
        int buildNumber = build.getNumber();
        String gitExe = this.getDescriptor().getGitExe();
        String buildnumber = "hudson-" + projectName + "-" + buildNumber;
        Revision revToBuild = (Revision)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        if (this.doMerge && !revToBuild.containsBranchName(this.getMergeTarget())) {
            String changeLog = (String)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
            return this.changeLogResult(changeLog, changelogFile);
        }
        String changeLog = (String)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        return this.changeLogResult(changeLog, changelogFile);
    }

    private Set<Revision> branchesThatNeedBuilding(IGitAPI git, File workspace, TaskListener listener) throws IOException {
        HashSet<String> setOfThingsBuilt = new HashSet<String>();
        HashSet<Revision> branchesThatNeedBuilding = new HashSet<Revision>();
        for (Tag tag : git.getHudsonTags()) {
            setOfThingsBuilt.add(tag.getCommitSHA1());
        }
        if (this.branch == null) {
            for (Revision revision : new GitUtils(listener, git).getTipBranches()) {
                if (setOfThingsBuilt.contains(revision.getSha1())) continue;
                branchesThatNeedBuilding.add(revision);
            }
        } else {
            Revision revision = new Revision(git.revParse(this.branch));
            if (!setOfThingsBuilt.contains(revision.getSha1())) {
                branchesThatNeedBuilding.add(revision);
            }
        }
        return branchesThatNeedBuilding;
    }

    private static String whenWasBranchLastBuilt(IGitAPI git, String branchId, File workspace, TaskListener listener) throws IOException {
        HashSet<String> setOfThingsBuilt = new HashSet<String>();
        for (Tag tag : git.getHudsonTags()) {
            setOfThingsBuilt.add(tag.getCommitSHA1());
        }
        if (setOfThingsBuilt.isEmpty()) {
            return null;
        }
        for (String rev : git.revListBranch(branchId)) {
            if (!setOfThingsBuilt.contains(rev)) continue;
            return rev;
        }
        return null;
    }

    private String putChangelogDiffsIntoFile(IGitAPI git, String revFrom, String revTo) throws IOException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        git.changelog(revFrom, revTo, (OutputStream)fos);
        fos.close();
        return fos.toString();
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public boolean getDoMerge() {
        return this.doMerge;
    }

    public boolean getDoGenerate() {
        return this.doGenerateSubmoduleConfigurations;
    }

    public String getMergeTarget() {
        return this.mergeTarget;
    }

    public String getRemoteMergeTarget() {
        return "origin/" + this.mergeTarget;
    }

    static /* synthetic */ void access$000(GitSCM x0, IGitAPI x1, File x2, TaskListener x3, RemoteRepository x4) {
        x0.fetchFrom(x1, x2, x3, x4);
    }

    static /* synthetic */ Set access$100(GitSCM x0, IGitAPI x1, File x2, TaskListener x3) throws IOException {
        return x0.branchesThatNeedBuilding(x1, x2, x3);
    }

    static /* synthetic */ String access$200(GitSCM x0) {
        return x0.source;
    }

    static /* synthetic */ String access$300(IGitAPI x0, String x1, File x2, TaskListener x3) throws IOException {
        return GitSCM.whenWasBranchLastBuilt((IGitAPI)x0, (String)x1, (File)x2, (TaskListener)x3);
    }

    static /* synthetic */ String access$400(GitSCM x0, IGitAPI x1, String x2, String x3) throws IOException {
        return x0.putChangelogDiffsIntoFile(x1, x2, x3);
    }

    static /* synthetic */ boolean access$500(GitSCM x0) {
        return x0.doGenerateSubmoduleConfigurations;
    }

    static /* synthetic */ Collection access$600(GitSCM x0) {
        return x0.submoduleCfg;
    }
}

