/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import java.io.Serializable;

public class RemoteRepository
implements Serializable {
    private String name;
    private String url;
    private String refspec;
    private boolean isCentralisedRepository = false;

    public boolean isCentralisedRepository() {
        return this.isCentralisedRepository;
    }

    public void setCentralisedRepository(boolean isCentralisedRepository) {
        this.isCentralisedRepository = isCentralisedRepository;
    }

    public RemoteRepository() {
    }

    public RemoteRepository(String name, String url, String refspec) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("You must name a repository");
        }
        this.name = name;
        this.url = url;
        this.refspec = refspec;
        if (this.refspec == null || this.refspec.length() == 0) {
            this.refspec = "+refs/heads/*:refs/remotes/" + name + "/*";
        }
    }

    public RemoteRepository getSubmoduleRepository(String name) {
        String refUrl = this.url;
        if (refUrl.endsWith("/.git")) {
            refUrl = refUrl.substring(0, refUrl.length() - 4);
        }
        if (!refUrl.endsWith("/")) {
            refUrl = refUrl + "/";
        }
        if (!(refUrl = refUrl + name).endsWith("/")) {
            refUrl = refUrl + "/";
        }
        refUrl = refUrl + ".git";
        return new RemoteRepository(name, refUrl, this.refspec);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRefspec() {
        return this.refspec;
    }

    public void setRefspec(String refspec) {
        this.refspec = refspec;
    }
}

