/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Tag;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitAPI
implements IGitAPI {
    Launcher launcher;
    FilePath workspace;
    TaskListener listener;
    String gitExe;

    public GitAPI(String gitExe, FilePath workspace, TaskListener listener) {
        this.workspace = workspace;
        this.listener = listener;
        this.gitExe = gitExe;
        this.launcher = new Launcher.LocalLauncher(listener);
    }

    @Override
    public String getGitExe() {
        return this.gitExe;
    }

    @Override
    public boolean hasGitRepo() throws GitException {
        try {
            FilePath dotGit = this.workspace.child(".git");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .git. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git", e);
        }
    }

    @Override
    public boolean hasGitModules() throws GitException {
        try {
            FilePath dotGit = this.workspace.child(".gitmodules");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .gitmodules. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules");
        }
    }

    @Override
    public void fetch(String repository, String refspec) throws GitException {
        this.listener.getLogger().println("Fetching upstream changes" + (repository != null ? " from " + repository : ""));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "fetch"});
        if (repository != null) {
            args.add(repository);
            if (refspec != null) {
                args.add(refspec);
            }
        }
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)this.listener.getLogger(), this.workspace).join() != 0) {
                throw new GitException("Failed to fetch");
            }
        }
        catch (IOException e) {
            throw new GitException("Failed to fetch", e);
        }
        catch (InterruptedException e) {
            throw new GitException("Failed to fetch", e);
        }
    }

    @Override
    public void fetch() throws GitException {
        this.fetch(null, null);
    }

    @Override
    public void clone(String source) throws GitException {
        this.listener.getLogger().println("Cloning repository " + source);
        try {
            this.workspace.deleteRecursive();
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.error("Failed to clean the workspace"));
            throw new GitException("Failed to delete workspace", e);
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "clone"});
        try {
            args.add(new String[]{source, this.workspace.toURI().getPath()});
        }
        catch (IOException e1) {
            throw new GitException(e1);
        }
        catch (InterruptedException e1) {
            throw new GitException(e1);
        }
        int processResult = 0;
        try {
            processResult = this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)this.listener.getLogger(), null).join();
        }
        catch (IOException e) {
            throw new GitException("Error running clone", e);
        }
        catch (InterruptedException e) {
            throw new GitException("Error running clone", e);
        }
        if (processResult != 0) {
            throw new GitException("Clone returned an error code");
        }
    }

    @Override
    public String revParse(String revName) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "rev-parse", revName});
        String result = this.launchCommand(args.toCommandArray());
        return this.firstLine(result).trim();
    }

    private String firstLine(String result) {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (reader.readLine() != null) {
                throw new GitException("Result has multiple lines");
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing result");
        }
        return line;
    }

    private String showTag(String refName) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "show-ref", "-s", "--tags", refName});
        String result = this.launchCommand(args.toCommandArray());
        return this.firstLine(result).trim();
    }

    private void log(String revFrom, String revTo, OutputStream fos, String ... extraargs) throws GitException {
        String revSpec = revFrom == null ? revTo : revFrom + ".." + revTo;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "log"});
        args.add(extraargs);
        args.add(revSpec);
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), fos, this.workspace).join() != 0) {
                throw new GitException("Error launching git log");
            }
        }
        catch (Exception e) {
            throw new GitException("Error performing git log", e);
        }
    }

    @Override
    public void changelog(String revFrom, String revTo, OutputStream fos) throws GitException {
        this.log(revFrom, revTo, fos, "--numstat", "-M", "--summary", "--pretty=raw");
    }

    @Override
    public void merge(String revSpec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "merge", revSpec});
        this.launch(args.toCommandArray(), "Error in merge");
    }

    private void launch(String[] args, String error) {
        try {
            if (this.launcher.launch(args, this.createEnvVarMap(), (OutputStream)this.listener.getLogger(), this.workspace).join() != 0) {
                throw new GitException(error);
            }
        }
        catch (Exception e) {
            throw new GitException(error, e);
        }
    }

    @Override
    public void submoduleInit() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "submodule", "init"});
        this.launch(args.toCommandArray(), "Error in submodule init");
    }

    @Override
    public void submoduleUpdate() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "submodule", "update"});
        this.launch(args.toCommandArray(), "Error in submodule update");
    }

    protected final Map<String, String> createEnvVarMap() {
        HashMap<String, String> env = new HashMap<String, String>();
        return env;
    }

    @Override
    public void tag(String tagName, String comment) throws GitException {
        tagName = tagName.replace(' ', '_');
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "tag", "-a", "-f", tagName, "-m", comment});
        this.launch(args.toCommandArray(), "Error in tag");
    }

    private String launchCommand(String[] args) throws GitException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            int status = this.launcher.launch(args, this.createEnvVarMap(), (OutputStream)fos, this.workspace).join();
            String result = fos.toString();
            if (status != 0) {
                throw new GitException("Command returned status code " + status + ": " + result);
            }
            return result;
        }
        catch (Exception e) {
            throw new GitException("Error performing " + StringUtils.join((Object[])args, (String)" "), e);
        }
    }

    @Override
    public List<Tag> getHudsonTags() throws GitException {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "tag", "-l", "hudson-*"});
        BufferedReader rdr = new BufferedReader(new StringReader(this.launchCommand(args.toCommandArray())));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                Tag t = new Tag(line, this.showTag(line));
                t.setCommitSHA1(this.getTagCommit(t.getSHA1()));
                tags.add(t);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing tags", e);
        }
        return tags;
    }

    @Override
    public void push(String refspec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "push", "--tags", "origin"});
        if (refspec != null) {
            args.add(refspec);
        }
        this.launchCommand(args.toCommandArray());
    }

    private List<Branch> parseBranches(String fos) throws GitException {
        ArrayList<Branch> tags = new ArrayList<Branch>();
        BufferedReader rdr = new BufferedReader(new StringReader(fos));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if ((line = line.substring(2)).startsWith("(")) continue;
                tags.add(new Branch(line, this.revParse(line)));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing branches", e);
        }
        return tags;
    }

    @Override
    public List<Branch> getBranches() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "branch", "-a"});
        return this.parseBranches(this.launchCommand(args.toCommandArray()));
    }

    @Override
    public List<Branch> getBranchesContaining(String revspec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "branch", "-a", "--contains", revspec});
        return this.parseBranches(this.launchCommand(args.toCommandArray()));
    }

    @Override
    public void checkout(String ref) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "checkout", "-f", ref});
        this.launch(args.toCommandArray(), "Error in checkout");
    }

    @Override
    public void deleteTag(String tagName) throws GitException {
        tagName = tagName.replace(' ', '_');
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "tag", "-d", tagName});
        this.launch(args.toCommandArray(), "Error in deleteTag");
    }

    private String getTagCommit(String tagName) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "cat-file", "-p", tagName});
        String result = this.launchCommand(args.toCommandArray());
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if (!line.startsWith("object")) continue;
                return line.substring(7);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing tag commit", e);
        }
        return null;
    }

    @Override
    public List<IndexEntry> lsTree(String treeIsh) throws GitException {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "ls-tree", treeIsh});
        String result = this.launchCommand(args.toCommandArray());
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] entry = line.split("\\s+");
                entries.add(new IndexEntry(entry[0], entry[1], entry[2], entry[3]));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing ls tree", e);
        }
        return entries;
    }

    @Override
    public List<String> revListAll() throws GitException {
        return this.revList("--all");
    }

    @Override
    public List<String> revListBranch(String branchId) throws GitException {
        return this.revList(branchId);
    }

    public List<String> revList(String ... extraArgs) throws GitException {
        ArrayList<String> entries = new ArrayList<String>();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "rev-list"});
        args.add(extraArgs);
        String result = this.launchCommand(args.toCommandArray());
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                entries.add(line);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing rev list", e);
        }
        return entries;
    }

    @Override
    public void add(String filePattern) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "add", filePattern});
        this.launch(args.toCommandArray(), "Error in add");
    }

    @Override
    public void branch(String name) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "branch", name});
        this.launch(args.toCommandArray(), "Error in branch");
    }

    @Override
    public void commit(File f) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "commit", "-F", f.getAbsolutePath()});
        this.launch(args.toCommandArray(), "Error in commit");
    }
}

