/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.RemoteRepository;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleCombinator;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.Tag;
import hudson.plugins.git.browser.GitWeb;
import hudson.plugins.git.util.GitUtils;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormFieldValidator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends SCM
implements Serializable {
    private final String source;
    private List<RemoteRepository> repositories;
    private final String branch;
    private final boolean doMerge;
    private final boolean doGenerateSubmoduleConfigurations;
    private final String mergeTarget;
    private GitWeb browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    private static final long serialVersionUID = 1L;

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    @DataBoundConstructor
    public GitSCM(String source, String branch, boolean doMerge, boolean doGenerateSubmoduleConfigurations, String mergeTarget, List<RemoteRepository> repositories, Collection<SubmoduleConfig> submoduleCfg, GitWeb browser) {
        this.source = source;
        branch = Util.fixEmpty((String)branch);
        this.repositories = repositories;
        this.branch = branch;
        this.browser = browser;
        this.doMerge = doMerge;
        this.mergeTarget = mergeTarget;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations;
        this.submoduleCfg = submoduleCfg;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch == null ? "" : this.branch;
    }

    public GitWeb getBrowser() {
        return this.browser;
    }

    public List<RemoteRepository> getRepositories() {
        if (this.repositories == null) {
            return new ArrayList<RemoteRepository>();
        }
        return this.repositories;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, final TaskListener listener) throws IOException, InterruptedException {
        final String gitExe = this.getDescriptor().getGitExe();
        boolean pollChangesResult = (Boolean)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

            public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
                GitAPI git = new GitAPI(gitExe, new FilePath(workspace), listener);
                listener.getLogger().println("Poll for changes");
                if (git.hasGitRepo()) {
                    listener.getLogger().println("Update repository");
                    git.fetch();
                    for (RemoteRepository remoteRepository : GitSCM.this.getRepositories()) {
                        GitSCM.this.fetchFrom(git, workspace, listener, remoteRepository);
                    }
                    return GitSCM.this.branchesThatNeedBuilding(git, workspace, listener).size() > 0;
                }
                return true;
            }
        });
        return pollChangesResult;
    }

    private void fetchFrom(IGitAPI git, File workspace, TaskListener listener, RemoteRepository remoteRepository) {
        try {
            git.fetch(remoteRepository.getUrl(), remoteRepository.getRefspec());
            List<IndexEntry> submodules = new GitUtils(listener, git).getSubmodules("HEAD");
            for (IndexEntry submodule : submodules) {
                try {
                    RemoteRepository submoduleRemoteRepository = remoteRepository.getSubmoduleRepository(submodule.getFile());
                    File subdir = new File(workspace, submodule.getFile());
                    GitAPI subGit = new GitAPI(git.getGitExe(), new FilePath(subdir), listener);
                    subGit.fetch(submoduleRemoteRepository.getUrl(), submoduleRemoteRepository.getRefspec());
                }
                catch (GitException ex) {
                    listener.getLogger().println("Problem fetching from " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
                }
            }
        }
        catch (GitException ex) {
            listener.getLogger().println("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getUrl() + " - could be unavailable. Continuing anyway");
        }
    }

    private boolean changeLogResult(String changeLog, File changelogFile) throws IOException {
        if (changeLog == null) {
            return false;
        }
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        fos.write(changeLog.getBytes());
        fos.close();
        return true;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, final BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        String projectName = build.getProject().getName();
        final int buildNumber = build.getNumber();
        final String gitExe = this.getDescriptor().getGitExe();
        final String buildnumber = "hudson-" + projectName + "-" + buildNumber;
        final Revision revToBuild = (Revision)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Revision>(){

            public Revision invoke(File workspace, VirtualChannel channel) throws IOException {
                GitAPI git = new GitAPI(gitExe, new FilePath(workspace), (TaskListener)listener);
                if (git.hasGitRepo()) {
                    listener.getLogger().println("Checkout (update)");
                    git.fetch();
                    for (RemoteRepository remoteRepository : GitSCM.this.getRepositories()) {
                        try {
                            git.fetch(remoteRepository.getUrl(), remoteRepository.getRefspec());
                        }
                        catch (GitException ex) {
                            listener.getLogger().println("Problem fetching from " + remoteRepository.getName() + " - could be unavailable. Continuing anyway");
                        }
                    }
                } else {
                    listener.getLogger().println("Checkout (clone)");
                    git.clone(GitSCM.this.source);
                    if (git.hasGitModules()) {
                        git.submoduleInit();
                        git.submoduleUpdate();
                    }
                }
                Set toBeBuilt = GitSCM.this.branchesThatNeedBuilding(git, workspace, (TaskListener)listener);
                String log = "Candidate revisions to be built: ";
                for (Revision b : toBeBuilt) {
                    log = log + b.toString() + "; ";
                }
                listener.getLogger().println(log);
                Revision revToBuild = null;
                if (toBeBuilt.size() == 0) {
                    revToBuild = new Revision(git.revParse("HEAD"));
                    listener.getLogger().println("Nothing to do (no unbuilt branches) - rebuilding HEAD " + revToBuild);
                } else {
                    revToBuild = (Revision)toBeBuilt.iterator().next();
                }
                return revToBuild;
            }
        });
        if (this.doMerge && !revToBuild.containsBranchName(this.getMergeTarget())) {
            String changeLog = (String)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

                public String invoke(File workspace, VirtualChannel channel) throws IOException {
                    GitAPI git = new GitAPI(gitExe, new FilePath(workspace), (TaskListener)listener);
                    listener.getLogger().println("Merging " + revToBuild + " onto " + GitSCM.this.getMergeTarget());
                    git.checkout(GitSCM.this.getRemoteMergeTarget());
                    try {
                        git.merge(revToBuild.getSha1());
                    }
                    catch (Exception ex) {
                        listener.getLogger().println("Branch not suitable for integration as it does not merge cleanly");
                        git.checkout(revToBuild.getSha1());
                        git.tag(buildnumber, "Hudson Build #" + buildNumber);
                        return null;
                    }
                    if (git.hasGitModules()) {
                        git.submoduleUpdate();
                    }
                    git.tag(buildnumber, "Hudson Build #" + buildNumber);
                    String lastRevWas = GitSCM.whenWasBranchLastBuilt(git, revToBuild.getSha1(), workspace, (TaskListener)listener);
                    return GitSCM.this.putChangelogDiffsIntoFile(git, lastRevWas, git.revParse("HEAD"));
                }
            });
            return this.changeLogResult(changeLog, changelogFile);
        }
        String changeLog = (String)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

            public String invoke(File workspace, VirtualChannel channel) throws IOException {
                GitAPI git = new GitAPI(gitExe, new FilePath(workspace), (TaskListener)listener);
                listener.getLogger().println("Checking out " + revToBuild);
                git.checkout(revToBuild.getSha1());
                if (GitSCM.this.doGenerateSubmoduleConfigurations) {
                    SubmoduleCombinator combinator = new SubmoduleCombinator(git, (TaskListener)listener, workspace, GitSCM.this.submoduleCfg);
                    combinator.createSubmoduleCombinations();
                }
                if (git.hasGitModules()) {
                    git.submoduleInit();
                    for (RemoteRepository remoteRepository : GitSCM.this.getRepositories()) {
                        GitSCM.this.fetchFrom(git, workspace, (TaskListener)listener, remoteRepository);
                    }
                    git.submoduleUpdate();
                }
                String lastRevWas = GitSCM.whenWasBranchLastBuilt(git, revToBuild.getSha1(), workspace, (TaskListener)listener);
                git.tag(buildnumber, "Hudson Build #" + buildNumber);
                if (lastRevWas == null) {
                    return "First Time Build of Branch.";
                }
                return GitSCM.this.putChangelogDiffsIntoFile(git, lastRevWas, revToBuild.getSha1());
            }
        });
        return this.changeLogResult(changeLog, changelogFile);
    }

    private Set<Revision> branchesThatNeedBuilding(IGitAPI git, File workspace, TaskListener listener) throws IOException {
        HashSet<String> setOfThingsBuilt = new HashSet<String>();
        HashSet<Revision> branchesThatNeedBuilding = new HashSet<Revision>();
        for (Tag tag : git.getHudsonTags()) {
            setOfThingsBuilt.add(tag.getCommitSHA1());
        }
        if (this.branch == null) {
            for (Revision revision : new GitUtils(listener, git).getTipBranches()) {
                if (setOfThingsBuilt.contains(revision.getSha1())) continue;
                branchesThatNeedBuilding.add(revision);
            }
        } else {
            Revision revision = new Revision(git.revParse(this.branch));
            if (!setOfThingsBuilt.contains(revision.getSha1())) {
                branchesThatNeedBuilding.add(revision);
            }
        }
        return branchesThatNeedBuilding;
    }

    private static String whenWasBranchLastBuilt(IGitAPI git, String branchId, File workspace, TaskListener listener) throws IOException {
        HashSet<String> setOfThingsBuilt = new HashSet<String>();
        for (Tag tag : git.getHudsonTags()) {
            setOfThingsBuilt.add(tag.getCommitSHA1());
        }
        if (setOfThingsBuilt.isEmpty()) {
            return null;
        }
        for (String rev : git.revListBranch(branchId)) {
            if (!setOfThingsBuilt.contains(rev)) continue;
            return rev;
        }
        return null;
    }

    private String putChangelogDiffsIntoFile(IGitAPI git, String revFrom, String revTo) throws IOException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        git.changelog(revFrom, revTo, fos);
        fos.close();
        return fos.toString();
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public boolean getDoMerge() {
        return this.doMerge;
    }

    public boolean getDoGenerate() {
        return this.doGenerateSubmoduleConfigurations;
    }

    public String getMergeTarget() {
        return this.mergeTarget;
    }

    public String getRemoteMergeTarget() {
        return "origin/" + this.mergeTarget;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends SCMDescriptor<GitSCM> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private String gitExe;

        private DescriptorImpl() {
            super(GitSCM.class, GitWeb.class);
            this.load();
        }

        public String getDisplayName() {
            return "Git";
        }

        public String getGitExe() {
            if (this.gitExe == null) {
                return "git";
            }
            return this.gitExe;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
            String[] names = req.getParameterValues("git.repo.name");
            String[] urls = req.getParameterValues("git.repo.url");
            String[] refs = req.getParameterValues("git.repo.refspec");
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    remoteRepositories.add(new RemoteRepository(names[i], urls[i], refs[i]));
                }
            }
            ArrayList<SubmoduleConfig> submoduleCfg = new ArrayList<SubmoduleConfig>();
            String[] submoduleName = req.getParameterValues("git.submodule.name");
            String[] submoduleMatch = req.getParameterValues("git.submodule.match");
            if (submoduleName != null) {
                for (int i = 0; i < submoduleName.length; ++i) {
                    SubmoduleConfig cfg = new SubmoduleConfig();
                    cfg.setSubmoduleName(submoduleName[i]);
                    cfg.setBranches(submoduleMatch[i].split(","));
                    submoduleCfg.add(cfg);
                }
            }
            return new GitSCM(req.getParameter("git.source"), req.getParameter("git.branch"), req.getParameter("git.merge") != null, req.getParameter("git.generate") != null, req.getParameter("git.mergeTarget"), remoteRepositories, submoduleCfg, (GitWeb)RepositoryBrowsers.createInstance(GitWeb.class, (StaplerRequest)req, (String)"git.browser"));
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.gitExe = req.getParameter("git.gitExe");
            this.save();
            return true;
        }

        public void doGitExeCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.Executable(req, rsp){

                protected void checkExecutable(File exe) throws IOException, ServletException {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch(new String[]{DescriptorImpl.this.getGitExe(), "--version"}, new String[0], (OutputStream)baos, null);
                        proc.join();
                        this.ok();
                    }
                    catch (InterruptedException e) {
                        this.error("Unable to check git version");
                    }
                    catch (RuntimeException e) {
                        this.error("Unable to check git version");
                    }
                }
            }.process();
        }
    }
}

