/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.Tag;
import org.spearce.jgit.transport.RefSpec;
import org.spearce.jgit.transport.RemoteConfig;
import org.spearce.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitAPI
implements IGitAPI {
    Launcher launcher;
    FilePath workspace;
    TaskListener listener;
    String gitExe;

    public GitAPI(String gitExe, FilePath workspace, TaskListener listener) {
        this.workspace = workspace;
        this.listener = listener;
        this.gitExe = gitExe;
        this.launcher = new Launcher.LocalLauncher(listener);
    }

    public String getGitExe() {
        return this.gitExe;
    }

    public boolean hasGitRepo() throws GitException {
        try {
            FilePath dotGit = this.workspace.child(".git");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .git. Are you sure you have correct permissions?", (Throwable)ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git", (Throwable)e);
        }
    }

    public boolean hasGitModules() throws GitException {
        try {
            FilePath dotGit = this.workspace.child(".gitmodules");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .gitmodules. Are you sure you have correct permissions?", (Throwable)ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules");
        }
    }

    public void fetch(String repository, String refspec) throws GitException {
        this.listener.getLogger().println("Fetching upstream changes" + (repository != null ? " from " + repository : ""));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "fetch"});
        if (repository != null) {
            args.add(repository);
            if (refspec != null) {
                args.add(refspec);
            }
        }
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)this.listener.getLogger(), this.workspace).join() != 0) {
                throw new GitException("Failed to fetch");
            }
        }
        catch (IOException e) {
            throw new GitException("Failed to fetch", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new GitException("Failed to fetch", (Throwable)e);
        }
    }

    public void fetch() throws GitException {
        this.fetch(null, null);
    }

    public void clone(RemoteConfig remoteConfig) throws GitException {
        this.listener.getLogger().println("Cloning repository " + remoteConfig.getName());
        try {
            this.workspace.deleteRecursive();
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.error("Failed to clean the workspace"));
            throw new GitException("Failed to delete workspace", (Throwable)e);
        }
        String source = ((URIish)remoteConfig.getURIs().get(0)).toString();
        try {
            this.workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            throw new GitException("Could not clone " + source, (Throwable)e);
        }
    }

    public ObjectId revParse(String revName) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "rev-parse", revName});
        String result = this.launchCommand(args.toCommandArray());
        return ObjectId.fromString((String)this.firstLine(result).trim());
    }

    public String describe(String commitIsh) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "describe", "--tags", commitIsh});
        String result = this.launchCommand(args.toCommandArray());
        return this.firstLine(result).trim();
    }

    private String firstLine(String result) {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (reader.readLine() != null) {
                throw new GitException("Result has multiple lines");
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing result");
        }
        return line;
    }

    private void log(String revFrom, String revTo, OutputStream fos, String ... extraargs) throws GitException {
        String revSpec = revFrom == null ? revTo : revFrom + ".." + revTo;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "log"});
        args.add(extraargs);
        args.add(revSpec);
        try {
            if (this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), fos, this.workspace).join() != 0) {
                throw new GitException("Error launching git log");
            }
        }
        catch (Exception e) {
            throw new GitException("Error performing git log", (Throwable)e);
        }
    }

    public void changelog(String revFrom, String revTo, OutputStream fos) throws GitException {
        this.log(revFrom, revTo, fos, new String[]{"--numstat", "-M", "--summary", "--pretty=raw"});
    }

    public void merge(String revSpec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "merge", revSpec});
        try {
            this.launchCommand(args.toCommandArray());
        }
        catch (GitException e) {
            throw new GitException("Could not merge " + revSpec, (Throwable)e);
        }
    }

    public void submoduleInit() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "submodule", "init"});
        this.launchCommand(args.toCommandArray());
    }

    public void submoduleUpdate() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "submodule", "update"});
        this.launchCommand(args.toCommandArray());
    }

    protected final Map<String, String> createEnvVarMap() {
        HashMap<String, String> env = new HashMap<String, String>();
        return env;
    }

    public void tag(String tagName, String comment) throws GitException {
        tagName = tagName.replace(' ', '_');
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "tag", "-a", "-f", "-m", comment, tagName});
        try {
            this.launchCommand(args.toCommandArray());
        }
        catch (GitException e) {
            throw new GitException("Could not apply tag " + tagName, (Throwable)e);
        }
    }

    private String launchCommand(String[] args) throws GitException {
        return this.launchCommandIn(args, this.workspace);
    }

    private String launchCommandIn(String[] args, FilePath workDir) throws GitException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            int status = this.launcher.launch(args, this.createEnvVarMap(), (OutputStream)fos, workDir).join();
            String result = fos.toString();
            System.out.println(result);
            if (status != 0) {
                throw new GitException("Command returned status code " + status + ": " + result);
            }
            return result;
        }
        catch (Exception e) {
            throw new GitException("Error performing " + StringUtils.join((Object[])args, (String)" "), (Throwable)e);
        }
    }

    public void push(RemoteConfig repository, String refspec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "push", ((URIish)repository.getURIs().get(0)).toString()});
        if (refspec != null) {
            args.add(refspec);
        }
        this.launchCommand(args.toCommandArray());
    }

    private List<Branch> parseBranches(String fos) throws GitException {
        ArrayList<Branch> tags = new ArrayList<Branch>();
        BufferedReader rdr = new BufferedReader(new StringReader(fos));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if ((line = line.substring(2)).startsWith("(")) continue;
                tags.add(new Branch(line, this.revParse(line)));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing branches", (Throwable)e);
        }
        return tags;
    }

    public List<Branch> getBranches() throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "branch", "-a"});
        return this.parseBranches(this.launchCommand(args.toCommandArray()));
    }

    public List<Branch> getRemoteBranches() throws GitException, IOException {
        Repository db = this.getRepository();
        Map refs = db.getAllRefs();
        ArrayList<Branch> branches = new ArrayList<Branch>();
        for (Ref candidate : refs.values()) {
            if (!candidate.getName().startsWith("refs/remotes/")) continue;
            Branch buildBranch = new Branch(candidate);
            this.listener.getLogger().println("Seen branch in repository " + buildBranch.getName());
            branches.add(buildBranch);
        }
        return branches;
    }

    public List<Branch> getBranchesContaining(String revspec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "branch", "-a", "--contains", revspec});
        return this.parseBranches(this.launchCommand(args.toCommandArray()));
    }

    public void checkout(String ref) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "checkout", "-f", ref.toString()});
        try {
            this.launchCommand(args.toCommandArray());
        }
        catch (GitException e) {
            throw new GitException("Could not checkout " + ref, (Throwable)e);
        }
    }

    public void deleteTag(String tagName) throws GitException {
        tagName = tagName.replace(' ', '_');
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "tag", "-d", tagName});
        try {
            this.launchCommand(args.toCommandArray());
        }
        catch (GitException e) {
            throw new GitException("Could not delete tag " + tagName, (Throwable)e);
        }
    }

    public List<IndexEntry> lsTree(String treeIsh) throws GitException {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "ls-tree", treeIsh});
        String result = this.launchCommand(args.toCommandArray());
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] entry = line.split("\\s+");
                entries.add(new IndexEntry(entry[0], entry[1], entry[2], entry[3]));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing ls tree", (Throwable)e);
        }
        return entries;
    }

    public List<ObjectId> revListAll() throws GitException {
        return this.revList(new String[]{"--all"});
    }

    public List<ObjectId> revListBranch(String branchId) throws GitException {
        return this.revList(new String[]{branchId});
    }

    public List<ObjectId> revList(String ... extraArgs) throws GitException {
        ArrayList<ObjectId> entries = new ArrayList<ObjectId>();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "rev-list"});
        args.add(extraArgs);
        String result = this.launchCommand(args.toCommandArray());
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                entries.add(ObjectId.fromString((String)line));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing rev list", (Throwable)e);
        }
        return entries;
    }

    public void add(String filePattern) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "add", filePattern});
        try {
            this.launchCommand(args.toCommandArray());
        }
        catch (GitException e) {
            throw new GitException("Cannot add " + filePattern, (Throwable)e);
        }
    }

    public void branch(String name) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "branch", name});
        try {
            this.launchCommand(args.toCommandArray());
        }
        catch (GitException e) {
            throw new GitException("Cannot create branch " + name, (Throwable)e);
        }
    }

    public void commit(File f) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "commit", "-F", f.getAbsolutePath()});
        try {
            this.launchCommand(args.toCommandArray());
        }
        catch (GitException e) {
            throw new GitException("Cannot commit " + f, (Throwable)e);
        }
    }

    public void fetch(RemoteConfig remoteRepository) throws GitException {
        this.fetch(((URIish)remoteRepository.getURIs().get(0)).toString(), ((RefSpec)remoteRepository.getFetchRefSpecs().get(0)).toString());
    }

    public ObjectId mergeBase(ObjectId id1, ObjectId id2) {
        try {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{this.getGitExe(), "merge-base", id1.name(), id2.name()});
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            int status = this.launcher.launch(args.toCommandArray(), this.createEnvVarMap(), (OutputStream)fos, this.workspace).join();
            String result = fos.toString();
            if (status != 0) {
                return null;
            }
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            String line = rdr.readLine();
            if (line != null) {
                return ObjectId.fromString((String)line);
            }
        }
        catch (Exception e) {
            throw new GitException("Error parsing merge base", (Throwable)e);
        }
        return null;
    }

    private Repository getRepository() throws IOException {
        return new Repository(new File(this.workspace.getRemote(), ".git"));
    }

    public List<Tag> getTagsOnCommit(String revName) throws GitException, IOException {
        Repository db = this.getRepository();
        ObjectId commit = db.resolve(revName);
        ArrayList<Tag> ret = new ArrayList<Tag>();
        for (Map.Entry tag : db.getTags().entrySet()) {
            Tag ttag = db.mapTag((String)tag.getKey());
            if (!ttag.getObjId().equals(commit)) continue;
            ret.add(ttag);
        }
        return ret;
    }

    static /* synthetic */ String access$000(GitAPI x0, String[] x1, FilePath x2) throws GitException {
        return x0.launchCommandIn(x1, x2);
    }
}

