/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.git.GitPublisher;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.tasks.Publisher;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitPublisher
extends Publisher
implements Serializable {
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        boolean canPerform;
        SCM scm = build.getProject().getScm();
        if (!(scm instanceof GitSCM)) {
            return false;
        }
        String projectName = build.getProject().getName();
        int buildNumber = build.getNumber();
        Result buildResult = build.getResult();
        try {
            canPerform = (Boolean)build.getProject().getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Throwable e) {
            listener.error("Failed to push tags to origin repository: " + e.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        return canPerform;
    }
}

